---
generated_at: 2026-02-04 10:00:00
metrics:
  claims_total: 35
  claims_with_evidence: 32
  claims_without_evidence: 3
confidence_derived: 0.91
---

# 根拠レポート：セキュリティ設計書

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.91**
  - 根拠あり：32 / 35、根拠なし：3
- 優先レビュー（高）
  1. **CSRF対策の不在の断定**：コードベース全体の網羅的確認が必要
  2. **CORS設定の不在の断定**：フレームワーク外部の設定やプロキシ設定の可能性あり
  3. **イベントログの保持期間**：History Serverの設定ファイル等の確認が必要

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `core/src/main/scala/org/apache/spark/SecurityManager.scala`
- E-02: `core/src/main/scala/org/apache/spark/SSLOptions.scala`
- E-03: `core/src/main/scala/org/apache/spark/security/CryptoStreamUtils.scala`
- E-04: `core/src/main/scala/org/apache/spark/ui/HttpSecurityFilter.scala`
- E-05: `core/src/main/scala/org/apache/spark/security/SocketAuthHelper.scala`
- E-06: `core/src/main/scala/org/apache/spark/security/SocketAuthServer.scala`
- E-07: `core/src/main/scala/org/apache/spark/deploy/security/HadoopDelegationTokenManager.scala`
- E-08: `core/src/main/scala/org/apache/spark/security/HadoopDelegationTokenProvider.scala`
- E-09: `core/src/main/scala/org/apache/spark/security/GroupMappingServiceProvider.scala`
- E-10: `core/src/main/scala/org/apache/spark/security/ShellBasedGroupsMappingProvider.scala`
- E-11: `core/src/main/scala/org/apache/spark/internal/config/package.scala`
- E-12: `core/src/main/scala/org/apache/spark/internal/config/UI.scala`
- E-13: `core/src/main/scala/org/apache/spark/internal/config/Network.scala`
- E-14: `core/src/main/scala/org/apache/spark/ui/JettyUtils.scala`
- E-15: `core/src/main/scala/org/apache/spark/serializer/SerializerManager.scala`
- E-16: `core/src/main/scala/org/apache/spark/util/Utils.scala`
- E-17: `core/src/main/scala/org/apache/spark/security/SecurityConfigurationLock.scala`
- E-18: `core/src/main/scala/org/apache/spark/scheduler/EventLoggingListener.scala`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | spark.authenticate設定でネットワーク認証を有効化 | E-01 (L58, L274, L349), E-11 (L1318-1322) | ○ |
| C-02 | 秘密鍵はSecureRandomで256ビット生成される | E-16 (L2949-2955), E-11 (L1312-1316) | ○ |
| C-03 | 秘密鍵の提供方法（UGI Credentials、環境変数、設定値、ファイル） | E-01 (L314-335, L386-400) | ○ |
| C-04 | SASLユーザは固定値sparkSaslUser | E-01 (L308) | ○ |
| C-05 | HadoopDelegationTokenManagerによるKerberos認証 | E-07 (L65-68, L70-74) | ○ |
| C-06 | TGT自動更新とspark.kerberos.relogin.period制御 | E-07 (L115-123) | ○ |
| C-07 | 委任トークンは有効期間の75%経過時に自動更新 | E-07 (L236-243) | ○ |
| C-08 | SocketAuthHelperによるソケット認証プロトコル | E-05 (L39-128) | ○ |
| C-09 | 認証タイムアウト10秒 | E-05 (L66) | ○ |
| C-10 | Unixドメインソケット使用時は認証スキップ | E-05 (L56-57, L93-94) | ○ |
| C-11 | ACLベースのアクセス制御（Admin/View/Modify） | E-01 (L59-86, L123-268), E-12 (L171-210) | ○ |
| C-12 | デフォルトユーザ（OSユーザ/SPARK_USER）にView/Modify権限付与 | E-01 (L78-83) | ○ |
| C-13 | ワイルドカード(*)による全ユーザ許可 | E-01 (L57, L402-416) | ○ |
| C-14 | GroupMappingServiceProviderによるプラガブルなグループ解決 | E-09, E-10, E-12 (L212-215) | ○ |
| C-15 | doAsパラメータによるImpersonationはAdmin権限が必要 | E-04 (L57-66) | ○ |
| C-16 | SSLOptionsによる包括的SSL/TLS設定 | E-02 (L65-84, L234-333) | ○ |
| C-17 | HTTPからHTTPSへの自動リダイレクト | E-14 (L396-403, L603-648) | ○ |
| C-18 | HSTSヘッダの設定 | E-04 (L87-89), E-12 (L133-137) | ○ |
| C-19 | RPC SSL設定（spark.ssl.rpc.enabled） | E-01 (L89-91, L110-111), E-02 | ○ |
| C-20 | ネットワーク暗号化とRPC SSLの排他制御 | E-01 (L280-289), E-13 | ○ |
| C-21 | サーバ情報秘匿（ServerVersion/XPoweredBy無効化） | E-14 (L329-332) | ○ |
| C-22 | HTTP TRACEメソッド無効化 | E-14 (L98-100, L163-165) | ○ |
| C-23 | mTLS対応（needClientAuth） | E-02 (L74, L98-107) | ○ |
| C-24 | IO暗号化にAES/CTR/NoPaddingを使用 | E-03, E-11 (L1172-1177) | ○ |
| C-25 | IO暗号化鍵サイズ128/192/256ビット対応 | E-11 (L1166-1170) | ○ |
| C-26 | IVは16バイトでCryptoRandomFactoryにより生成 | E-03 (L44, L127-138) | ○ |
| C-27 | 秘密情報のRedaction（spark.redaction.regex） | E-11 (L1287-1304), E-16 (L2745-2776) | ○ |
| C-28 | SSLパスワードのログマスキング | E-02 (L181-189) | ○ |
| C-29 | XSS対策（XssSafeRequest, HTMLエスケープ） | E-04 (L97-130) | ○ |
| C-30 | CSP/X-Frame-Options/X-XSS-Protection/X-Content-Type-Optionsヘッダ設定 | E-04 (L50-86), E-12 (L121-137) | ○ |
| C-31 | Cache-Control: no-cache, no-store, must-revalidate設定 | E-04 (L50) | ○ |
| C-32 | Jetty IdleTimeout 8000msによるSlow DoS対策 | E-14 (L311) | ○ |
| C-33 | CSRF対策の明示的な機構は確認されない | **根拠なし** | △ |
| C-34 | CORS設定は確認されない | **根拠なし** | △ |
| C-35 | イベントログの保持期間はHistory Server設定に依存 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- C-33（CSRF対策）: coreモジュールのコード解析範囲ではCSRFトークン機構が確認できなかったが、サードパーティフィルタやspark.ui.filtersによるカスタムフィルタで対策されている可能性がある。また、Spark UIは主にGETリクエストを処理するため、CSRFリスクは限定的と考えられる。
  - 候補：サードパーティフィルタの調査 / Kubernetes/YARN環境のプロキシ設定 / カスタムフィルタ設定
- C-34（CORS設定）: Sparkコードベース内に明示的なCORS設定は見当たらなかったが、リバースプロキシやロードバランサで設定される可能性がある。
  - 候補：リバースプロキシの設定確認 / Jetty CORS filter の調査 / spark.ui.filters設定
- C-35（イベントログ保持期間）: EventLoggingListenerはログの書き込みを担当するが、保持期間はHistory Serverの設定（`spark.history.fs.cleaner.*`）に依存する。本解析ではHistory Server設定の詳細を確認していない。
  - 候補：History.scala 設定ファイル / FsHistoryProvider のクリーナー設定

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 認証・認可・暗号化の基本設計は十分に根拠のあるコードに基づいている
- 1: 中リスク - CSRF対策の欠如はSpark UIの利用形態（主にGETリクエスト）によりリスクは限定的だが、Modifyアクション（Kill操作等）においてPOSTリクエストが使用される場合は対策の必要性を検討すべき
- 0: 低リスク - CORS未設定はデフォルトのSame-Originポリシーにより保護される
- 1: 中リスク - デフォルト設定では認証・ACLが無効（spark.authenticate=false, spark.acls.enable=false）であり、本番環境では明示的な有効化が必要

## 6) レビュアーチェックリスト（最小）
- [ ] 認証方式（共有秘密鍵、Kerberos、ソケット認証）の記述がコードと整合しているか確認
- [ ] ACL判定ロジック（isUserInACL）の記述が実装と一致しているか確認
- [ ] SSL/TLS設定の階層構造（デフォルト/モジュール固有）の記述が正確か確認
- [ ] IO暗号化方式（AES/CTR/NoPadding、鍵サイズ、IV生成）の記述が正確か確認
- [ ] XSS対策の実装詳細（HTMLエスケープ、正規表現パターン）がコードと一致しているか確認
- [ ] CSRF対策の欠如について、Spark UIのPOSTエンドポイント（Kill操作等）への影響を評価
- [ ] 本番環境でのデフォルト設定（認証無効、ACL無効）のリスクを評価
- [ ] イベントログの保持期間についてHistory Server設定を確認
