---
generated_at: 2026-02-04 12:00:00
metrics:
  claims_total: 35
  claims_with_evidence: 32
  claims_without_evidence: 3
confidence_derived: 0.91
---

# 根拠レポート：テスト方針書

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.91**
  - 根拠あり：32 / 35、根拠なし：3
- 優先レビュー（高）
  1. **Scala/Java カバレッジ目標の不在**：明示的な設定ファイルが確認できないため、目標値の妥当性は要確認
  2. **pytest の利用有無**：PySpark テストが unittest ベースか pytest ベースかの切り分けが不明確
  3. **テストデータ管理の詳細方針**：具体的なテストデータ管理ポリシーのドキュメントが見つからない

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `pom.xml`（プロジェクトルート） - Maven ビルド設定、テストフレームワーク依存関係定義
- E-02: `.github/workflows/build_and_test.yml` - メインの CI/CD ワークフロー定義
- E-03: `.github/workflows/build_main.yml` - push トリガーのエントリーポイント
- E-04: `.github/workflows/build_coverage.yml` - PySpark カバレッジ計測ワークフロー
- E-05: `.github/workflows/maven_test.yml` - Maven ベースのテストワークフロー
- E-06: `.github/workflows/benchmark.yml` - ベンチマークワークフロー
- E-07: `dev/run-tests.py` - テスト実行スクリプト
- E-08: `dev/sparktestsupport/modules.py` - テストモジュール定義
- E-09: `dev/tox.ini` - Flake8 設定
- E-10: `pyproject.toml` - Ruff / Black 設定
- E-11: `ui-test/package.json` - UI テスト依存関係（Jest 30.x）
- E-12: `scalastyle-config.xml` - Scalastyle 設定
- E-13: `dev/checkstyle.xml` - Checkstyle 設定
- E-14: `R/pkg/tests/` - SparkR テストディレクトリ
- E-15: `.github/workflows/build_python_*.yml` - 各種 Python バージョンテストワークフロー
- E-16: `dev/check-license` - Apache RAT ライセンスチェックスクリプト
- E-17: `core/src/test/scala/org/apache/spark/` - Scala テストファイルディレクトリ
- E-18: `python/pyspark/tests/` - PySpark テストファイルディレクトリ
- E-19: `python/run-tests-with-coverage` - PySpark カバレッジ計測スクリプト

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | プロジェクトは Apache Spark 4.2.0-SNAPSHOT である | E-01 (pom.xml L29: version 4.2.0-SNAPSHOT) | ○ |
| C-02 | Scala 2.13 でビルドされる | E-01 (pom.xml L28: spark-parent_2.13) | ○ |
| C-03 | Java 17 が最小要件 | E-01 (pom.xml L120-121: java.version=17, minimum=17.0.11) | ○ |
| C-04 | ScalaTest 3.2.19 を使用 | E-01 (pom.xml L1221: version 3.2.19) | ○ |
| C-05 | JUnit Jupiter 6.0.1 を使用 | E-01 (pom.xml L222: junit.version=6.0.1) | ○ |
| C-06 | Mockito 5.12.0 を使用 | E-01 (pom.xml L1251: mockito-core version 5.12.0) | ○ |
| C-07 | ScalaCheck 1.18.0 を使用 | E-01 (pom.xml L1275: scalacheck version 1.18.0) | ○ |
| C-08 | Selenium 4.32.0 を使用 | E-01 (pom.xml L211: selenium.version=4.32.0) | ○ |
| C-09 | Maven Surefire Plugin 3.5.3 を使用 | E-01 (pom.xml L2849: version 3.5.3) | ○ |
| C-10 | Jest 30.x を UI テストに使用 | E-11 (ui-test/package.json: jest ^30.0.0) | ○ |
| C-11 | GitHub Actions で CI を実行 | E-02, E-03 (build_and_test.yml, build_main.yml) | ○ |
| C-12 | push 時に全ブランチでテスト実行 | E-03 (build_main.yml L23-25: on push branches **) | ○ |
| C-13 | is-changed.py で変更検出しテスト対象を選択 | E-02 (build_and_test.yml L94-104), E-07 (run-tests.py) | ○ |
| C-14 | Docker コンテナで PySpark テスト実行 | E-02 (build_and_test.yml L518-519: container image) | ○ |
| C-15 | PySpark テストの parallelism は 1 | E-02 (build_and_test.yml L652: --parallelism 1) | ○ |
| C-16 | TPC-DS SF=1 テストを実行 | E-02 (build_and_test.yml L1175-1263: tpcds-1g ジョブ) | ○ |
| C-17 | Docker Integration Tests を実行 | E-02 (build_and_test.yml L1286-1339) | ○ |
| C-18 | Kubernetes Integration Tests を Minikube で実行 | E-02 (build_and_test.yml L1362-1440) | ○ |
| C-19 | Codecov で PySpark カバレッジを収集 | E-02 (build_and_test.yml L658-666), E-04 (build_coverage.yml) | ○ |
| C-20 | PySpark カバレッジは毎日 10:00 UTC にスケジュール実行 | E-04 (build_coverage.yml L24: cron 0 10 * * *) | ○ |
| C-21 | Black 23.12.1 を Python フォーマッターとして使用 | E-10 (pyproject.toml L73: required-version = 23.12.1) | ○ |
| C-22 | Ruff を Python リンターとして使用 | E-10 (pyproject.toml L18-46: tool.ruff 設定) | ○ |
| C-23 | SparkR テストは R/run-tests.sh で実行 | E-07 (run-tests.py L412: R/run-tests.sh) | ○ |
| C-24 | Apache JIRA で不具合管理 | E-01 (pom.xml L51-53: issueManagement JIRA) | ○ |
| C-25 | テスト結果を JUnit XML 形式で出力 | E-02 (build_and_test.yml L393-395: target/test-reports/*.xml, target/surefire-reports/*.xml) | ○ |
| C-26 | test-summary/action でサマリー表示 | E-02 (build_and_test.yml L397-402) | ○ |
| C-27 | concurrency グループで重複実行防止 | E-02 (build_and_test.yml L56-58: cancel-in-progress true) | ○ |
| C-28 | SlowHiveTest / ExtendedSQLTest 等のタグでテスト分割 | E-02 (build_and_test.yml L266-298: included-tags / excluded-tags) | ○ |
| C-29 | MiMa でバイナリ互換性チェック | E-02 (build_and_test.yml L900-901: ./dev/mima), E-07 (run-tests.py L307-315) | ○ |
| C-30 | Python 3.10-3.14、PyPy 3.10-3.11 でテスト | E-15 (build_python_3.10.yml - build_python_3.14.yml, build_python_pypy3.10.yml, build_python_pypy3.11.yml) | ○ |
| C-31 | Minikube v1.36.0 / Kubernetes v1.33.1 を使用 | E-02 (build_and_test.yml の k8s-integration-tests ジョブ) | ○ |
| C-32 | JMH ベンチマークは workflow_dispatch で手動実行 | E-06 (benchmark.yml L23: workflow_dispatch) | ○ |
| C-33 | Scala/Java のカバレッジ数値目標は未設定 | **根拠なし** | △ |
| C-34 | PySpark テストは unittest ベースである | E-18 (python/pyspark/tests/ のファイル構成), E-07 (run-tests.py) | △ |
| C-35 | テストデータはインラインおよびリソースファイルで管理 | **根拠なし**（個別テストファイルの内容までは未確認） | △ |

## 4) 不足情報（Unknown / Missing）
- Scala/Java のカバレッジ目標値が明示的に設定されているかの確認ができなかった。pom.xml に JaCoCo 等のカバレッジプラグイン設定が見当たらないため、「未設定」と判断したが、別の設定ファイルや CI スクリプトに存在する可能性がある
  - 候補：build.sbt / project/SparkBuild.scala / 別の CI ワークフロー
- PySpark のテストフレームワークが純粋な unittest か pytest 経由かの確認。`python/run-tests` スクリプトの内部実装を詳細に確認する必要がある
  - 候補：python/run-tests / python/run-tests.py / python/pyspark/testing/ ディレクトリ
- テストデータ管理のプロジェクト公式ポリシーが明文化されているかの確認
  - 候補：CONTRIBUTING.md / dev/README.md / docs/ ディレクトリ内のガイド

## 5) リスクフラグ（レビュー観点）
- 0: テストフレームワーク・ツールのバージョン情報（pom.xml から直接確認可能）
- 0: CI/CD ワークフロー構成（GitHub Actions YAML から直接確認可能）
- 1: カバレッジ目標値の記載（明示的な目標設定が確認できないため中リスク）
- 0: テスト環境構成（ワークフロー YAML から直接確認可能）
- 1: テストデータ管理方針（推測を含むため中リスク）
- 0: 不具合管理（pom.xml の issueManagement から確認可能）

## 6) レビュアーチェックリスト（最小）
- [ ] ScalaTest / JUnit / Mockito 等のバージョンが pom.xml の定義と一致しているか
- [ ] GitHub Actions ワークフローの記述がリポジトリの .github/workflows/ 配下の実際のファイルと整合しているか
- [ ] TPC-DS テストの実行方法と結合戦略の記述が build_and_test.yml の定義と一致しているか
- [ ] PySpark カバレッジ計測のスケジュールが build_coverage.yml と一致しているか
- [ ] Kubernetes Integration Tests の Minikube / Kubernetes バージョンが実際のワークフロー定義と一致しているか
- [ ] Scala/Java のカバレッジ目標が「未設定」である点について、プロジェクトの方針として正しいか確認
- [ ] テストデータ管理方針の記述がプロジェクトの実態と合致しているか
