# テスト方針書

## 概要

本ドキュメントは、Apache Spark 4.2.0-SNAPSHOT（master ブランチ）プロジェクトにおけるテスト方針を定義する。Apache Spark は Scala/Java/Python/R の多言語対応の大規模分散処理フレームワークであり、core、SQL、MLlib、Streaming、GraphX、Spark Connect 等の多数のモジュールで構成される。本プロジェクトでは、GitHub Actions を活用した CI/CD パイプラインにより、各モジュールの単体テスト・結合テスト・性能テスト・静的解析を自動的に実行し、コード品質と回帰防止を担保する。

## テスト戦略

### テストレベル

| レベル | 目的 | 担当 |
| --- | --- | --- |
| 単体テスト | 個々のクラス・関数の動作検証。Scala/Java は ScalaTest + JUnit Jupiter、Python は unittest、R は testthat を用いて実施 | 各モジュール開発者 |
| 結合テスト | モジュール間のインタフェースや外部サービスとの連携を検証。Docker Integration Tests（DB接続等）および Kubernetes Integration Tests を含む | CI パイプライン / インテグレーション担当 |
| システムテスト | TPC-DS ベンチマーク（SF=1）による SQL エンジン全体の正当性検証。Sort Merge Join / Broadcast Hash Join / Shuffled Hash Join の各結合戦略で実施 | CI パイプライン |
| 受入テスト | PySpark パッケージングテスト（pip install 検証）、Spark on Kubernetes の E2E テスト、Protocol Buffers 互換性チェック | CI パイプライン / リリース担当 |

### テスト種別

| 種別 | 概要 | 実施タイミング |
| --- | --- | --- |
| 機能テスト | 各モジュールの機能要件に対するテスト。SBT/Maven 経由で ScalaTest・JUnit テストスイート、Python unittest、R testthat を実行 | push 時 / PR 時に自動実行 |
| 性能テスト | JMH ベンチマークによるマイクロベンチマーク。TPC-DS クエリ（SF=1）による SQL 性能の回帰検出 | workflow_dispatch による手動実行（ベンチマーク）、push 時（TPC-DS） |
| セキュリティテスト | Apache RAT によるライセンスヘッダー検査、依存関係の検証（test-dependencies.sh）、Protocol Buffers の破壊的変更検出（buf） | push 時 / PR 時に自動実行 |
| 静的解析 | Scalastyle / Checkstyle（Java）/ Ruff + Black（Python）/ lintr（R）/ ESLint（JavaScript）によるコードスタイル検査。MiMa によるバイナリ互換性チェック | push 時 / PR 時に自動実行 |
| UIテスト | Jest + jsdom によるフロントエンド JavaScript のユニットテスト（flamegraph、scroll-button、structured-streaming-page、utils） | push 時 / PR 時に自動実行 |

## テスト環境

| 環境 | 用途 | 構成 |
| --- | --- | --- |
| GitHub Actions (ubuntu-latest) | Scala/Java 単体テスト、結合テスト、静的解析、TPC-DS | Ubuntu + Zulu JDK 17（デフォルト）、SBT / Maven、Hadoop 3 プロファイル |
| GitHub Actions (Docker コンテナ) | PySpark テスト、SparkR テスト、リンターチェック | カスタム Docker イメージ（ghcr.io）、Python 3.10 - 3.14 / PyPy 3.10 - 3.11、R |
| GitHub Actions (ARM64) | クロスプラットフォーム検証 | ubuntu-24.04-arm（ARM64）、Python 3.12 |
| GitHub Actions (macOS) | macOS 互換性検証 | macos-15（macOS 26 対応）、Maven ビルド |
| Kubernetes クラスタ (Minikube) | Spark on Kubernetes 結合テスト | Minikube v1.36.0、Kubernetes v1.33.1、Volcano スケジューラ |
| Docker Integration | 外部システム統合テスト | Docker コンテナ上の DB 等との接続テスト |

## テストツール

| ツール | 用途 | バージョン |
| --- | --- | --- |
| ScalaTest | Scala 単体テストフレームワーク | 3.2.19 |
| ScalaTest Maven Plugin | Maven での ScalaTest 実行 | 2.2.0 |
| ScalaCheck | Scala プロパティベーステスト | 1.18.0 |
| JUnit Jupiter | Java 単体テストフレームワーク | 6.0.1 |
| Mockito | モックフレームワーク（Scala/Java） | 5.12.0 |
| JMock | Java モックフレームワーク | 2.13.1 |
| Selenium | Web UI テスト | 4.32.0 |
| Maven Surefire Plugin | Maven での Java テスト実行 | 3.5.3 |
| SBT | Scala ビルド・テスト実行ツール | プロジェクト組み込み |
| Python unittest | PySpark 単体テストフレームワーク | Python 標準ライブラリ |
| pytest | Python テスト実行 | CI 環境でインストール |
| coverage (Python) | PySpark コードカバレッジ計測 | CI 環境でインストール |
| testthat | SparkR テストフレームワーク | R パッケージ |
| Jest | JavaScript UI テストフレームワーク | 30.x |
| Ruff | Python リンター | pyproject.toml で設定 |
| Black | Python コードフォーマッター | 23.12.1 |
| Scalastyle | Scala スタイルチェック | scalastyle-config.xml で設定 |
| Checkstyle | Java スタイルチェック | dev/checkstyle.xml で設定 |
| ESLint | JavaScript リンター | dev/eslint.js で設定 |
| lintr | R リンター | dev/lint-r.R で設定 |
| MiMa | Scala バイナリ互換性チェック | dev/mima |
| Apache RAT | ライセンスヘッダー検査 | dev/check-license |
| Buf | Protocol Buffers リンター・破壊的変更検出 | GitHub Actions で自動設定 |
| Codecov | カバレッジレポート収集・可視化 | GitHub Actions 連携 |

## カバレッジ目標

| 対象 | 目標値 |
| --- | --- |
| PySpark 行カバレッジ | Codecov で計測（定期スケジュール実行: 毎日 10:00 UTC、Python 3.12） |
| Scala/Java カバレッジ | 明示的な数値目標は未設定（テストスイートの網羅性で管理） |
| 分岐カバレッジ | 明示的な数値目標は未設定 |

備考: PySpark のカバレッジは `build_coverage.yml` ワークフローにより定期的に計測され、Codecov にアップロードされる。Scala/Java 側のカバレッジツール（JaCoCo 等）は pom.xml 上では設定されておらず、テストスイートの充実度とモジュール別テスト実行による網羅性で品質を担保している。

## テストデータ

テストデータの準備方針は以下の通りである。

1. **インラインテストデータ**: 各テストスイート内でプログラム的にテストデータを生成する。Scala/Java テストでは SparkSession を用いた DataFrame 生成、Python テストでは PySpark API によるデータ生成が中心
2. **テストリソースファイル**: 各モジュールの `src/test/resources/` ディレクトリにテスト用設定ファイル（log4j2.properties 等）やサンプルデータファイルを配置
3. **TPC-DS データ**: tpcds-kit を用いて SF=1 のデータセットを自動生成し、GitHub Actions のキャッシュに保存。SQL テストスイート（TPCDSQueryTestSuite）で使用
4. **Docker Integration データ**: Docker コンテナ内に外部システム（DB 等）をセットアップし、テスト実行時にデータを動的に準備

## 不具合管理

不具合の管理は以下の方法で行う。

1. **課題追跡**: Apache JIRA（https://issues.apache.org/jira/browse/SPARK）を使用してすべての不具合を管理
2. **テスト結果の収集**: GitHub Actions の各ジョブで JUnit XML 形式のテストレポートを生成し、`actions/upload-artifact` でアーティファクトとして保存。`test-summary/action` によりサマリーを PR に表示
3. **失敗時ログ収集**: テスト失敗時には `**/target/*.log` および `**/target/unit-tests.log` をアーティファクトとしてアップロードし、デバッグに活用
4. **テスト結果の Codecov 連携**: テスト結果を Codecov にもアップロードし、テスト実行結果のトレンドを可視化
5. **変更影響分析**: `dev/is-changed.py` スクリプトにより、変更されたファイルから影響を受けるモジュールを自動判定し、必要なテストのみを実行することで効率的な回帰テストを実現

## CI/CD連携

### GitHub Actions ワークフロー構成

Apache Spark の CI/CD パイプラインは GitHub Actions で構成されており、以下のワークフローが定義されている。

| ワークフロー | トリガー | 内容 |
| --- | --- | --- |
| `build_main.yml` | push（全ブランチ） | `build_and_test.yml` を呼び出すエントリーポイント |
| `build_and_test.yml` | workflow_call | メインのビルド・テストワークフロー。モジュール別並列テスト実行 |
| `build_maven.yml` / `maven_test.yml` | workflow_call | Maven ベースのビルド・テスト |
| `build_coverage.yml` | schedule（毎日 10:00 UTC）/ workflow_dispatch | PySpark カバレッジ計測 |
| `benchmark.yml` | workflow_dispatch | JMH ベンチマーク実行 |
| `build_python_*.yml` | 各種 | Python 3.10 - 3.14、PyPy 3.10 - 3.11、nogil ビルドのマトリクステスト |
| `build_java21.yml` / `build_maven_java21.yml` | 各種 | Java 21 での互換性テスト |
| `build_non_ansi.yml` | 各種 | ANSI 非準拠モードでのテスト |

### テスト実行の仕組み

1. **変更検出**: `precondition` ジョブが `dev/is-changed.py` を使用して変更ファイルからテスト対象モジュールを自動判定
2. **Docker イメージビルド**: PySpark・SparkR・リンター用のカスタム Docker イメージを GitHub Container Registry (ghcr.io) にビルド・プッシュ
3. **並列テスト実行**: Scala/Java テストはモジュール群ごとにマトリクス戦略で並列実行。タイムアウトは150分
4. **テストタグ制御**: `SlowHiveTest`、`ExtendedSQLTest`、`SlowSQLTest`、`DockerTest` 等のタグにより、テストの分割・除外を制御
5. **PySpark テスト**: Docker コンテナ内で `dev/run-tests` スクリプト経由で実行。parallelism=1 で安定性を確保。タイムアウト450秒
6. **結果レポート**: JUnit XML レポートのアップロード、test-summary による GitHub PR サマリー表示、Codecov 連携

### ビルドツール

- **SBT**: デフォルトのビルドツール。`build/sbt` ラッパースクリプト経由で実行
- **Maven**: 代替ビルドツール。`build/mvn` ラッパースクリプト経由で実行。Java 17/21/25 のビルド検証に使用
- **Maven プロファイル**: hadoop-3、yarn、kubernetes、volcano、hive、hive-thriftserver、hadoop-cloud、spark-ganglia-lgpl、kinesis-asl 等の多数のプロファイルでビルド・テスト構成を制御

## 備考

### テストモジュール体系

Apache Spark のテストは `dev/sparktestsupport/modules.py` で定義されたモジュール体系に基づいて管理されている。各モジュールは以下の属性を持つ。

- **ソースファイル正規表現**: 変更検出に使用
- **SBT テストゴール**: Scala/Java テストの実行コマンド
- **Python テストゴール**: PySpark テストの実行コマンド
- **依存モジュール**: モジュール間の依存関係（推移的依存を自動解決）
- **テストタグ**: 条件付き実行のためのタグ

### 多プラットフォーム対応

- **JDK バージョン**: JDK 17（デフォルト）、JDK 21、JDK 25 でのビルド検証
- **Scala バージョン**: Scala 2.13
- **Python バージョン**: Python 3.10、3.11、3.12、3.13、3.14、PyPy 3.10、PyPy 3.11、nogil 対応
- **OS**: Ubuntu (x64/ARM64)、macOS
- **Hadoop**: Hadoop 3 プロファイル

### テスト実行の最適化

- **変更ベースの選択実行**: `is-changed.py` による影響モジュールの自動判定で不要なテストをスキップ
- **キャッシュ活用**: SBT/Maven のキャッシュ、Coursier リポジトリキャッシュ、TPC-DS データキャッシュを GitHub Actions キャッシュで管理
- **同時実行制御**: `concurrency` グループにより同一ワークフローの重複実行を防止（cancel-in-progress: true）
