# ER図

Apache Spark カタログシステムのエンティティ関連図を以下に示す。

```mermaid
erDiagram
    CatalogDatabase {
        String name PK
        String description
        URI locationUri
        Map properties
    }

    CatalogTable {
        TableIdentifier identifier PK
        CatalogTableType tableType
        StructType schema
        String provider
        Seq partitionColumnNames
        String owner
        Long createTime
        Long lastAccessTime
        String createVersion
        Map properties
        String viewText
        String comment
        String collation
        Seq unsupportedFeatures
        Boolean tracksPartitionsInCatalog
        Boolean schemaPreservesCase
        Map ignoredProperties
        String viewOriginalText
    }

    CatalogStorageFormat {
        URI locationUri
        String inputFormat
        String outputFormat
        String serde
        Boolean compressed
        Map properties
    }

    CatalogTablePartition {
        Map spec PK
        Map parameters
        Long createTime
        Long lastAccessTime
    }

    CatalogFunction {
        FunctionIdentifier identifier PK
        String className
    }

    FunctionResource {
        FunctionResourceType resourceType
        String uri
    }

    CatalogStatistics {
        BigInt sizeInBytes
        BigInt rowCount
    }

    CatalogColumnStat {
        BigInt distinctCount
        String min
        String max
        BigInt nullCount
        Long avgLen
        Long maxLen
        Int version
    }

    BucketSpec {
        Int numBuckets
        Seq bucketColumnNames
        Seq sortColumnNames
    }

    ClusterBySpec {
        Seq columnNames
    }

    CatalogTableType {
        String name PK
    }

    CatalogDatabase ||--o{ CatalogTable : "contains"
    CatalogDatabase ||--o{ CatalogFunction : "contains"
    CatalogTable ||--|| CatalogStorageFormat : "has storage"
    CatalogTable ||--|| CatalogTableType : "has type"
    CatalogTable ||--o| BucketSpec : "has bucket"
    CatalogTable ||--o| ClusterBySpec : "has clustering"
    CatalogTable ||--o| CatalogStatistics : "has stats"
    CatalogTable ||--o{ CatalogTablePartition : "has partitions"
    CatalogTablePartition ||--|| CatalogStorageFormat : "has storage"
    CatalogTablePartition ||--o| CatalogStatistics : "has stats"
    CatalogStatistics ||--o{ CatalogColumnStat : "has column stats"
    CatalogFunction ||--o{ FunctionResource : "uses resources"
```

## 関連説明

### エンティティ間の主要な関係

1. **CatalogDatabase -- CatalogTable**: 一つのデータベースは複数のテーブルを含む。テーブルは必ず一つのデータベースに属する。
2. **CatalogDatabase -- CatalogFunction**: 一つのデータベースは複数の関数を含む。関数は必ず一つのデータベースに属する。
3. **CatalogTable -- CatalogStorageFormat**: 各テーブルは一つのストレージ形式情報を持つ（必須）。
4. **CatalogTable -- CatalogTableType**: 各テーブルは一つのテーブル種別（EXTERNAL/MANAGED/VIEW）を持つ。
5. **CatalogTable -- BucketSpec**: テーブルはオプションでバケッティング情報を持つことができる。
6. **CatalogTable -- ClusterBySpec**: テーブルはオプションでクラスタリング情報を持つことができる（テーブルプロパティ `clusteringColumns` から取得）。
7. **CatalogTable -- CatalogStatistics**: テーブルはオプションで統計情報を持つことができる。
8. **CatalogTable -- CatalogTablePartition**: 一つのテーブルは複数のパーティションを持つことができる。パーティションはパーティションスペック（カラム名=値のマッピング）で一意に識別される。
9. **CatalogTablePartition -- CatalogStorageFormat**: 各パーティションは独自のストレージ形式情報を持つ（テーブルのストレージ形式を上書き可能）。
10. **CatalogTablePartition -- CatalogStatistics**: パーティションはオプションで統計情報を持つことができる。
11. **CatalogStatistics -- CatalogColumnStat**: 統計情報は複数のカラム統計を含むことができる（カラム名をキーとするマップ）。
12. **CatalogFunction -- FunctionResource**: 一つの関数は複数のリソース（jar, file等）を必要とすることがある。
