---
generated_at: 2026-02-03 12:00:00
metrics:
  claims_total: 28
  claims_with_evidence: 26
  claims_without_evidence: 2
confidence_derived: 0.93
---

# 根拠レポート：データベース設計書

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.93**
  - 根拠あり：26 / 28、根拠なし：2
- 優先レビュー（高）
  1. **Hive Metastore永続化先RDBMS**：実際の永続化先DBMSの種類はコードからは直接確認できない（設定依存）
  2. **StreamingSourceIdentifyingName型の詳細**：型定義の詳細を確認する必要がある

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `sql/catalyst/src/main/scala/org/apache/spark/sql/catalyst/catalog/interface.scala` -- CatalogDatabase, CatalogTable, CatalogTablePartition, CatalogStorageFormat, CatalogFunction, CatalogStatistics, CatalogColumnStat, BucketSpec, ClusterBySpec, CatalogTableType の case class 定義
- E-02: `sql/catalyst/src/main/scala/org/apache/spark/sql/catalyst/catalog/ExternalCatalog.scala` -- ExternalCatalog トレイト（カタログ操作インターフェース定義）
- E-03: `sql/catalyst/src/main/scala/org/apache/spark/sql/catalyst/catalog/InMemoryCatalog.scala` -- InMemoryCatalog クラス（インメモリ実装、HashMap構造）
- E-04: `sql/hive/src/main/scala/org/apache/spark/sql/hive/HiveExternalCatalog.scala` -- HiveExternalCatalog クラスおよびコンパニオンオブジェクト（Hive Metastore実装、プロパティプレフィックス定義）
- E-05: `sql/catalyst/src/main/scala/org/apache/spark/sql/catalyst/catalog/functionResources.scala` -- FunctionResource, FunctionResourceType 定義
- E-06: `sql/catalyst/src/main/scala/org/apache/spark/sql/catalyst/catalog/SessionCatalog.scala` -- SessionCatalog（セッションレベルカタログ）
- E-07: `sql/catalyst/src/main/scala/org/apache/spark/sql/catalyst/catalog/GlobalTempViewManager.scala` -- グローバル一時ビュー管理

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | CatalogDatabaseはname, description, locationUri, propertiesの4フィールドを持つ | E-01 (L1061-1065) | ○ |
| C-02 | CatalogTableはidentifier, tableType, storage, schema等22フィールドを持つ | E-01 (L425-448) | ○ |
| C-03 | CatalogTablePartitionはspec, storage, parameters, createTime, lastAccessTime, statsの6フィールドを持つ | E-01 (L196-202) | ○ |
| C-04 | CatalogStorageFormatはlocationUri, inputFormat, outputFormat, serde, compressed, propertiesの6フィールドを持つ | E-01 (L144-150) | ○ |
| C-05 | CatalogFunctionはidentifier, className, resourcesの3フィールドを持つ | E-01 (L133-138) | ○ |
| C-06 | CatalogStatisticsはsizeInBytes, rowCount, colStatsの3フィールドを持つ | E-01 (L841-844) | ○ |
| C-07 | CatalogColumnStatはdistinctCount, min, max, nullCount, avgLen, maxLen, histogram, versionの8フィールドを持つ | E-01 (L882-890) | ○ |
| C-08 | BucketSpecはnumBuckets, bucketColumnNames, sortColumnNamesの3フィールドを持つ | E-01 (L372-375) | ○ |
| C-09 | ClusterBySpecはcolumnNamesフィールドを持つ | E-01 (L273) | ○ |
| C-10 | CatalogTableTypeはEXTERNAL, MANAGED, VIEWの3種別がある | E-01 (L1048-1055) | ○ |
| C-11 | FunctionResourceはresourceType, uriの2フィールドを持つ | E-05 (L49) | ○ |
| C-12 | FunctionResourceTypeにはjar, file, archiveの3種別がある | E-05 (L28-35) | ○ |
| C-13 | InMemoryCatalogはHashMap[String, DatabaseDesc]構造でメタデータを保持する | E-03 (L47-64) | ○ |
| C-14 | DatabaseDescはdb, tables, functionsフィールドを持つ | E-03 (L58-61) | ○ |
| C-15 | TableDescはtable, partitionsフィールドを持つ | E-03 (L54-56) | ○ |
| C-16 | HiveExternalCatalogはExternalCatalogトレイトを実装する | E-04 (L59-60) | ○ |
| C-17 | HiveExternalCatalogはHiveClientを通じてHive Metastoreと通信する | E-04 (L69-71) | ○ |
| C-18 | SPARK_SQL_PREFIXは"spark.sql."である | E-04 (L1447) | ○ |
| C-19 | DATASOURCE_PREFIXは"spark.sql.sources."である | E-04 (L1449) | ○ |
| C-20 | STATISTICS_PREFIXは"spark.sql.statistics."である | E-04 (L1462) | ○ |
| C-21 | ExternalCatalogトレイトはDatabases, Tables, Partitions, Functions操作を定義する | E-02 | ○ |
| C-22 | CatalogColumnStatのVERSIONは現在2である | E-01 (L952) | ○ |
| C-23 | CatalogTableのownerのデフォルト値はCurrentUserContext.getCurrentUserOrEmptyである | E-01 (L433) | ○ |
| C-24 | CatalogTableのcreateTimeのデフォルト値はSystem.currentTimeMillisである | E-01 (L435) | ○ |
| C-25 | viewプロパティのプレフィックスは"view."である | E-01 (L721) | ○ |
| C-26 | clusterBySpecはテーブルプロパティ"clusteringColumns"から復元される | E-01 (L715-717, L769) | ○ |
| C-27 | Hive MetastoreはDerby/MySQL/PostgreSQLなどのRDBMSに永続化される | **根拠なし** | △ |
| C-28 | StreamingSourceIdentifyingNameの詳細な型構造 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- C-27: Hive Metastoreの永続化先RDBMSの種類はSpark本体のコードではなく、Hiveの設定ファイル（hive-site.xml）やデプロイ環境に依存する。Sparkコード内にはDerby/MySQL/PostgreSQLの明示的な参照は存在するが、それらはJDBCコネクタテスト用であり、Metastore設定ではない。
  - 候補: Hive公式ドキュメント / hive-site.xml設定リファレンス / Spark公式ドキュメント
- C-28: StreamingSourceIdentifyingNameは`sql/catalyst`モジュール内に定義されているが、本調査ではデータベース設計に直接影響しない補助的な型として詳細調査を省略した。
  - 候補: `sql/catalyst/src/main/scala/org/apache/spark/sql/catalyst/streaming/` ディレクトリ

## 5) リスクフラグ（レビュー観点）
- 0: CatalogDatabase, CatalogTable, CatalogTablePartition, CatalogStorageFormat, CatalogFunction等の主要エンティティのフィールド定義 -- ソースコードから直接抽出しており、低リスク
- 0: InMemoryCatalogの内部HashMap構造 -- ソースコードから直接確認しており、低リスク
- 0: HiveExternalCatalogのプロパティプレフィックス -- コンパニオンオブジェクト内の定数から直接抽出しており、低リスク
- 1: Hive Metastoreの永続化先RDBMS -- Spark外部の設定に依存するため、中リスク
- 0: ExternalCatalogの操作カテゴリ -- トレイト定義から直接確認しており、低リスク

## 6) レビュアーチェックリスト（最小）
- [ ] CatalogTableの22フィールドがソースコード（interface.scala L425-448）と一致するか確認
- [ ] CatalogColumnStatのフィールド数・型がソースコード（interface.scala L882-890）と一致するか確認
- [ ] HiveExternalCatalogのプロパティプレフィックスが最新のコードと一致するか確認
- [ ] ER図のエンティティ間リレーションシップがコード上の参照関係と整合するか確認
- [ ] Hive Metastoreの永続化先に関する記述が運用環境の実態と整合するか確認
- [ ] BucketSpecのnumBucketsの上限値（bucketingMaxBuckets）が現在の設定と整合するか確認
