---
generated_at: 2026-02-03 00:00:00
metrics:
  claims_total: 36
  claims_with_evidence: 36
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：バッチ一覧.csv

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：36 / 36、根拠なし：0
- 優先レビュー（高）
  1. **なし**：全項目がソースコードから直接確認済み
  2. **網羅性の観点**：プロジェクト内にはdev/配下に追加のリント・検証系スクリプトが多数存在するが、バッチ一覧としてはコアな実行・管理スクリプトに限定した
  3. **分類の妥当性**：カテゴリ分類（デーモン管理/クライアント実行/ビルド・リリース/テスト/環境設定/デーモン基盤）はスクリプトの役割に基づくが、別の分類体系も考えられる

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `sbin/start-all.sh`
- E-02: `sbin/stop-all.sh`
- E-03: `sbin/start-master.sh`
- E-04: `sbin/stop-master.sh`
- E-05: `sbin/start-worker.sh`
- E-06: `sbin/stop-worker.sh`
- E-07: `sbin/start-workers.sh`
- E-08: `sbin/stop-workers.sh`
- E-09: `sbin/decommission-worker.sh`
- E-10: `sbin/start-history-server.sh`
- E-11: `sbin/stop-history-server.sh`
- E-12: `sbin/start-thriftserver.sh`
- E-13: `sbin/stop-thriftserver.sh`
- E-14: `sbin/start-connect-server.sh`
- E-15: `sbin/stop-connect-server.sh`
- E-16: `sbin/spark-daemon.sh`
- E-17: `sbin/spark-daemons.sh`
- E-18: `sbin/workers.sh`
- E-19: `sbin/spark-config.sh`
- E-20: `bin/spark-submit`
- E-21: `bin/spark-class`
- E-22: `bin/spark-shell`
- E-23: `bin/spark-sql`
- E-24: `bin/pyspark`
- E-25: `bin/sparkR`
- E-26: `bin/beeline`
- E-27: `bin/spark-connect-shell`
- E-28: `bin/spark-pipelines`
- E-29: `bin/run-example`
- E-30: `bin/load-spark-env.sh`
- E-31: `bin/find-spark-home`
- E-32: `dev/make-distribution.sh`
- E-33: `bin/docker-image-tool.sh`
- E-34: `dev/change-scala-version.sh`
- E-35: `dev/run-tests.py`
- E-36: `dev/test-dependencies.sh`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | start-all.shは全Sparkデーモン（Master + Worker）を一括起動する | E-01 | ○ |
| C-02 | stop-all.shは全Sparkデーモン（Worker + Master）を一括停止する | E-02 | ○ |
| C-03 | start-master.shはSpark Masterデーモンをローカルノードで起動する（クラス: org.apache.spark.deploy.master.Master、デフォルトポート7077） | E-03 | ○ |
| C-04 | stop-master.shはSpark Masterデーモンを停止する | E-04 | ○ |
| C-05 | start-worker.shはSpark Workerデーモンをローカルノードで起動する（クラス: org.apache.spark.deploy.worker.Worker、SPARK_WORKER_INSTANCES対応） | E-05 | ○ |
| C-06 | stop-worker.shはローカルノードの全Workerインスタンスを停止する | E-06 | ○ |
| C-07 | start-workers.shはconf/workersに記載された全ノードでWorkerを起動する | E-07 | ○ |
| C-08 | stop-workers.shはconf/workersに記載された全ノードでWorkerを停止する | E-08 | ○ |
| C-09 | decommission-worker.shはローカルノードのWorkerをデコミッション（安全停止）する | E-09 | ○ |
| C-10 | start-history-server.shはSpark History Serverデーモンを起動する（クラス: org.apache.spark.deploy.history.HistoryServer） | E-10 | ○ |
| C-11 | stop-history-server.shはSpark History Serverデーモンを停止する | E-11 | ○ |
| C-12 | start-thriftserver.shはSpark SQL Thrift JDBC/ODBCサーバーを起動する（クラス: org.apache.spark.sql.hive.thriftserver.HiveThriftServer2） | E-12 | ○ |
| C-13 | stop-thriftserver.shはSpark SQL Thrift JDBC/ODBCサーバーを停止する | E-13 | ○ |
| C-14 | start-connect-server.shはSpark Connectサーバーを起動する（クラス: org.apache.spark.sql.connect.service.SparkConnectServer） | E-14 | ○ |
| C-15 | stop-connect-server.shはSpark Connectサーバーを停止する | E-15 | ○ |
| C-16 | spark-daemon.shはSparkデーモンプロセスの起動・停止・状態確認を行う汎用スクリプト（start/stop/submit/decommission/status対応） | E-16 | ○ |
| C-17 | spark-daemons.shは全Workerノードに対してデーモン操作を実行する | E-17 | ○ |
| C-18 | workers.shはconf/workersに記載された全ホストでコマンドをSSH実行する | E-18 | ○ |
| C-19 | spark-config.shはSpark設定の初期化を行う共通設定スクリプト | E-19 | ○ |
| C-20 | spark-submitはSparkアプリケーションをクラスタに投入する（クラス: org.apache.spark.deploy.SparkSubmit） | E-20 | ○ |
| C-21 | spark-classはSparkの任意のJavaクラスを実行する | E-21 | ○ |
| C-22 | spark-shellはSpark Scala REPL（対話シェル）を起動する（クラス: org.apache.spark.repl.Main） | E-22 | ○ |
| C-23 | spark-sqlはSpark SQL CLIを起動する（クラス: org.apache.spark.sql.hive.thriftserver.SparkSQLCLIDriver） | E-23 | ○ |
| C-24 | pysparkはPySpark対話シェルを起動する（Python3使用） | E-24 | ○ |
| C-25 | sparkRはSparkR対話シェルを起動する（Spark 4.0.0以降で非推奨） | E-25 | ○ |
| C-26 | beelineはBeeline SQLクライアントを起動する（クラス: org.apache.hive.beeline.BeeLine） | E-26 | ○ |
| C-27 | spark-connect-shellはSpark Connect対応のScala REPLを起動する（SparkConnectPlugin有効化） | E-27 | ○ |
| C-28 | spark-pipelinesはSpark Pipelinesを実行する（クラス: org.apache.spark.deploy.SparkPipelines） | E-28 | ○ |
| C-29 | run-exampleはSparkサンプルアプリケーションを実行する | E-29 | ○ |
| C-30 | load-spark-env.shはspark-env.sh設定ファイルの読み込みとScalaバージョン設定を行う（Scala 2.13がデフォルト） | E-30 | ○ |
| C-31 | find-spark-homeはSPARK_HOMEの検出・設定を行う | E-31 | ○ |
| C-32 | make-distribution.shはSparkのバイナリディストリビューションを作成する | E-32 | ○ |
| C-33 | docker-image-tool.shはSparkのDockerイメージをビルド・プッシュする（クロスビルド対応） | E-33 | ○ |
| C-34 | change-scala-version.shはプロジェクトのScalaバージョンを切り替える（有効バージョン: 2.13） | E-34 | ○ |
| C-35 | run-tests.pyはSparkの統合テストスイートを実行する（変更ファイルから対象モジュール自動判定） | E-35 | ○ |
| C-36 | test-dependencies.shはSparkの依存関係テストを実行する | E-36 | ○ |

## 4) 不足情報（Unknown / Missing）
- 該当なし。全36件の主張について、対応するソースコードファイルが実在し、内容を直接確認した上で記載しています。
  - 補足: dev/配下にはlint-java、lint-python、lint-scala、lint-js、lint-r等のリントスクリプトや、gen-protos.sh、connect-gen-protos.sh等のコード生成スクリプトも存在するが、コアバッチ処理として直接ユーザーが実行するものに限定して一覧に含めていない。必要に応じて追加を検討すること。

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全項目がソースコードから直接確認済みのため、記載内容の正確性は高い
- 1: 中リスク - バッチ一覧の網羅性について。dev/配下のリント系・コード生成系スクリプト（lint-java, lint-python, gen-protos.sh等）やdev/create-release/配下のリリーススクリプトは本一覧に含まれていない。プロジェクトの運用において必要であれば追加を検討
- 0: 低リスク - カテゴリ分類はスクリプトの機能的役割に基づいており妥当

## 6) レビュアーチェックリスト（最小）
- [ ] 各バッチスクリプトの配置パス（bin/, sbin/, dev/）が正しいか確認
- [ ] 起動クラス名が各スクリプトのCLASS変数と一致しているか確認
- [ ] デフォルトポート番号（Master: 7077、Worker WebUI: 8081、Master WebUI: 8080）が最新のコードと一致しているか確認
- [ ] dev/配下の未掲載スクリプト（lint系、gen-protos系、create-release系）がバッチ一覧として必要か判断
- [ ] sparkRの非推奨情報（Spark 4.0.0以降）が正しいか確認
- [ ] カテゴリ分類が運用上の要件と合致しているか確認
