# バッチ設計書 1-start-all.sh

## 概要

本ドキュメントは、Apache Sparkの全デーモン（Master + Worker）を一括起動するシェルスクリプト `start-all.sh` のバッチ設計書である。

### 本バッチの処理概要

`start-all.sh` は、Sparkクラスタを構成するすべてのデーモンプロセスを一括で起動するためのオーケストレーションスクリプトである。Masterノード上で実行され、まずローカルノードでMasterデーモンを起動し、続いて `conf/workers` ファイルに記載された全ノードでWorkerデーモンを起動する。

**業務上の目的・背景**：Sparkクラスタの運用において、MasterおよびWorkerデーモンを個別に起動するのは煩雑であり、オペレーションミスの原因にもなる。本バッチは、1コマンドでクラスタ全体を起動可能にすることで、クラスタ運用の効率化とオペレーションの標準化を実現する。

**バッチの実行タイミング**：手動実行。クラスタの初回起動時、メンテナンス後の再起動時、障害復旧時など、運用者が任意のタイミングで実行する。

**主要な処理内容**：
1. SPARK_HOMEが未設定の場合、スクリプトの配置ディレクトリから自動検出し設定する
2. `spark-config.sh` をsourceしてSpark共通設定（SPARK_CONF_DIR、PYTHONPATH等）を初期化する
3. `start-master.sh` を呼び出してローカルノードでMasterデーモンを起動する
4. `start-workers.sh` を呼び出して `conf/workers` に記載された全ノードでWorkerデーモンを起動する

**前後の処理との関連**：本バッチはクラスタ起動の最初のステップである。前提バッチは存在しない。停止時は対となる `stop-all.sh` を使用する。内部的に `start-master.sh`（No.3）と `start-workers.sh`（No.7）を順次呼び出す。

**影響範囲**：Sparkクラスタ全体（Masterノードおよび `conf/workers` に記載された全Workerノード）。Masterデーモン（ポート7077、WebUI 8080）およびWorkerデーモン（WebUI 8081〜）が起動される。

## バッチ種別

デーモン管理（クラスタ一括起動）

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 随時 |
| 実行時刻 | 任意 |
| 実行曜日 | 該当なし |
| 実行日 | 該当なし |
| トリガー | 手動 |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| SPARK_HOME | SPARK_HOMEが設定済み、または本スクリプトの配置場所から自動検出可能であること |
| ネットワーク接続 | Masterノードから各Workerノードへの SSH 接続が可能であること |
| conf/workers | `conf/workers` ファイルにWorkerノードのホスト名が記載されていること |
| Masterが未起動 | Masterデーモンが起動していないこと（既に起動中の場合はstart-master.shがエラーを返す） |

### 実行可否判定

特段の判定ロジックはなし。スクリプト実行時に `start-master.sh` および `start-workers.sh` がそれぞれの起動判定を行う。Masterが既に起動している場合は `spark-daemon.sh` がPIDファイルを確認して重複起動を防止する。

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| なし | - | - | - | 本スクリプトはコマンドライン引数を受け取らない |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| conf/workers | テキストファイル | Workerノードのホスト名一覧。1行1ホスト。#でコメント行 |
| sbin/spark-config.sh | シェルスクリプト | Spark共通設定の初期化スクリプト |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| 標準出力 | テキスト | 起動メッセージ（各デーモンの起動ログパス等） |
| PIDファイル | テキスト | 各デーモンのプロセスIDファイル（SPARK_PID_DIR配下） |
| ログファイル | テキスト | 各デーモンの出力ログ（SPARK_LOG_DIR配下） |

### 出力ファイル仕様

| 項目 | 内容 |
|-----|------|
| ファイル名 | spark-{SPARK_IDENT_STRING}-{クラス名}-{インスタンス番号}-{ホスト名}.out |
| 出力先 | ${SPARK_LOG_DIR}（デフォルト: ${SPARK_HOME}/logs） |
| 文字コード | システムデフォルト |
| 区切り文字 | 該当なし |

## 処理フロー

### 処理シーケンス

```
1. SPARK_HOME検出・設定
   └─ 環境変数が未設定の場合、スクリプト配置ディレクトリの親ディレクトリを設定
2. Spark設定読み込み
   └─ spark-config.shをsourceしてSPARK_CONF_DIR、PYTHONPATHを設定
3. Master起動
   └─ start-master.shを実行（spark-daemon.sh経由でMasterプロセスを起動）
4. Workers起動
   └─ start-workers.shを実行（workers.sh経由で各ノードにSSH接続しWorkerを起動）
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B[SPARK_HOME設定]
    B --> C[spark-config.sh読み込み]
    C --> D[start-master.sh実行]
    D --> E[start-workers.sh実行]
    E --> F[バッチ終了]
```

## データベース操作仕様

### 操作別データベース影響一覧

本バッチはデータベース操作を行わない。

### テーブル別操作詳細

該当なし

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| 1 | 起動失敗 | Masterデーモンが既に起動中 | stop-master.shで既存プロセスを停止後に再実行 |
| 1 | 起動失敗 | Workerノードへの SSH 接続失敗 | SSH設定・ネットワーク接続を確認 |
| - | 起動失敗 | Javaプロセスが起動後すぐに終了 | ログファイル（SPARK_LOG_DIR配下）を確認 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | なし（リトライ機能は未実装） |
| リトライ間隔 | 該当なし |
| リトライ対象エラー | 該当なし |

### 障害時対応

1. ログファイル（`${SPARK_LOG_DIR}/spark-*-*.out`）を確認する
2. Masterが起動しない場合: ポート7077の競合を確認する
3. Workerが起動しない場合: SSH接続、conf/workersファイルの内容を確認する
4. 全デーモンを `stop-all.sh` で停止してから再実行する

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | 該当なし（プロセス起動のため） |
| コミットタイミング | 該当なし |
| ロールバック条件 | 該当なし。Master起動失敗時もWorker起動は試行される |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 1 Master + N Workers（Nは conf/workers の行数） |
| 目標処理時間 | 数秒〜数十秒（ノード数依存） |
| メモリ使用量上限 | シェルスクリプト自体は最小限。各デーモンのメモリは個別設定に依存 |

## 排他制御

spark-daemon.sh がPIDファイルによる排他制御を実施する。同一クラス・同一インスタンス番号のデーモンが既に起動中の場合、新たな起動は拒否される。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 起動ログ | 各デーモン起動時 | "starting {クラス名}, logging to {ログパス}" |
| エラーログ | 起動失敗時 | "failed to launch: {コマンド}" + ログ末尾10行 |
| 重複起動ログ | 既存プロセス検出時 | "{クラス名} running as process {PID}. Stop it first." |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| Master起動状態 | プロセス存在確認 | 運用者（手動確認） |
| Worker起動状態 | 各ノードのプロセス存在確認 | 運用者（手動確認） |

## 備考

- 本スクリプトはMasterノード上で実行することが前提である
- Worker起動はSSH経由で行われるため、パスワードなしSSH接続（公開鍵認証）の設定が必要である
- 停止は `stop-all.sh` で行う。`--wait` オプションでWorkerの完全停止を待機可能
