# バッチ設計書 10-start-history-server.sh

## 概要

本ドキュメントは、Spark History Serverデーモンを起動するシェルスクリプト `start-history-server.sh` のバッチ設計書である。

### 本バッチの処理概要

`start-history-server.sh` は、`org.apache.spark.deploy.history.HistoryServer` クラスをデーモンプロセスとして起動するスクリプトである。History Serverは完了済みのSparkアプリケーションのイベントログを読み取り、WebUIを通じて実行履歴・ステージ情報・タスク詳細などを可視化するサービスである。

**業務上の目的・背景**：Sparkアプリケーションの実行後に、パフォーマンス分析やデバッグを行うためにはジョブの実行履歴にアクセスする必要がある。SparkのWebUIはアプリケーション実行中のみ利用可能であるため、完了後のジョブ履歴を参照するにはHistory Serverが必要である。本バッチはHistory Serverの起動を標準化し、クラスタ運用における事後分析環境を提供する。

**バッチの実行タイミング**：手動実行。History Serverは通常、クラスタ運用開始時に一度起動し、継続的に稼働させる。メンテナンス後の再起動時にも使用する。

**主要な処理内容**：
1. SPARK_HOMEが未設定の場合、スクリプトの配置ディレクトリから自動検出する
2. `--help` / `-h` オプション指定時はヘルプメッセージを表示して終了する
3. `spark-config.sh` および `load-spark-env.sh` をsourceして設定を初期化する
4. `spark-daemon.sh start` 経由で `org.apache.spark.deploy.history.HistoryServer` をデーモンとして起動する
5. コマンドライン引数はそのままHistory Serverクラスに渡される

**前後の処理との関連**：History Serverは他のSparkデーモン（Master/Worker）とは独立して動作する。`start-all.sh`（No.1）には含まれていない。停止は `stop-history-server.sh`（No.11）で行う。`SPARK_HISTORY_OPTS` 環境変数でHistory Server固有の設定を行う。

**影響範囲**：ローカルノードでHistory Serverデーモンプロセスが起動される。デフォルトのWebUIポート（18080）をバインドする。イベントログディレクトリへの読み取りアクセスが発生する。

## バッチ種別

デーモン管理（History Serverデーモン起動）

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 随時（通常はクラスタ運用開始時に1回） |
| 実行時刻 | 任意 |
| 実行曜日 | 該当なし |
| 実行日 | 該当なし |
| トリガー | 手動 |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| SPARK_HOME | SPARK_HOMEが設定済み、または自動検出可能であること |
| Java | Javaランタイムがインストールされ、PATHに含まれていること |
| イベントログ | spark.history.fs.logDirectory（イベントログディレクトリ）が存在し読み取り可能であること |
| History Serverが未起動 | 同一インスタンス番号のHistory Serverが起動していないこと |

### 実行可否判定

spark-daemon.sh がPIDファイル（`spark-{USER}-org.apache.spark.deploy.history.HistoryServer-1.pid`）を確認し、既にプロセスが起動中であれば起動を拒否する。

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| --help / -h | フラグ | No | - | ヘルプメッセージを表示して終了 |
| その他のオプション | - | No | - | HistoryServer クラスに渡される追加オプション |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| 環境変数 SPARK_HISTORY_OPTS | 文字列 | History Server固有のJavaオプション |
| spark-defaults.conf | プロパティファイル | spark.history.fs.logDirectory等のHistory Server設定 |
| spark-env.sh | シェルスクリプト | Spark環境設定ファイル |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| 標準出力 | テキスト | 起動メッセージ |
| PIDファイル | テキスト | History ServerのプロセスIDファイル |
| ログファイル | テキスト | History Server起動ログ |

### 出力ファイル仕様

| 項目 | 内容 |
|-----|------|
| ファイル名 | spark-{SPARK_IDENT_STRING}-org.apache.spark.deploy.history.HistoryServer-1-{HOSTNAME}.out |
| 出力先 | ${SPARK_LOG_DIR}（デフォルト: ${SPARK_HOME}/logs） |
| 文字コード | システムデフォルト |
| 区切り文字 | 該当なし |

## 処理フロー

### 処理シーケンス

```
1. SPARK_HOME検出・設定
   └─ 環境変数が未設定の場合、スクリプト配置ディレクトリの親ディレクトリを設定
2. ヘルプ判定
   └─ --help / -h 指定時はspark-classでヘルプ表示して終了
3. 設定読み込み
   └─ spark-config.sh と load-spark-env.sh をsource
4. History Server起動
   └─ exec spark-daemon.sh start org.apache.spark.deploy.history.HistoryServer 1 "$@"
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B[SPARK_HOME設定]
    B --> C{--help/-h?}
    C -->|はい| D[ヘルプ表示]
    D --> E[終了 exit 0]
    C -->|いいえ| F[spark-config.sh読み込み]
    F --> G[load-spark-env.sh読み込み]
    G --> H[exec spark-daemon.sh start HistoryServer 1]
    H --> I[バッチ終了]
```

## データベース操作仕様

### 操作別データベース影響一覧

本バッチはデータベース操作を行わない。

### テーブル別操作詳細

該当なし

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| 1 | 重複起動 | 同一インスタンス番号のHistory Serverが既に起動中 | stop-history-server.shで停止後に再実行 |
| - | 起動失敗 | イベントログディレクトリが存在しない | spark.history.fs.logDirectoryの設定を確認 |
| - | 起動失敗 | Javaが見つからない | Java環境のインストール・PATH設定を確認 |
| - | 起動失敗 | WebUIポート（18080）がバインド済み | ポートの競合を解消 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | なし |
| リトライ間隔 | 該当なし |
| リトライ対象エラー | 該当なし |

### 障害時対応

1. ログファイル（`${SPARK_LOG_DIR}/spark-*-org.apache.spark.deploy.history.HistoryServer-*.out`）を確認する
2. イベントログディレクトリの存在・権限を確認する
3. ポートの競合がないか確認する

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | 該当なし（プロセス起動のため） |
| コミットタイミング | 該当なし |
| ロールバック条件 | 該当なし |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 1プロセス |
| 目標処理時間 | 数秒（Javaプロセス起動完了まで） |
| メモリ使用量上限 | シェルスクリプト自体は最小限。History ServerプロセスのメモリはSPARK_HISTORY_OPTSで設定 |

## 排他制御

spark-daemon.sh がPIDファイル（`${SPARK_PID_DIR}/spark-{SPARK_IDENT_STRING}-org.apache.spark.deploy.history.HistoryServer-1.pid`）による排他制御を実施する。インスタンス番号は固定で1。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 起動ログ | デーモン起動時 | "starting org.apache.spark.deploy.history.HistoryServer, logging to {ログパス}" |
| エラーログ | 起動失敗時 | "failed to launch: {コマンド}" + ログ末尾10行 |
| 重複起動ログ | 既存プロセス検出時 | "org.apache.spark.deploy.history.HistoryServer running as process {PID}. Stop it first." |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| History Serverプロセス存在 | PIDファイル + psコマンド | 運用者（手動確認） |
| WebUI応答 | ポート18080のHTTP応答 | 運用者（手動確認） |

## 備考

- `exec` コマンドで `spark-daemon.sh` を呼び出しているため、本スクリプトのプロセスは `spark-daemon.sh` のプロセスに置き換わる。これにより余分なシェルプロセスが残らない
- 起動クラス名 `org.apache.spark.deploy.history.HistoryServer` はSparkSubmitでも参照されるため、変更時は整合性に注意が必要（ソースコードコメント記載あり）
- `start-all.sh` の起動対象には含まれていないため、History Serverは個別に起動する必要がある
- `SPARK_HISTORY_OPTS` 環境変数でHistory Server固有のJavaオプション（メモリ設定、GC設定等）を指定可能
- History Serverのデフォルトポートは18080（Spark設定ファイルのデフォルト値）
- インスタンス番号は常に1で固定される
