# バッチ設計書 11-stop-history-server.sh

## 概要

本ドキュメントは、Spark History Serverデーモンを停止するシェルスクリプト `stop-history-server.sh` のバッチ設計書である。スクリプトの処理内容、実行条件、エラー処理等について記載する。

### 本バッチの処理概要

`stop-history-server.sh` は、ローカルノード上で稼働中のSpark History Serverデーモンプロセスを安全に停止するためのシェルスクリプトである。内部的には `spark-daemon.sh` に停止処理を委譲する構成となっている。

**業務上の目的・背景**：Spark History Serverは完了済みSparkアプリケーションのUI情報を提供するデーモンプロセスである。メンテナンス作業、設定変更の反映、障害対応、リソース解放などの運用場面でHistory Serverを安全に停止する必要がある。手動でプロセスをkillするのではなく、統一的なデーモン管理インターフェースを通じて停止することで、PIDファイルのクリーンアップを含む安全な停止処理を実現する。

**バッチの実行タイミング**：手動実行が基本。メンテナンス時やHistory Serverの設定変更時、障害発生時に管理者が任意のタイミングで実行する。

**主要な処理内容**：
1. SPARK_HOME環境変数の設定（未設定の場合はスクリプト配置場所から自動検出）
2. `spark-daemon.sh` にstopコマンド、クラス名（org.apache.spark.deploy.history.HistoryServer）、インスタンス番号（1）を渡して停止処理を委譲

**前後の処理との関連**：`start-history-server.sh`（No.10）で起動されたHistory Serverプロセスを停止する対となるスクリプトである。停止処理は `spark-daemon.sh`（No.16）に委譲され、PIDファイルに基づくプロセスの特定とkillシグナルの送信が行われる。

**影響範囲**：History Serverが停止すると、完了済みSparkアプリケーションのWeb UIが参照不可となる。稼働中のSparkアプリケーションには影響しない。

## バッチ種別

デーモン管理（プロセス停止）

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 随時 |
| 実行時刻 | 任意 |
| 実行曜日 | 該当なし |
| 実行日 | 該当なし |
| トリガー | 手動 |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| SPARK_HOME | 環境変数が設定済み、または自動検出可能であること |
| History Serverプロセス | `start-history-server.sh` により事前に起動されていること |
| spark-daemon.sh | `${SPARK_HOME}/sbin/spark-daemon.sh` が存在し実行可能であること |

### 実行可否判定

特別な実行可否判定ロジックは存在しない。`spark-daemon.sh` 内でPIDファイルの存在確認とプロセスの生存確認を行い、停止対象が存在しない場合は「no org.apache.spark.deploy.history.HistoryServer to stop」のメッセージを出力して正常終了する。

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| なし | - | - | - | 本スクリプトはコマンドライン引数を受け取らない |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| PIDファイル | テキストファイル | `${SPARK_PID_DIR}/spark-${SPARK_IDENT_STRING}-org.apache.spark.deploy.history.HistoryServer-1.pid` に格納されたプロセスID |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| 標準出力 | テキスト | 停止処理のステータスメッセージ |

### 出力ファイル仕様

| 項目 | 内容 |
|-----|------|
| ファイル名 | PIDファイルが削除される |
| 出力先 | `${SPARK_PID_DIR}/` |
| 文字コード | UTF-8 |
| 区切り文字 | 該当なし |

## 処理フロー

### 処理シーケンス

```
1. SPARK_HOME環境変数の確認・設定
   └─ 未設定の場合、スクリプトの配置ディレクトリから親ディレクトリを算出して設定
2. spark-daemon.shの呼び出し
   └─ stop org.apache.spark.deploy.history.HistoryServer 1 の引数で実行
3. spark-daemon.sh内の停止処理（委譲先）
   ├─ PIDファイルの存在確認
   ├─ プロセスの生存確認（ps -p によるjavaプロセス確認）
   ├─ killシグナル送信（SIGTERM）
   └─ PIDファイルの削除
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B[SPARK_HOME設定確認]
    B --> C{SPARK_HOMEが未設定?}
    C -->|Yes| D[スクリプト配置場所から自動検出]
    C -->|No| E[spark-daemon.sh stop呼び出し]
    D --> E
    E --> F{PIDファイル存在?}
    F -->|No| G["メッセージ出力: no ... to stop"]
    F -->|Yes| H{プロセス生存確認}
    H -->|生存| I[killシグナル送信 + PIDファイル削除]
    H -->|停止済み| G
    I --> J[バッチ終了]
    G --> J
```

## データベース操作仕様

### 操作別データベース影響一覧

本バッチはデータベース操作を行わない。

### テーブル別操作詳細

該当なし

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| なし | 停止対象不在 | PIDファイルが存在しない、またはプロセスが既に停止している | 「no ... to stop」メッセージを出力して正常終了 |
| なし | SPARK_HOME不正 | SPARK_HOMEの自動検出に失敗 | SPARK_HOME環境変数を手動で正しく設定する |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | なし |
| リトライ間隔 | 該当なし |
| リトライ対象エラー | 該当なし |

### 障害時対応

停止に失敗した場合は、PIDファイルからプロセスIDを確認し、手動で `kill` コマンドを実行する。PIDファイルが残存している場合は手動で削除する。

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | 該当なし（シェルスクリプトのためトランザクション管理なし） |
| コミットタイミング | 該当なし |
| ロールバック条件 | 該当なし |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 1プロセス |
| 目標処理時間 | 数秒以内 |
| メモリ使用量上限 | シェルスクリプトのため最小限 |

## 排他制御

同時に複数回実行された場合でも、PIDファイルに基づく制御により安全に動作する。2回目以降の実行では「no ... to stop」が出力される。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 停止ログ | プロセス停止時 | 「stopping org.apache.spark.deploy.history.HistoryServer」 |
| 不在ログ | 停止対象がない場合 | 「no org.apache.spark.deploy.history.HistoryServer to stop」 |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| 該当なし | - | 本スクリプト自体に監視・アラート機能は実装されていない |

## 備考

- 本スクリプトはインスタンス番号を固定値「1」で呼び出しており、単一インスタンスのみを前提としている。
- 停止処理の実体は `spark-daemon.sh`（No.16）の stop オプションに実装されている。
- ソースファイルパス: `sbin/stop-history-server.sh`
