# バッチ設計書 12-start-thriftserver.sh

## 概要

本ドキュメントは、Spark SQL Thrift JDBC/ODBCサーバーを起動するシェルスクリプト `start-thriftserver.sh` のバッチ設計書である。スクリプトの処理内容、実行条件、入出力仕様、エラー処理等について記載する。

### 本バッチの処理概要

`start-thriftserver.sh` は、Spark SQL Thrift JDBC/ODBCサーバー（HiveThriftServer2）をデーモンプロセスとして起動するシェルスクリプトである。JDBC/ODBCクライアントからSpark SQLに対してクエリを実行するためのエンドポイントを提供する。内部的には `spark-daemon.sh` の submit モードを使用し、`spark-submit` 経由でHiveThriftServer2クラスを起動する。

**業務上の目的・背景**：BIツールやETLツールなどの外部クライアントからJDBC/ODBC経由でSpark SQLにアクセスするためには、Thriftサーバーが必要である。このスクリプトにより、HiveThriftServer2を統一的なデーモン管理インターフェースを通じて起動し、PID管理やログ管理を含むプロセスライフサイクル管理を実現する。

**バッチの実行タイミング**：手動実行が基本。Sparkクラスタのセットアップ時やThriftサーバーの再起動時に管理者が実行する。

**主要な処理内容**：
1. SPARK_CONNECT_MODE環境変数を0に設定（非Connectモード）
2. SPARK_HOME環境変数の設定（未設定の場合はスクリプト配置場所から自動検出）
3. `--help` / `-h` オプションが指定された場合、使用方法を表示して終了
4. `spark-daemon.sh` の submit モードで HiveThriftServer2 クラスをデーモンとして起動

**前後の処理との関連**：`stop-thriftserver.sh`（No.13）と対になるスクリプトである。起動処理は `spark-daemon.sh`（No.16）のsubmitモードに委譲され、さらに内部で `spark-submit`（No.20）が呼び出される。

**影響範囲**：Thriftサーバーが起動することで、JDBC/ODBCクライアントからのSpark SQLクエリ実行が可能となる。Hiveメタストアへのアクセスが発生する。

## バッチ種別

デーモン管理（プロセス起動）

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 随時 |
| 実行時刻 | 任意 |
| 実行曜日 | 該当なし |
| 実行日 | 該当なし |
| トリガー | 手動 |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| SPARK_HOME | 環境変数が設定済み、または自動検出可能であること |
| spark-daemon.sh | `${SPARK_HOME}/sbin/spark-daemon.sh` が存在し実行可能であること |
| spark-submit | `${SPARK_HOME}/bin/spark-submit` が存在し実行可能であること |
| Java実行環境 | JAVA_HOMEまたはPATHにjavaコマンドが存在すること |
| Hive依存関係 | HiveThriftServer2クラスに必要なHive関連JARがクラスパスに含まれていること |

### 実行可否判定

`spark-daemon.sh` 内でPIDファイルの存在確認とプロセスの生存確認を行い、既に同名プロセスが稼働中の場合は「running as process [PID]. Stop it first.」というメッセージを出力し、起動を拒否する（終了コード1）。

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| --help / -h | フラグ | No | - | 使用方法を表示して終了 |
| [options] | 文字列 | No | - | spark-submitに渡されるオプション（--master, --conf等） |
| [thrift server options] | 文字列 | No | - | HiveThriftServer2固有のオプション |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| PIDファイル | テキストファイル | 既存プロセスの確認に使用 |
| spark-env.sh | シェルスクリプト | Spark環境設定の読み込み |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| 標準出力 | テキスト | 起動処理のステータスメッセージ |
| 標準エラー出力 | テキスト | ヘルプ情報（--help時） |
| PIDファイル | テキスト | 起動したプロセスのPID |
| ログファイル | テキスト | デーモンの出力ログ |

### 出力ファイル仕様

| 項目 | 内容 |
|-----|------|
| PIDファイル名 | `spark-${SPARK_IDENT_STRING}-org.apache.spark.sql.hive.thriftserver.HiveThriftServer2-1.pid` |
| PID出力先 | `${SPARK_PID_DIR}/`（デフォルト: /tmp） |
| ログファイル名 | `spark-${SPARK_IDENT_STRING}-org.apache.spark.sql.hive.thriftserver.HiveThriftServer2-1-${HOSTNAME}.out` |
| ログ出力先 | `${SPARK_LOG_DIR}/`（デフォルト: ${SPARK_HOME}/logs） |

## 処理フロー

### 処理シーケンス

```
1. SPARK_CONNECT_MODE=0 を設定
   └─ 非Connectモードであることを明示
2. POSIXモードを有効化（set -o posix）
   └─ Bashの拡張機能を制限し互換性を確保
3. SPARK_HOME環境変数の確認・設定
   └─ 未設定の場合、スクリプトの配置ディレクトリから親ディレクトリを算出
4. 起動クラスの設定
   └─ CLASS=org.apache.spark.sql.hive.thriftserver.HiveThriftServer2
5. ヘルプオプションの判定
   └─ --help/-hが指定された場合、usage関数を呼び出して終了
6. SUBMIT_USAGE_FUNCTION環境変数の設定
   └─ spark-submit内でのヘルプ表示をカスタマイズ
7. spark-daemon.sh submit の呼び出し
   └─ exec経由で spark-daemon.sh submit $CLASS 1 --name "Thrift JDBC/ODBC Server" "$@" を実行
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B[SPARK_CONNECT_MODE=0設定]
    B --> C[POSIXモード有効化]
    C --> D[SPARK_HOME設定確認]
    D --> E{--help/-h指定?}
    E -->|Yes| F[usage関数でヘルプ表示]
    F --> G[終了 exit 0]
    E -->|No| H[SUBMIT_USAGE_FUNCTION設定]
    H --> I[spark-daemon.sh submit呼び出し]
    I --> J{既存プロセス稼働中?}
    J -->|Yes| K["エラー: Stop it first."]
    J -->|No| L[ログローテーション]
    L --> M[spark-submit --class で起動]
    M --> N{デーモンモード?}
    N -->|Yes| O[nohupでバックグラウンド起動]
    N -->|No| P[フォアグラウンド起動]
    O --> Q[PIDファイル書き込み]
    Q --> R[プロセス起動確認]
    R --> S[バッチ終了]
    P --> S
    K --> S
```

## データベース操作仕様

### 操作別データベース影響一覧

本スクリプト自体はデータベース操作を行わない。ただし、起動されるHiveThriftServer2はHiveメタストアに接続する。

### テーブル別操作詳細

該当なし（スクリプトレベルでは該当なし）

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| 終了コード1 | 既存プロセス稼働中 | 同じクラス・インスタンス番号のプロセスが既に稼働中 | stop-thriftserver.shで先に停止する |
| 終了コード1 | SPARK_HOME不正 | SPARK_HOMEの自動検出に失敗 | SPARK_HOME環境変数を手動で正しく設定する |
| なし | 起動失敗 | Javaプロセスが起動後すぐに終了 | ログファイルの末尾10行を表示。ログファイルで詳細を確認 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | なし |
| リトライ間隔 | 該当なし |
| リトライ対象エラー | 該当なし |

### 障害時対応

起動失敗時はログファイル `${SPARK_LOG_DIR}/spark-*-org.apache.spark.sql.hive.thriftserver.HiveThriftServer2-*.out` を確認する。PIDファイルが残存している場合は手動で削除し、再度起動を試みる。

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | 該当なし（シェルスクリプトのためトランザクション管理なし） |
| コミットタイミング | 該当なし |
| ロールバック条件 | 該当なし |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 1プロセス |
| 目標処理時間 | 起動確認まで約7秒（5秒のポーリング + 2秒のスリープ） |
| メモリ使用量上限 | スクリプト自体は最小限。起動されるJVMのメモリはSpark設定に依存 |

## 排他制御

PIDファイルによる排他制御が行われる。同一クラス名・インスタンス番号のプロセスが既に稼働中の場合、新たな起動は拒否される。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 開始ログ | デーモン起動時 | 「starting org.apache.spark.sql.hive.thriftserver.HiveThriftServer2, logging to [ログパス]」 |
| 起動失敗ログ | プロセス起動失敗時 | 「failed to launch: [コマンド]」+ ログ末尾10行 |
| rsyncログ | SPARK_MASTER設定時 | 「rsync from [SPARK_MASTER]」 |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| 該当なし | - | 本スクリプト自体に監視・アラート機能は実装されていない |

## 備考

- SPARK_CONNECT_MODE=0 が設定されており、Spark Connectモードとは異なる従来のThriftサーバーモードで動作する。
- `exec` コマンドで `spark-daemon.sh` を呼び出しているため、本スクリプトのプロセスは `spark-daemon.sh` に置き換わる。
- `--name "Thrift JDBC/ODBC Server"` がアプリケーション名として設定される。
- HiveThriftServer2のクラス名は `SparkSubmit` 内部で特別にマッチングされるため、変更する場合は `SparkSubmit` 側の修正も必要。
- ソースファイルパス: `sbin/start-thriftserver.sh`
