# バッチ設計書 16-spark-daemon.sh

## 概要

本ドキュメントは、Sparkデーモンプロセスの起動・停止・状態確認を行う汎用シェルスクリプト `spark-daemon.sh` のバッチ設計書である。全てのSparkデーモン管理スクリプトの基盤となるスクリプトであり、PID管理、ログローテーション、プロセスライフサイクル管理を提供する。

### 本バッチの処理概要

`spark-daemon.sh` は、Sparkの各種デーモンプロセス（Master、Worker、History Server、Thrift Server、Connect Server等）の起動（start/submit）、停止（stop）、デコミッション（decommission）、状態確認（status）を一元的に管理する汎用スクリプトである。他のデーモン管理スクリプトから呼び出される中核的な基盤スクリプトとして機能する。

**業務上の目的・背景**：Sparkクラスタでは複数種類のデーモンプロセスが稼働する。各デーモンごとに個別の起動・停止ロジックを実装するのではなく、PID管理、ログローテーション、プロセス生存確認、デーモン化処理といった共通機能を本スクリプトに集約することで、統一的で信頼性の高いデーモン管理基盤を提供する。

**バッチの実行タイミング**：直接実行も可能だが、通常は `start-master.sh`、`start-worker.sh`、`start-history-server.sh`、`start-thriftserver.sh`、`start-connect-server.sh` 等の上位スクリプトから呼び出される。

**主要な処理内容**：
1. 設定ディレクトリの初期化（spark-config.sh、load-spark-env.sh）
2. ログディレクトリ・PIDディレクトリの準備
3. ログローテーション（SPARK_LOG_MAX_FILES件数管理）
4. start モード: `spark-class` 経由でJavaクラスを直接起動
5. submit モード: `spark-submit` 経由でJavaクラスを起動
6. stop モード: PIDファイルに基づくプロセスのkill
7. decommission モード: SIGPWRシグナルによる安全な停止
8. status モード: プロセスの稼働状況を確認

**前後の処理との関連**：全てのデーモン起動・停止スクリプト（No.1-15）から呼び出される。内部で `spark-config.sh`（No.19）、`load-spark-env.sh`（No.30関連）、`spark-class`（No.21関連）、`spark-submit`（No.20）を使用する。

**影響範囲**：全てのSparkデーモンプロセスのライフサイクルに影響する。本スクリプトの動作不良は全デーモンの起動・停止に影響を与える。

## バッチ種別

デーモン基盤（プロセスライフサイクル管理）

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 随時（上位スクリプトからの呼び出し） |
| 実行時刻 | 任意 |
| 実行曜日 | 該当なし |
| 実行日 | 該当なし |
| トリガー | 上位スクリプトからの呼び出し / 手動 |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| SPARK_HOME | 環境変数が設定済み、または自動検出可能であること |
| spark-config.sh | `${SPARK_HOME}/sbin/spark-config.sh` が存在すること |
| load-spark-env.sh | `${SPARK_HOME}/bin/load-spark-env.sh` が存在すること |
| Java実行環境 | start/submitモード時: JAVA_HOMEまたはPATHにjavaコマンドが存在すること |
| ログディレクトリ | 書き込み権限があること（なければ自動作成を試行） |

### 実行可否判定

- **start/submitモード**: PIDファイルが存在し、該当プロセスが稼働中の場合は「running as process [PID]. Stop it first.」を出力して終了コード1で中断
- **stopモード**: PIDファイルが存在しない、またはプロセスが停止済みの場合は「no [command] to stop」を出力
- **decommissionモード**: PIDファイルが存在しない、またはプロセスが停止済みの場合は「no [command] to decommission」を出力

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| --config \<conf-dir\> | 文字列 | No | ${SPARK_HOME}/conf | Spark設定ディレクトリのパス |
| option | 文字列 | Yes | - | 操作種別: start / stop / submit / decommission / status |
| spark-command | 文字列 | Yes | - | 起動するJavaクラスのFQCN |
| spark-instance-number | 数値 | Yes | - | インスタンス番号（PIDファイル・ログファイルの識別に使用） |
| args... | 文字列 | No | - | Javaクラスに渡す追加引数 |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| PIDファイル | テキストファイル | `${SPARK_PID_DIR}/spark-${SPARK_IDENT_STRING}-${command}-${instance}.pid` |
| spark-config.sh | シェルスクリプト | SPARK_HOME、SPARK_CONF_DIR、PYTHONPATHの初期化 |
| load-spark-env.sh | シェルスクリプト | spark-env.shの読み込みとScalaバージョン設定 |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| 標準出力 | テキスト | 操作ステータスメッセージ |
| PIDファイル | テキスト | 起動したプロセスのPID（startおよびsubmitモード時） |
| ログファイル | テキスト | デーモンプロセスの標準出力・標準エラー出力 |

### 出力ファイル仕様

| 項目 | 内容 |
|-----|------|
| PIDファイル名 | `spark-${SPARK_IDENT_STRING}-${command}-${instance}.pid` |
| PID出力先 | `${SPARK_PID_DIR}/`（デフォルト: /tmp） |
| ログファイル名 | `spark-${SPARK_IDENT_STRING}-${command}-${instance}-${HOSTNAME}.out` |
| ログ出力先 | `${SPARK_LOG_DIR}/`（デフォルト: ${SPARK_HOME}/logs） |
| 文字コード | UTF-8 |

## 処理フロー

### 処理シーケンス

```
1. 引数チェック（2個以上必要）
   └─ 不足時はusageを表示して終了
2. SPARK_HOME環境変数の確認・設定
   └─ 未設定の場合、スクリプト配置場所から自動検出
3. spark-config.shの読み込み
   └─ SPARK_CONF_DIR、PYTHONPATHの設定
4. --configオプションの処理
   └─ 指定された場合、SPARK_CONF_DIRを上書き
5. 引数のパース（option, command, instance）
6. SPARK_CONNECT_MODE=0の設定
7. load-spark-env.shの読み込み
   └─ spark-env.shの環境変数をロード
8. SPARK_IDENT_STRINGの設定
   └─ デフォルト: $USER
9. ログディレクトリの準備
   └─ mkdir -p、書き込みテスト
10. PIDディレクトリの準備
    └─ デフォルト: /tmp
11. ログファイル・PIDファイルパスの決定
12. SPARK_NICENESSの設定（デフォルト: 0）
13. オプション別の処理分岐
    ├─ start: run_command class → spark-class経由で起動
    ├─ submit: run_command submit → spark-submit経由で起動
    ├─ stop: PIDファイルからkill
    ├─ decommission: PIDファイルからSIGPWR送信
    └─ status: プロセス稼働確認
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B{引数チェック}
    B -->|不足| C[usage表示・終了]
    B -->|OK| D[環境変数初期化]
    D --> E[spark-config.sh読み込み]
    E --> F[--configオプション処理]
    F --> G[引数パース]
    G --> H[load-spark-env.sh読み込み]
    H --> I[ログ・PIDディレクトリ準備]
    I --> J{操作種別}
    J -->|start| K[run_command class]
    J -->|submit| L[run_command submit]
    J -->|stop| M[stop処理]
    J -->|decommission| N[decommission処理]
    J -->|status| O[status処理]
    K --> P{既存プロセス確認}
    L --> P
    P -->|稼働中| Q["エラー: Stop it first."]
    P -->|なし| R[ログローテーション]
    R --> S[execute_command]
    S --> T{SPARK_NO_DAEMONIZE?}
    T -->|未設定| U[nohupバックグラウンド起動]
    T -->|設定| V[フォアグラウンド起動]
    U --> W[PIDファイル書込]
    W --> X[起動確認ポーリング]
    M --> Y{PIDファイル存在?}
    Y -->|Yes| Z{プロセス生存?}
    Y -->|No| AA["no ... to stop"]
    Z -->|Yes| AB[kill + PIDファイル削除]
    Z -->|No| AA
    N --> AC{PIDファイル存在?}
    AC -->|Yes| AD{プロセス生存?}
    AC -->|No| AE["no ... to decommission"]
    AD -->|Yes| AF[SIGPWR送信]
    AD -->|No| AE
    O --> AG{PIDファイル存在?}
    AG -->|Yes| AH{プロセス生存?}
    AG -->|No| AI["not running exit 2"]
    AH -->|Yes| AJ["running exit 0"]
    AH -->|No| AK["PIDファイルあるが停止 exit 1"]
```

## データベース操作仕様

### 操作別データベース影響一覧

本バッチはデータベース操作を行わない。

### テーブル別操作詳細

該当なし

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| 終了コード1 | 引数不足 | 引数が1個以下 | usage文法に従い正しい引数を指定 |
| 終了コード1 | 設定ディレクトリ不正 | --configで指定したパスがディレクトリでない | 正しいディレクトリパスを指定 |
| 終了コード1 | 既存プロセス稼働中 | start/submit時に同名プロセスが稼働中 | stop後に再度起動 |
| 終了コード-1 | ログ設定不正 | SPARK_LOG_MAX_FILESが正の整数でない | 正しい値を設定 |
| 終了コード1 | 不明モード | run_command内で未知のモード | classまたはsubmitを指定 |
| 終了コード1 | 不明オプション | start/stop/submit/decommission/status以外 | 正しいオプションを指定 |
| なし | 起動失敗 | Javaプロセスが起動後5秒以内に終了 | ログファイル末尾10行を表示、ログで詳細確認 |
| 終了コード1 | status: PIDファイルあり・プロセスなし | PIDファイルは存在するがプロセスが停止 | PIDファイルを手動削除 |
| 終了コード2 | status: PIDファイルなし | PIDファイルが存在しない | プロセスが稼働していないことを確認 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | なし（スクリプトレベル） |
| リトライ間隔 | 該当なし |
| リトライ対象エラー | 該当なし |

### 障害時対応

- 起動失敗時: ログファイルで原因を調査。PIDファイルが残存している場合は手動削除。
- 停止失敗時: PIDファイルからプロセスIDを確認し `kill -9` で強制終了後、PIDファイルを手動削除。
- デコミッション失敗時: SIGPWRが効かない場合は通常のstop（SIGTERM）を試みる。

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | 該当なし（シェルスクリプトのためトランザクション管理なし） |
| コミットタイミング | 該当なし |
| ロールバック条件 | 該当なし |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 1プロセス/実行 |
| 目標処理時間 | start/submit: 起動確認まで最大7秒（ポーリング5秒 + スリープ2秒）。stop/status: 数秒以内 |
| メモリ使用量上限 | スクリプト自体は最小限 |

## 排他制御

PIDファイルによる排他制御を実装。同一コマンド・インスタンス番号の組み合わせに対して、重複起動を防止する。プロセスの生存確認は `ps -p` コマンドでjavaプロセスのcomm名をチェックする正規表現マッチングで行われる。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 開始ログ | デーモン起動時 | 「starting [command], logging to [ログパス]」 |
| 起動失敗ログ | 起動後プロセス終了時 | 「failed to launch: [コマンド]」+ ログ末尾10行 + 「full log in [ログパス]」 |
| 停止ログ | プロセス停止時 | 「stopping [command]」 |
| 停止対象不在ログ | 停止対象なし時 | 「no [command] to stop」 |
| デコミッションログ | デコミッション時 | 「decommissioning [command]」 |
| デコミッション対象不在ログ | 対象なし時 | 「no [command] to decommission」 |
| ステータスログ | status時 | 「[command] is running.」/「[command] not running.」 |
| rsyncログ | SPARK_MASTER設定時 | 「rsync from [SPARK_MASTER]」 |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| 該当なし | - | 本スクリプト自体に監視・アラート機能は実装されていない |

## 備考

- **ログローテーション**: `spark_rotate_log` 関数により、SPARK_LOG_MAX_FILES（デフォルト5）件のログファイルをローテーション管理する。
- **SPARK_MASTER環境変数**: 設定されている場合、起動前にrsyncでコードを同期する機能がある。
- **SPARK_NICENESS**: デーモンプロセスのスケジューリング優先度を `nice` コマンドで制御。デフォルト0。
- **SPARK_NO_DAEMONIZE**: 設定されている場合、nohupを使わずフォアグラウンドで実行し、PIDファイルを生成しない。
- **SPARK_PRINT_LAUNCH_COMMAND**: 常に「1」に設定され、起動コマンドが出力される。
- **プロセス起動確認**: デーモンモード時、最大5秒間（0.5秒間隔で10回）Javaプロセスの起動をポーリングし、さらに2秒待機後にプロセス生存を確認する。
- **decommission**: SIGPWR（シグナル番号30）を使用してプロセスの安全な停止（デコミッション）を要求する。PIDファイルは削除されない（プロセス自体が終了処理を行う想定）。
- ソースファイルパス: `sbin/spark-daemon.sh`
