# バッチ設計書 17-spark-daemons.sh

## 概要

本ドキュメントは、全Workerノードに対してデーモン操作を実行するシェルスクリプト `spark-daemons.sh` のバッチ設計書である。`workers.sh` を通じてSSH経由で全Workerノードに `spark-daemon.sh` コマンドを分配する。

### 本バッチの処理概要

`spark-daemons.sh` は、`conf/workers` に記載された全Workerノードに対して、`spark-daemon.sh` コマンドをSSH経由で一括実行するシェルスクリプトである。`workers.sh`（No.18）を介してリモートノードにコマンドを分配する仲介的な役割を担う。

**業務上の目的・背景**：Sparkクラスタでは複数のWorkerノードが稼働する。各ノードに個別にSSHでログインしてデーモン操作を行うのは非効率かつエラーが発生しやすい。本スクリプトにより、マスターノードから全Workerノードに対して一括でデーモンの起動・停止等の操作を実行でき、クラスタ管理の効率化と統一性を実現する。

**バッチの実行タイミング**：手動実行、または上位スクリプト（start-workers.sh、stop-workers.sh等）から呼び出される。

**主要な処理内容**：
1. SPARK_HOME環境変数の設定（未設定の場合はスクリプト配置場所から自動検出）
2. `spark-config.sh` の読み込みによる設定初期化
3. `workers.sh` を経由して全Workerノードで `spark-daemon.sh` コマンドを実行

**前後の処理との関連**：`start-workers.sh`（No.7）や `stop-workers.sh`（No.8）から呼び出される。内部で `workers.sh`（No.18）を使用し、各ノードでは `spark-daemon.sh`（No.16）が実行される。`spark-config.sh`（No.19）を読み込む。

**影響範囲**：`conf/workers` ファイルに記載された全Workerノードのデーモンプロセスに影響する。

## バッチ種別

デーモン基盤（リモートデーモン操作の分配）

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 随時 |
| 実行時刻 | 任意 |
| 実行曜日 | 該当なし |
| 実行日 | 該当なし |
| トリガー | 上位スクリプトからの呼び出し / 手動 |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| SPARK_HOME | 環境変数が設定済み、または自動検出可能であること |
| spark-config.sh | `${SPARK_HOME}/sbin/spark-config.sh` が存在すること |
| workers.sh | `${SPARK_HOME}/sbin/workers.sh` が存在し実行可能であること |
| spark-daemon.sh | `${SPARK_HOME}/sbin/spark-daemon.sh` が各Workerノードに存在すること |
| SSHアクセス | マスターノードから全WorkerノードへパスワードなしSSH接続が可能であること |
| workersファイル | `${SPARK_CONF_DIR}/workers` にWorkerノードのホスト名が記載されていること |

### 実行可否判定

引数が1個以下の場合、usageを表示して終了コード1で中断する。

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| --config \<conf-dir\> | 文字列 | No | ${SPARK_HOME}/conf | Spark設定ディレクトリのパス |
| start\|stop | 文字列 | Yes | - | spark-daemon.shに渡す操作種別 |
| command | 文字列 | Yes | - | spark-daemon.shに渡すJavaクラスのFQCN |
| instance-number | 数値 | Yes | - | spark-daemon.shに渡すインスタンス番号 |
| args... | 文字列 | No | - | spark-daemon.shに渡す追加引数 |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| conf/workers | テキストファイル | Workerノードのホスト名一覧（workers.sh経由で参照） |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| 標準出力 | テキスト | 各Workerノードでの実行結果（ホスト名プレフィックス付き） |

### 出力ファイル仕様

本スクリプト自体はファイル出力を行わない。各Workerノードで実行される `spark-daemon.sh` がPIDファイルやログファイルを出力する。

## 処理フロー

### 処理シーケンス

```
1. 引数チェック（2個以上必要）
   └─ 不足時はusageを表示して終了
2. SPARK_HOME環境変数の確認・設定
   └─ 未設定の場合、スクリプト配置場所から自動検出
3. spark-config.shの読み込み
   └─ SPARK_CONF_DIR等の初期化
4. workers.sh経由でコマンドを分配
   └─ exec workers.sh cd "${SPARK_HOME}" ; spark-daemon.sh "$@"
   └─ 各Workerノードで: SPARK_HOMEにcd後、spark-daemon.shを引数付きで実行
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B{引数チェック}
    B -->|不足| C[usage表示・終了]
    B -->|OK| D[SPARK_HOME設定確認]
    D --> E[spark-config.sh読み込み]
    E --> F["exec workers.sh実行"]
    F --> G[各Workerノードにコマンド分配]
    G --> H["ノード1: cd SPARK_HOME ; spark-daemon.sh ..."]
    G --> I["ノード2: cd SPARK_HOME ; spark-daemon.sh ..."]
    G --> J["ノードN: cd SPARK_HOME ; spark-daemon.sh ..."]
    H --> K[バッチ終了]
    I --> K
    J --> K
```

## データベース操作仕様

### 操作別データベース影響一覧

本バッチはデータベース操作を行わない。

### テーブル別操作詳細

該当なし

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| 終了コード1 | 引数不足 | 引数が1個以下 | usage文法に従い正しい引数を指定 |
| なし | SSH接続失敗 | Workerノードへの接続不可 | ネットワーク接続・SSH設定を確認 |
| なし | spark-daemon.sh不在 | リモートノードにspark-daemon.shが存在しない | リモートノードにSparkを配置する |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | なし |
| リトライ間隔 | 該当なし |
| リトライ対象エラー | 該当なし |

### 障害時対応

個別のWorkerノードで失敗した場合、そのノードに直接SSH接続してデーモン操作を手動実行する。

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | 該当なし（シェルスクリプトのためトランザクション管理なし） |
| コミットタイミング | 該当なし |
| ロールバック条件 | 該当なし |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | workersファイルに記載されたノード数分 |
| 目標処理時間 | ノード数とネットワーク遅延に依存 |
| メモリ使用量上限 | シェルスクリプトのため最小限 |

## 排他制御

本スクリプト自体に排他制御はない。各Workerノード上での排他制御は `spark-daemon.sh` のPIDファイル機構により実現される。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 実行結果 | 各ノードでのコマンド実行時 | 各ノードの出力に「ホスト名: 」プレフィックスが付与（workers.shの機能） |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| 該当なし | - | 本スクリプト自体に監視・アラート機能は実装されていない |

## 備考

- `exec` コマンドで `workers.sh` を呼び出しているため、本スクリプトのプロセスは `workers.sh` に置き換わる。
- コマンドの構造: `workers.sh cd "${SPARK_HOME}" ; spark-daemon.sh "$@"` により、各リモートノードでまずSPARK_HOMEにcdしてからspark-daemon.shを実行する。
- 本スクリプトは薄いラッパーであり、実際の処理は `workers.sh`（No.18）と `spark-daemon.sh`（No.16）に委譲される。
- ソースファイルパス: `sbin/spark-daemons.sh`
