# バッチ設計書 18-workers.sh

## 概要

本ドキュメントは、`conf/workers` に記載された全ホストでコマンドをSSH実行するシェルスクリプト `workers.sh` のバッチ設計書である。Sparkクラスタの全Workerノードに対してリモートコマンドを分配する汎用スクリプトである。

### 本バッチの処理概要

`workers.sh` は、`conf/workers`（または環境変数で指定されたファイル）に記載された全Workerノードに対して、SSH経由で任意のコマンドを一括実行する汎用シェルスクリプトである。デフォルトでは各ノードへの接続はバックグラウンドで並行実行され、全接続完了後に `wait` で終了を待機する。

**業務上の目的・背景**：Sparkクラスタの運用においては、複数のWorkerノードに対して同一の操作を一括で実行する必要がある。本スクリプトにより、管理者は個別のノードにSSH接続することなく、マスターノードから一元的にクラスタ全体の操作を実行できる。Worker起動・停止だけでなく、任意のコマンドを全ノードに分配する汎用性を持つ。

**バッチの実行タイミング**：通常は上位スクリプト（`spark-daemons.sh`、`start-workers.sh`、`stop-workers.sh` 等）から呼び出される。直接実行も可能。

**主要な処理内容**：
1. SPARK_HOME環境変数の設定と設定初期化
2. `--config` オプションによる設定ディレクトリの上書き（オプション）
3. Workerノードのホスト一覧の取得（SPARK_WORKERS環境変数、conf/workers、conf/slaves、またはデフォルトlocalhost）
4. SSHオプションの設定（デフォルト: StrictHostKeyChecking=no）
5. 各Workerノードに対してSSH経由でコマンドを実行（デフォルトはバックグラウンド並列実行）
6. 全SSHプロセスの完了を待機

**前後の処理との関連**：`spark-daemons.sh`（No.17）から呼び出されるほか、`start-workers.sh`（No.7）や `stop-workers.sh`（No.8）からも間接的に利用される。`spark-config.sh`（No.19）と `load-spark-env.sh`（No.30関連）を読み込む。

**影響範囲**：`conf/workers` ファイルに記載された全ノードに対してSSH経由でコマンドが実行される。

## バッチ種別

デーモン基盤（リモートコマンド分配）

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 随時 |
| 実行時刻 | 任意 |
| 実行曜日 | 該当なし |
| 実行日 | 該当なし |
| トリガー | 上位スクリプトからの呼び出し / 手動 |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| SPARK_HOME | 環境変数が設定済み、または自動検出可能であること |
| spark-config.sh | `${SPARK_HOME}/sbin/spark-config.sh` が存在すること |
| load-spark-env.sh | `${SPARK_HOME}/bin/load-spark-env.sh` が存在すること |
| SSHアクセス | 実行ユーザーから全Workerノードへパスワードなしのssh接続が可能であること |
| workersファイル | ホスト名一覧ファイルが存在するか、SPARK_WORKERS環境変数が設定されていること |

### 実行可否判定

引数が0個の場合、usageを表示して終了コード1で中断する。

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| --config \<conf-dir\> | 文字列 | No | ${SPARK_HOME}/conf | Spark設定ディレクトリのパス |
| command... | 文字列 | Yes | - | 各Workerノードで実行するコマンド |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| conf/workers | テキストファイル | Workerノードのホスト名一覧（1行1ホスト、#でコメント） |
| conf/slaves | テキストファイル | 非推奨。workersファイルが存在しない場合のフォールバック |
| SPARK_WORKERS環境変数 | ファイルパス | workersファイルのカスタムパス |
| SPARK_SLAVES環境変数 | ファイルパス | 非推奨。SPARK_WORKERSのフォールバック |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| 標準出力 | テキスト | 各ノードの出力に「ホスト名: 」プレフィックスが付与 |
| 標準エラー出力 | テキスト | 非推奨警告メッセージ（SPARK_SLAVES使用時） |

### 出力ファイル仕様

本スクリプト自体はファイル出力を行わない。

## 処理フロー

### 処理シーケンス

```
1. 引数チェック（1個以上必要）
   └─ 不足時はusageを表示して終了
2. SPARK_HOME環境変数の確認・設定
3. spark-config.shの読み込み
4. SPARK_WORKERS/SPARK_SLAVESファイルの事前読み込み
   └─ SPARK_SLAVES使用時は非推奨警告を出力
5. --configオプションの処理
   └─ SPARK_CONF_DIRの上書き
6. load-spark-env.shの読み込み
7. ホスト一覧の決定
   ├─ SPARK_WORKERS/SPARK_SLAVESファイルが指定済みの場合: そのファイルを使用
   ├─ conf/workersファイルが存在する場合: そのファイルを使用
   ├─ conf/slavesファイルが存在する場合: そのファイルを使用（フォールバック）
   └─ いずれもない場合: "localhost" をデフォルトとして使用
8. SSHオプションの設定
   └─ SPARK_SSH_OPTS未設定時: "-o StrictHostKeyChecking=no"
9. 各ホストに対してSSHコマンドを実行
   ├─ SPARK_SSH_FOREGROUND設定時: フォアグラウンドで逐次実行
   └─ 未設定時: バックグラウンドで並列実行
10. SPARK_WORKER_SLEEP/SPARK_SLAVE_SLEEP秒のスリープ（設定時）
11. 全バックグラウンドプロセスのwait
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B{引数チェック}
    B -->|不足| C[usage表示・終了]
    B -->|OK| D[環境変数初期化]
    D --> E[spark-config.sh読み込み]
    E --> F[SPARK_WORKERS/SLAVESファイル事前読み込み]
    F --> G[--configオプション処理]
    G --> H[load-spark-env.sh読み込み]
    H --> I[ホスト一覧決定]
    I --> J[SSHオプション設定]
    J --> K[ホスト一覧をループ]
    K --> L{SPARK_SSH_FOREGROUND?}
    L -->|Yes| M["ssh host command 2>&1 | sed (フォアグラウンド)"]
    L -->|No| N["ssh host command 2>&1 | sed & (バックグラウンド)"]
    M --> O{SPARK_WORKER_SLEEP?}
    N --> O
    O -->|Yes| P[sleep]
    O -->|No| Q[次のホスト]
    P --> Q
    Q --> K
    K -->|全ホスト完了| R[wait: 全プロセス完了待機]
    R --> S[バッチ終了]
```

## データベース操作仕様

### 操作別データベース影響一覧

本バッチはデータベース操作を行わない。

### テーブル別操作詳細

該当なし

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| 終了コード1 | 引数不足 | 引数が0個 | usage文法に従い正しい引数を指定 |
| 終了コード1 | 設定ディレクトリ不正 | --configで指定したパスがディレクトリでない | 正しいディレクトリパスを指定 |
| なし | SSH接続失敗 | Workerノードへの接続不可 | ネットワーク接続・SSH設定を確認 |
| なし | workersファイル不在 | workers/slavesファイルが見つからない | localhostにフォールバック |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | なし |
| リトライ間隔 | 該当なし |
| リトライ対象エラー | 該当なし |

### 障害時対応

個別のWorkerノードで失敗した場合、そのノードに直接SSH接続してコマンドを手動実行する。SSH接続設定を見直す。

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | 該当なし（シェルスクリプトのためトランザクション管理なし） |
| コミットタイミング | 該当なし |
| ロールバック条件 | 該当なし |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | workersファイルに記載されたノード数分 |
| 目標処理時間 | ノード数・ネットワーク遅延・SPARK_WORKER_SLEEPに依存 |
| メモリ使用量上限 | シェルスクリプトのため最小限 |

## 排他制御

本スクリプト自体に排他制御はない。SSH接続はデフォルトでバックグラウンドの並列実行であり、SPARK_SSH_FOREGROUND環境変数を設定することでフォアグラウンドの逐次実行に切り替え可能。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| コマンド出力 | 各ノードでのコマンド実行時 | 各ノードの出力に「ホスト名: 」プレフィックスが付与（sed "s/^/$host: /"） |
| 非推奨警告 | SPARK_SLAVES使用時 | 「SPARK_SLAVES is deprecated, use SPARK_WORKERS」 |
| 非推奨警告 | SPARK_SLAVE_SLEEP使用時 | 「SPARK_SLAVE_SLEEP is deprecated, use SPARK_WORKER_SLEEP」 |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| 該当なし | - | 本スクリプト自体に監視・アラート機能は実装されていない |

## 備考

- **ホストリストのフォーマット**: `#` 以降はコメントとして無視され、空行もスキップされる（`sed "s/#.*$//;/^$/d"`）。
- **SSH設定**: デフォルトでStrictHostKeyChecking=noが設定される。セキュリティ要件に応じてSPARK_SSH_OPTSで上書き可能。
- **並列実行制御**: SPARK_WORKER_SLEEP環境変数で各ノードへのSSH接続間にスリープを挿入可能。これによりSSH接続の同時多発を緩和できる。
- **フォアグラウンド実行**: SPARK_SSH_FOREGROUND環境変数を設定すると、各ノードへの接続を逐次（フォアグラウンド）で実行する。
- **非推奨パラメータ**: SPARK_SLAVES、SPARK_SLAVE_SLEEPは非推奨。SPARK_WORKERS、SPARK_WORKER_SLEEPを使用すること。conf/slavesも非推奨でconf/workersを使用すること。
- ソースファイルパス: `sbin/workers.sh`
