# バッチ設計書 19-spark-config.sh

## 概要

本ドキュメントは、Spark設定の初期化（SPARK_HOME、SPARK_CONF_DIR、PYTHONPATH）を行う共通設定スクリプト `spark-config.sh` のバッチ設計書である。全てのsbinスクリプトからsourceされる共通設定スクリプトであり、直接実行されることは想定されていない。

### 本バッチの処理概要

`spark-config.sh` は、Sparkの各種シェルスクリプトから `source` コマンドで読み込まれる共通設定スクリプトである。SPARK_HOME、SPARK_CONF_DIR、PYTHONPATHの初期設定を行い、全てのSparkスクリプトが統一された環境変数設定のもとで動作することを保証する。

**業務上の目的・背景**：Sparkの各種管理スクリプト（デーモン起動・停止、クライアント実行等）は、共通の環境変数（SPARK_HOME、SPARK_CONF_DIR、PYTHONPATH等）を必要とする。各スクリプトで個別に環境変数を設定するのではなく、本スクリプトに設定ロジックを集約することで、設定の一貫性を保ち、メンテナンス性を向上させている。

**バッチの実行タイミング**：直接実行されない。他のスクリプトからsourceされるタイミングで実行される。具体的には `spark-daemon.sh`、`spark-daemons.sh`、`workers.sh`、各start-/stop-スクリプト等から読み込まれる。

**主要な処理内容**：
1. SPARK_HOME環境変数の設定（未設定の場合はスクリプト配置場所から自動検出）
2. SPARK_CONF_DIR環境変数の設定（デフォルト: ${SPARK_HOME}/conf）
3. PYTHONPATHへのPySparkライブラリパスの追加（PYSPARK_PYTHONPATH_SET未設定時のみ）
4. PYSPARK_PYTHONPATH_SETフラグの設定（二重追加防止）

**前後の処理との関連**：`spark-daemon.sh`（No.16）、`spark-daemons.sh`（No.17）、`workers.sh`（No.18）等の多数のスクリプトからsourceされる。`load-spark-env.sh`（No.30関連）とは役割が異なり、本スクリプトは基本的な環境変数の設定のみを行う。

**影響範囲**：全てのSparkスクリプトの動作環境に影響する。SPARK_HOME、SPARK_CONF_DIR、PYTHONPATHの設定が全スクリプトに波及する。

## バッチ種別

環境設定（共通設定初期化）

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 他スクリプトから呼び出されるたびに実行 |
| 実行時刻 | 呼び出し元スクリプトに依存 |
| 実行曜日 | 該当なし |
| 実行日 | 該当なし |
| トリガー | 他スクリプトからの source 呼び出し |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| sourceでの呼び出し | 直接実行ではなく、他スクリプトから `source` で読み込まれること |
| SPARK_HOME | 環境変数が設定済み、またはスクリプト配置場所から自動検出可能であること |

### 実行可否判定

特別な実行可否判定ロジックは存在しない。sourceで読み込まれた時点で即座に設定処理が実行される。

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| なし | - | - | - | 本スクリプトはコマンドライン引数を受け取らない（sourceされるため） |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| 環境変数 SPARK_HOME | 文字列 | Sparkインストールディレクトリ |
| 環境変数 SPARK_CONF_DIR | 文字列 | Spark設定ディレクトリ |
| 環境変数 PYSPARK_PYTHONPATH_SET | フラグ | PYTHONPATHの二重追加防止フラグ |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| 環境変数 SPARK_HOME | 文字列 | Sparkインストールディレクトリ（未設定時のみ設定） |
| 環境変数 SPARK_CONF_DIR | 文字列 | Spark設定ディレクトリ（${SPARK_HOME}/conf またはカスタム値） |
| 環境変数 PYTHONPATH | 文字列 | PySparkライブラリパスが追加される |
| 環境変数 PYSPARK_PYTHONPATH_SET | フラグ | 値: 1（PYTHONPATHの二重追加防止） |

### 出力ファイル仕様

本スクリプトはファイル出力を行わない。環境変数のみを設定する。

## 処理フロー

### 処理シーケンス

```
1. SPARK_HOME環境変数の確認・設定
   └─ 未設定の場合、スクリプト配置場所の親ディレクトリをSPARK_HOMEに設定
2. SPARK_CONF_DIRの設定
   └─ 未設定の場合、${SPARK_HOME}/conf をデフォルト値として設定
3. PYTHONPATH設定の確認
   └─ PYSPARK_PYTHONPATH_SETが未設定の場合のみ以下を実行
4. PYTHONPATHにPySparkパスを追加
   ├─ ${SPARK_HOME}/python
   └─ ${SPARK_HOME}/python/lib/py4j-0.10.9.9-src.zip
5. PYSPARK_PYTHONPATH_SET=1 を設定
   └─ 二重追加防止フラグ
```

### フローチャート

```mermaid
flowchart TD
    A[source読み込み開始] --> B{SPARK_HOMEが未設定?}
    B -->|Yes| C[スクリプト配置場所から自動検出]
    B -->|No| D[SPARK_CONF_DIRの設定]
    C --> D
    D --> E{PYSPARK_PYTHONPATH_SETが未設定?}
    E -->|Yes| F["PYTHONPATHにPySparkパスを追加"]
    E -->|No| G[スキップ]
    F --> H["PYSPARK_PYTHONPATH_SET=1を設定"]
    H --> I[処理完了]
    G --> I
```

## データベース操作仕様

### 操作別データベース影響一覧

本スクリプトはデータベース操作を行わない。

### テーブル別操作詳細

該当なし

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| なし | SPARK_HOME自動検出失敗 | スクリプトの配置場所が想定と異なる | SPARK_HOME環境変数を手動で正しく設定する |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 該当なし |
| リトライ間隔 | 該当なし |
| リトライ対象エラー | 該当なし |

### 障害時対応

SPARK_HOMEの自動検出に失敗した場合、呼び出し元スクリプトの実行前にSPARK_HOME環境変数を手動で設定する。

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | 該当なし |
| コミットタイミング | 該当なし |
| ロールバック条件 | 該当なし |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 該当なし（環境変数設定のみ） |
| 目標処理時間 | 即時（ミリ秒単位） |
| メモリ使用量上限 | 最小限（シェル変数のみ） |

## 排他制御

排他制御は不要。環境変数の設定は冪等であり、複数回sourceされても問題ない。PYSPARK_PYTHONPATH_SETフラグにより、PYTHONPATHへの二重追加が防止される。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| なし | - | 本スクリプトはログ出力を行わない |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| 該当なし | - | 本スクリプトに監視・アラート機能は実装されていない |

## 備考

- 本スクリプトはshebangが設定されておらず、直接実行は想定されていない。ソースコードのコメントにも「should not be executable directly」と記載されている。
- 「also should not be passed any arguments, since we need original $*」とコメントに記載されており、引数なしでsourceされることが前提。
- PYTHONPATH設定では py4j-0.10.9.9-src.zip が固定パスで追加される。py4jのバージョンアップ時には本スクリプトの修正が必要。
- SPARK_CONF_DIRのデフォルト設定は `${SPARK_CONF_DIR:-"${SPARK_HOME}/conf"}` のBashパラメータ展開で行われ、既に設定されている場合は上書きされない。
- ソースファイルパス: `sbin/spark-config.sh`
