# バッチ設計書 2-stop-all.sh

## 概要

本ドキュメントは、Apache Sparkの全デーモン（Worker + Master）を一括停止するシェルスクリプト `stop-all.sh` のバッチ設計書である。

### 本バッチの処理概要

`stop-all.sh` は、Sparkクラスタを構成するすべてのデーモンプロセスを一括で停止するためのオーケストレーションスクリプトである。Workerデーモンを先に停止し、その後にMasterデーモンを停止する。`--wait` オプションを指定することで、全Workerの完全停止を待機できる。

**業務上の目的・背景**：Sparkクラスタのメンテナンスや障害対応において、全デーモンを安全に一括停止する必要がある。Workerを先に停止してからMasterを停止するという正しい順序を保証することで、データロスや処理中断による不整合を最小限に抑える。本バッチは `start-all.sh` と対になる停止用スクリプトである。

**バッチの実行タイミング**：手動実行。クラスタの計画停止、メンテナンス前、障害対応時など、運用者が任意のタイミングで実行する。

**主要な処理内容**：
1. SPARK_HOMEが未設定の場合、スクリプトの配置ディレクトリから自動検出し設定する
2. `spark-config.sh` をsourceしてSpark共通設定を初期化する
3. `stop-workers.sh` を呼び出して全ノードのWorkerデーモンを停止する
4. `stop-master.sh` を呼び出してMasterデーモンを停止する
5. `--wait` オプション指定時は、全Workerプロセスの終了を10秒間隔でポーリングして待機する

**前後の処理との関連**：`start-all.sh`（No.1）で起動されたクラスタを停止するために使用する。内部的に `stop-workers.sh`（No.8）と `stop-master.sh`（No.4）を順次呼び出す。停止順序はWorker -> Master（起動順序の逆）である。

**影響範囲**：Sparkクラスタ全体。稼働中のMasterデーモンおよび全Workerデーモンが停止される。実行中のSparkジョブがある場合は中断される。

## バッチ種別

デーモン管理（クラスタ一括停止）

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 随時 |
| 実行時刻 | 任意 |
| 実行曜日 | 該当なし |
| 実行日 | 該当なし |
| トリガー | 手動 |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| SPARK_HOME | SPARK_HOMEが設定済み、または本スクリプトの配置場所から自動検出可能であること |
| ネットワーク接続 | Masterノードから各Workerノードへの SSH 接続が可能であること |
| クラスタ起動済み | MasterおよびWorkerデーモンが起動していること（未起動でもエラーにはならない） |

### 実行可否判定

特段の判定ロジックはなし。対象デーモンが起動していない場合、各停止スクリプトが "no {command} to stop" メッセージを出力するのみで、エラーにはならない。

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| --wait | フラグ | No | なし | 全Workerの停止完了を待機する。指定時は10秒間隔でポーリング |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| conf/workers | テキストファイル | Workerノードのホスト名一覧（stop-workers.sh経由で参照） |
| PIDファイル | テキスト | 各デーモンのプロセスIDファイル（SPARK_PID_DIR配下） |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| 標準出力 | テキスト | 停止メッセージおよび --wait 時の待機状態表示 |

### 出力ファイル仕様

| 項目 | 内容 |
|-----|------|
| ファイル名 | PIDファイルが削除される（spark-{SPARK_IDENT_STRING}-{クラス名}-{インスタンス番号}.pid） |
| 出力先 | ${SPARK_PID_DIR}（デフォルト: /tmp） |
| 文字コード | 該当なし |
| 区切り文字 | 該当なし |

## 処理フロー

### 処理シーケンス

```
1. SPARK_HOME検出・設定
   └─ 環境変数が未設定の場合、スクリプト配置ディレクトリの親ディレクトリを設定
2. Spark設定読み込み
   └─ spark-config.shをsourceしてSPARK_CONF_DIR等を設定
3. Workers停止
   └─ stop-workers.shを実行（workers.sh経由でSSHリモート実行）
4. Master停止
   └─ stop-master.shを実行（spark-daemon.sh経由でプロセスをkill）
5. --wait指定時: Worker停止待機
   └─ workers.shでps -efを実行し、deploy.worker.Workerプロセスが存在しなくなるまで10秒間隔でポーリング
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B[SPARK_HOME設定]
    B --> C[spark-config.sh読み込み]
    C --> D[stop-workers.sh実行]
    D --> E[stop-master.sh実行]
    E --> F{--waitオプション?}
    F -->|あり| G[Worker停止ポーリング]
    G --> H{全Worker停止?}
    H -->|いいえ| I[10秒待機]
    I --> G
    H -->|はい| J[完了メッセージ出力]
    J --> K[バッチ終了]
    F -->|なし| K
```

## データベース操作仕様

### 操作別データベース影響一覧

本バッチはデータベース操作を行わない。

### テーブル別操作詳細

該当なし

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | 停止対象なし | デーモンが起動していない | "no {command} to stop" メッセージが出力されるのみ。正常系として扱われる |
| - | SSH接続失敗 | Workerノードへの接続不可 | SSH設定・ネットワーク接続を確認 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | なし（--wait時は無限ループで待機） |
| リトライ間隔 | --wait時: 10秒間隔 |
| リトライ対象エラー | 該当なし |

### 障害時対応

1. 停止できないプロセスがある場合、PIDファイルを確認して手動でkillする
2. `--wait` で停止待機中にタイムアウトしたい場合はCtrl+Cで中断する
3. PIDファイルが残っているがプロセスが存在しない場合、PIDファイルを手動削除する

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | 該当なし（プロセス停止のため） |
| コミットタイミング | 該当なし |
| ロールバック条件 | 該当なし |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 1 Master + N Workers |
| 目標処理時間 | 数秒〜数分（--wait使用時はWorker停止までの時間に依存） |
| メモリ使用量上限 | シェルスクリプト自体は最小限 |

## 排他制御

spark-daemon.sh がPIDファイルを用いた排他制御を行う。停止処理はPIDファイルからプロセスIDを読み取り、killシグナルを送信後にPIDファイルを削除する。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 停止ログ | 各デーモン停止時 | "stopping {クラス名}" |
| 不在ログ | デーモン未起動時 | "no {クラス名} to stop" |
| 待機ログ | --wait指定時 | "Waiting for workers to shut down..." + ドット表示 |
| 完了ログ | 全Worker停止時 | "All workers successfully shut down." |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| 停止完了確認 | 全プロセス停止 | 運用者（手動確認） |
| --wait待機時間 | 長時間待機（運用者判断） | 運用者（手動確認） |

## 備考

- 停止順序は Worker -> Master であり、起動順序（Master -> Worker）の逆となる
- `--wait` オプション使用時は無限ループのため、タイムアウトは設けられていない。長時間応答がない場合は手動介入が必要
- デーモンが起動していない状態で実行してもエラーにはならず安全である
