# バッチ設計書 21-spark-class

## 概要

本ドキュメントは、Sparkの任意のJavaクラスを実行するクライアントスクリプト `bin/spark-class` の設計を記述する。本スクリプトはSparkの内部基盤として、他のすべてのbinスクリプト（spark-submit、beeline、spark-pipelines等）から呼び出される中核的なランチャーである。

### 本バッチの処理概要

spark-classは、指定されたJavaクラスをSparkのクラスパス環境下で実行するための汎用ランチャースクリプトである。Sparkのランチャーライブラリ（org.apache.spark.launcher.Main）を介してJavaプロセスの起動コマンドを構築し、最終的にexecでJavaプロセスに置き換える。

**業務上の目的・背景**：Sparkエコシステムでは、様々なJavaクラス（SparkSubmit、BeeLine、SparkPipelines等）を統一的な方法で起動する必要がある。spark-classは、JAVA_HOMEの検出、クラスパスの構築、ランチャーライブラリを通じたコマンド組み立てといった共通処理を一元化することで、各スクリプトが個別にJava起動ロジックを実装する必要をなくしている。

**バッチの実行タイミング**：手動実行または他のSparkスクリプト（spark-submit、beeline等）から呼び出される都度実行。

**主要な処理内容**：
1. SPARK_HOMEの検出とspark-env.shの読み込み
2. Javaバイナリ（RUNNER）の検出（JAVA_HOME優先、なければPATH上のjava）
3. Spark JARディレクトリの特定とクラスパス（LAUNCH_CLASSPATH）の構築
4. ランチャーライブラリ（org.apache.spark.launcher.Main）を実行し、最終的なJavaコマンドを組み立て
5. ランチャーの出力をNULL区切りで解析し、コマンド配列を構築
6. ランチャーの終了コードを検証し、成功時はexecで最終コマンドを実行

**前後の処理との関連**：spark-classは、find-spark-homeとload-spark-env.shを前提として呼び出す。spark-submit、beeline、spark-pipelinesなどの上位スクリプトから呼び出される中間レイヤーとして機能する。

**影響範囲**：Sparkのすべてのクライアント実行スクリプトに影響する。本スクリプトの変更は、spark-submit、beeline、spark-pipelines等の動作に直接影響を与える。

## バッチ種別

クライアント実行（汎用Javaクラスランチャー）

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 随時 |
| 実行時刻 | 任意 |
| 実行曜日 | 該当なし |
| 実行日 | 該当なし |
| トリガー | 手動 / 他スクリプトからの呼び出し |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| JAVA_HOMEまたはjavaコマンド | Javaランタイムが利用可能であること |
| Spark JARディレクトリ | `${SPARK_HOME}/jars` または `${SPARK_HOME}/assembly/target/scala-$SPARK_SCALA_VERSION/jars` が存在すること（テスト時を除く） |
| SPARK_HOME | 設定済み、またはfind-spark-homeで検出可能であること |

### 実行可否判定

1. JAVA_HOMEが設定されていない場合、PATHからjavaコマンドを検索する。javaが見つからない場合はエラー終了（exit 1）
2. Spark JARディレクトリが存在しない場合、SPARK_TESTINGまたはSPARK_SQL_TESTINGが設定されていなければエラー終了（exit 1）

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| クラス名 | String | Yes | なし | 実行するJavaクラスの完全修飾名 |
| クラス引数 | String[] | No | なし | 実行するクラスに渡す引数 |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| find-spark-home | シェルスクリプト | SPARK_HOMEの検出 |
| load-spark-env.sh | シェルスクリプト | spark-env.sh設定の読み込み |
| ${SPARK_HOME}/jars/ | JARファイル群 | Sparkのクラスパスを構成するJARファイル |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| 標準出力 | テキスト | ランチャーからの情報メッセージ |
| 標準エラー出力 | テキスト | エラーメッセージ |
| Javaプロセス | プロセス | execで置き換えられた最終的なJavaプロセス |

### 出力ファイル仕様

本スクリプトはファイル出力を行わない。実行結果は指定されたJavaクラスの実行に依存する。

## 処理フロー

### 処理シーケンス

```
1. SPARK_HOME検出
   └─ SPARK_HOMEが未設定の場合、find-spark-homeをsourceして設定
2. spark-env.sh読み込み
   └─ load-spark-env.shをsourceしてSpark環境変数を設定
3. Javaバイナリ検出
   └─ JAVA_HOME → PATHの優先順で検索。見つからなければエラー終了
4. Spark JARディレクトリ特定
   └─ ${SPARK_HOME}/jars を優先、なければassembly配下を使用
5. クラスパス構築
   └─ LAUNCH_CLASSPATHにJARディレクトリの全JARを設定
   └─ SPARK_PREPEND_CLASSESが設定されている場合、launcher/target配下を先頭に追加
6. テスト環境設定
   └─ SPARK_TESTINGが設定されている場合、YARN_CONF_DIRとHADOOP_CONF_DIRを解除
7. ランチャー実行（build_command関数）
   └─ org.apache.spark.launcher.Mainを-Xmx128mで実行し、起動コマンドを生成
8. コマンド解析
   └─ ランチャー出力をNULL文字区切りで解析し、コマンド配列を構築
9. 終了コード検証
   └─ ランチャーの終了コードを検証。整数でない場合やゼロ以外はエラー終了
10. 最終コマンド実行
    └─ execで構築されたJavaコマンドを実行（プロセス置換）
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B[SPARK_HOME検出]
    B --> C[load-spark-env.sh読み込み]
    C --> D{JAVA_HOME設定済み?}
    D -->|Yes| E[RUNNER=JAVA_HOME/bin/java]
    D -->|No| F{javaコマンド存在?}
    F -->|Yes| G[RUNNER=java]
    F -->|No| H[エラー終了 exit 1]
    E --> I{SPARK_HOME/jars存在?}
    G --> I
    I -->|Yes| J[SPARK_JARS_DIR=jars]
    I -->|No| K[SPARK_JARS_DIR=assembly/target配下]
    J --> L{JARディレクトリ存在?}
    K --> L
    L -->|No, テスト以外| M[エラー終了 exit 1]
    L -->|Yes or テスト| N[LAUNCH_CLASSPATH構築]
    N --> O[build_command: ランチャー実行]
    O --> P[コマンド配列解析]
    P --> Q{終了コード正常?}
    Q -->|No| R[エラー終了]
    Q -->|Yes| S[exec 最終コマンド]
    S --> T[バッチ終了]
```

## データベース操作仕様

### 操作別データベース影響一覧

本スクリプトはデータベース操作を行わない。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| 1 | 環境エラー | JAVA_HOMEが未設定かつjavaコマンドが見つからない | JAVA_HOMEを設定するかjavaをPATHに追加 |
| 1 | 環境エラー | Spark JARディレクトリが見つからない（テスト以外） | `mvn package` でSparkをビルド |
| 1 | ランチャーエラー | ランチャーの出力が不正（終了コードが整数でない） | JVMの問題を調査（メモリ不足等） |
| 非ゼロ | ランチャーエラー | ランチャーが非ゼロの終了コードを返した | ランチャーのエラーメッセージを確認 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | なし（リトライ機構なし） |
| リトライ間隔 | 該当なし |
| リトライ対象エラー | 該当なし |

### 障害時対応

1. JAVA_HOME関連エラー：Javaのインストール状態とJAVA_HOME環境変数を確認する
2. JARディレクトリ関連エラー：Sparkのビルド状態を確認し、必要に応じて `mvn package` を実行する
3. ランチャーエラー：標準エラー出力のメッセージを確認し、クラスパスやメモリ設定を見直す

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | 該当なし（データベーストランザクションなし） |
| コミットタイミング | 該当なし |
| ロールバック条件 | 該当なし |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 1回の実行で1つのJavaクラスを起動 |
| 目標処理時間 | ランチャー自体は数秒以内。実行されるクラスに依存 |
| メモリ使用量上限 | ランチャーJVM: 128MB（-Xmx128m）。最終プロセスは別途設定 |

## 排他制御

排他制御なし。複数インスタンスの同時実行が可能。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 情報メッセージ | ランチャー実行時 | ランチャーからの出力メッセージ（標準出力） |
| エラーログ | エラー発生時 | JAVA_HOME未設定、JARディレクトリ未検出等のエラーメッセージ（標準エラー出力） |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| 終了コード | 非ゼロ | 呼び出し元スクリプトに伝播 |

## 備考

- SPARK_PREPEND_CLASSESを設定すると、launcher/target配下のクラスファイルがクラスパスの先頭に追加される（開発・デバッグ用）
- SPARK_LAUNCHER_OPTS環境変数でランチャーJVMにオプションを渡すことが可能
- ランチャーの出力はNULL文字区切りで解析されるため、引数にシェルが解釈する特殊文字を含むことが可能
- SPARK_TESTINGまたはSPARK_SQL_TESTINGが設定されている場合、JARディレクトリの存在チェックがスキップされる
- posixモードを無効化してプロセス置換（process substitution）を使用している
