# バッチ設計書 22-spark-shell

## 概要

本ドキュメントは、Spark Scala REPL（対話シェル）を起動するクライアントスクリプト `bin/spark-shell` の設計を記述する。本スクリプトはspark-submitを経由してorg.apache.spark.repl.Mainクラスを起動し、ユーザーにScalaベースのSparkインタラクティブ環境を提供する。

### 本バッチの処理概要

spark-shellは、Spark上でScalaコードをインタラクティブに実行するためのREPL（Read-Eval-Print Loop）環境を起動するスクリプトである。内部的にはspark-submitコマンドを利用してorg.apache.spark.repl.Mainクラスを起動する。Cygwin環境への対応やターミナル設定の保存・復元といったプラットフォーム固有の処理も含む。

**業務上の目的・背景**：データエンジニアやデータサイエンティストが、Sparkクラスタに接続した状態でScalaコードをインタラクティブに実行し、データの探索・分析・プロトタイピングを行うための環境を提供する。バッチジョブの開発前にロジックを試行錯誤する際に頻繁に使用される。

**バッチの実行タイミング**：ユーザーが対話的なSpark Scala環境を必要とする際に手動で実行する。

**主要な処理内容**：
1. SPARK_HOMEの検出（find-spark-home）
2. SPARK_SUBMIT_OPTSに `-Dscala.usejavacp=true` フラグを追加
3. Cygwin環境の検出と対応（JLineターミナル設定）
4. ターミナル設定（stty）の保存
5. spark-submitコマンドで org.apache.spark.repl.Main を起動
6. ターミナル設定の復元（終了時・割り込み時）

**前後の処理との関連**：find-spark-homeによるSPARK_HOME検出が前提。内部でspark-submitを呼び出し、spark-submitはさらにspark-classを呼び出す。Spark Connectモードの場合、SparkSubmitCommandBuilderでメインクラスが置き換えられる。

**影響範囲**：ローカルのターミナル環境（stty設定）に一時的に影響を与える。spark-submitを介してSparkクラスタに接続する。

## バッチ種別

クライアント実行（対話型REPL起動）

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 随時 |
| 実行時刻 | 任意 |
| 実行曜日 | 該当なし |
| 実行日 | 該当なし |
| トリガー | 手動 |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| SPARK_HOME | 設定済み、またはfind-spark-homeで検出可能であること |
| Javaランタイム | spark-submit経由でJavaが実行可能であること |
| ターミナル環境 | sttyコマンドが利用可能であること（オプション） |

### 実行可否判定

SPARK_HOMEが検出できれば実行可能。spark-submitの実行条件（Java、クラスパス等）に従う。

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| options | String[] | No | なし | spark-submitに渡すオプション（--master, --deploy-mode等） |
| -I \<file\> | String | No | なし | 事前読み込みファイル（Spark Classic限定。行ごとに解釈） |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| find-spark-home | シェルスクリプト | SPARK_HOMEの検出 |
| spark-submit | シェルスクリプト | アプリケーション投入の基盤 |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| 標準出力 | テキスト | Scala REPLのプロンプトと実行結果 |
| 標準エラー出力 | テキスト | エラーメッセージ・ログ |

### 出力ファイル仕様

本スクリプトはファイル出力を行わない。対話シェルの出力はユーザーの操作に依存する。

## 処理フロー

### 処理シーケンス

```
1. Cygwin環境検出
   └─ uname結果がCYGWIN*にマッチするか判定
2. POSIXモード有効化
   └─ set -o posixでPOSIXモードを設定
3. SPARK_HOME検出
   └─ SPARK_HOMEが未設定の場合、find-spark-homeをsource
4. 使用方法メッセージ設定
   └─ _SPARK_CMD_USAGEをexport
5. SPARK_SUBMIT_OPTSにScala CPフラグ追加
   └─ -Dscala.usejavacp=trueを追加（Scala REPLのクラスローダー対応）
6. ターミナル設定保存
   └─ stty -gで現在のターミナル設定を保存
7. 割り込みトラップ設定
   └─ trap onExit INTでSIGINT時のクリーンアップを設定
8. main関数実行
   └─ SPARK_SCALA_SHELL=1をexport
   └─ Cygwin環境: stty設定変更 → spark-submit実行 → stty復元
   └─ 通常環境: spark-submit --class org.apache.spark.repl.Main --name "Spark shell"を実行
9. 終了処理
   └─ 終了コードを記録し、ターミナル設定を復元してexit
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B[Cygwin環境検出]
    B --> C[POSIXモード有効化]
    C --> D[SPARK_HOME検出]
    D --> E[SPARK_SUBMIT_OPTS設定]
    E --> F[ターミナル設定保存 stty -g]
    F --> G[割り込みトラップ設定]
    G --> H{Cygwin環境?}
    H -->|Yes| I[stty -icanon min 1 -echo]
    H -->|No| J[SPARK_SUBMIT_OPTSをexport]
    I --> K[spark-submit --class org.apache.spark.repl.Main]
    J --> K
    K --> L[終了コード記録]
    L --> M[ターミナル設定復元]
    M --> N[バッチ終了]
```

## データベース操作仕様

### 操作別データベース影響一覧

本スクリプトはデータベース操作を行わない。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| 127 | 初期値 | スクリプトの初期終了コード | 正常にspark-submitが完了すれば上書きされる |
| 非ゼロ | spark-submitエラー | spark-submitの実行に失敗した場合 | spark-submitのエラーメッセージを確認 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | なし（対話型のためリトライ機構なし） |
| リトライ間隔 | 該当なし |
| リトライ対象エラー | 該当なし |

### 障害時対応

1. ターミナルが壊れた場合：`stty sane` コマンドで復元する
2. spark-submitエラー：Java環境やクラスパスの設定を確認する
3. Cygwin環境での問題：JLineのバグに起因する可能性があるため、Minttyの設定を確認する

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | 該当なし |
| コミットタイミング | 該当なし |
| ロールバック条件 | 該当なし |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 対話型のため該当なし |
| 目標処理時間 | 起動時間は数秒〜十数秒。セッション時間はユーザー操作に依存 |
| メモリ使用量上限 | spark-submitのデフォルト設定に依存 |

## 排他制御

排他制御なし。複数のspark-shellインスタンスを同時に実行可能。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| Sparkログ | セッション中 | Sparkフレームワークのログ（spark-submitのログ設定に準拠） |
| REPLログ | コマンド実行時 | ユーザーの入力と実行結果 |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| 終了コード | 非ゼロ | 呼び出し元に伝播 |

## 備考

- SPARK_SCALA_SHELL=1環境変数がexportされ、SparkSubmitCommandBuilderでSpark Connect対応のクラス置換が行われる可能性がある
- Cygwin環境では、JLineとの互換性問題を回避するためにターミナル設定を一時的に変更する
- `-Dscala.usejavacp=true` はSPARK-4161で導入されたフラグで、Scala REPLが独自のクラスローダーを持つために必要
- 割り込み（Ctrl+C）時にもターミナル設定が復元されるようtrapが設定されている
