# バッチ設計書 23-spark-sql

## 概要

本ドキュメントは、Spark SQL CLI（コマンドラインインタフェース）を起動するクライアントスクリプト `bin/spark-sql` の設計を記述する。本スクリプトはspark-submitを経由してorg.apache.spark.sql.hive.thriftserver.SparkSQLCLIDriverクラスを起動し、対話的なSQLクエリ実行環境を提供する。

### 本バッチの処理概要

spark-sqlは、Spark上でSQLクエリをインタラクティブに実行するためのCLI環境を起動するスクリプトである。Hive互換のSQL構文をサポートし、SparkのSQLエンジンを通じてデータの検索・操作を行うことができる。スクリプト自体は非常にシンプルで、spark-submitにクラス名を指定してexecで実行する。

**業務上の目的・背景**：データアナリストやデータベース管理者が、Sparkクラスタ上でSQLクエリを対話的に実行するためのツールを提供する。Hive互換のSQLインタフェースにより、従来のHive CLIユーザーがSparkに移行する際の学習コストを低減する。

**バッチの実行タイミング**：ユーザーがSQLクエリを対話的に実行する際に手動で実行する。

**主要な処理内容**：
1. SPARK_CONNECT_MODE=0をexport（Spark Connectモードを無効化）
2. SPARK_HOMEの検出（find-spark-home）
3. 使用方法メッセージ（_SPARK_CMD_USAGE）の設定
4. spark-submitコマンドでSparkSQLCLIDriverを起動

**前後の処理との関連**：find-spark-homeによるSPARK_HOME検出が前提。内部でspark-submitを呼び出し、spark-submitはspark-classを経由してJavaプロセスを起動する。Thrift JDBC/ODBCサーバー（start-thriftserver.sh）と同じドライバクラスパッケージに属する。

**影響範囲**：Sparkクラスタに接続してSQLクエリを実行する。Hiveメタストアにアクセスする可能性がある。

## バッチ種別

クライアント実行（対話型SQL CLI起動）

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 随時 |
| 実行時刻 | 任意 |
| 実行曜日 | 該当なし |
| 実行日 | 該当なし |
| トリガー | 手動 |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| SPARK_HOME | 設定済み、またはfind-spark-homeで検出可能であること |
| Javaランタイム | spark-submit経由でJavaが実行可能であること |
| Hive対応ビルド | SparkSQLCLIDriverクラスが利用可能であること |

### 実行可否判定

SPARK_HOMEが検出できれば実行可能。spark-submitの実行条件に従う。SparkSQLCLIDriverクラスが存在しない場合はクラスパスエラーとなる。

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| options | String[] | No | なし | spark-submitに渡すオプション |
| cli option | String[] | No | なし | SparkSQLCLIDriverに渡すCLIオプション |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| find-spark-home | シェルスクリプト | SPARK_HOMEの検出 |
| spark-submit | シェルスクリプト | アプリケーション投入の基盤 |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| 標準出力 | テキスト | SQLクエリの実行結果 |
| 標準エラー出力 | テキスト | エラーメッセージ・ログ |

### 出力ファイル仕様

本スクリプトはファイル出力を行わない。SQLクエリの結果は標準出力に表示される。

## 処理フロー

### 処理シーケンス

```
1. SPARK_CONNECT_MODE設定
   └─ SPARK_CONNECT_MODE=0をexport（Spark Connectモードを無効化）
2. SPARK_HOME検出
   └─ SPARK_HOMEが未設定の場合、find-spark-homeをsource
3. 使用方法メッセージ設定
   └─ _SPARK_CMD_USAGEをexport
4. spark-submit実行
   └─ exec spark-submit --class org.apache.spark.sql.hive.thriftserver.SparkSQLCLIDriver でプロセスを置換
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B[SPARK_CONNECT_MODE=0 設定]
    B --> C{SPARK_HOME設定済み?}
    C -->|No| D[find-spark-home実行]
    C -->|Yes| E[_SPARK_CMD_USAGE設定]
    D --> E
    E --> F[exec spark-submit --class SparkSQLCLIDriver]
    F --> G[バッチ終了]
```

## データベース操作仕様

### 操作別データベース影響一覧

本スクリプト自体はデータベース操作を行わない。起動されるSparkSQLCLIDriverを通じてユーザーがSQL操作を行う。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| 非ゼロ | spark-submitエラー | spark-submitの実行に失敗した場合 | Java環境やクラスパスを確認 |
| 非ゼロ | クラスパスエラー | SparkSQLCLIDriverクラスが見つからない場合 | Hive対応のSparkビルドを使用する |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | なし（対話型のためリトライ機構なし） |
| リトライ間隔 | 該当なし |
| リトライ対象エラー | 該当なし |

### 障害時対応

1. クラスが見つからない場合：Sparkのビルドにhive-thriftserverが含まれているか確認する
2. spark-submitエラー：Java環境やクラスパスの設定を確認する

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | 該当なし（スクリプト自体はトランザクション管理を行わない） |
| コミットタイミング | 該当なし |
| ロールバック条件 | 該当なし |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 対話型のため該当なし |
| 目標処理時間 | 起動時間は数秒〜十数秒。クエリ実行時間はクエリ内容に依存 |
| メモリ使用量上限 | spark-submitのデフォルト設定に依存 |

## 排他制御

排他制御なし。複数のspark-sqlインスタンスを同時に実行可能。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| Sparkログ | セッション中 | Sparkフレームワークのログ（spark-submitのログ設定に準拠） |
| クエリ結果 | SQLクエリ実行時 | クエリの実行結果 |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| 終了コード | 非ゼロ | 呼び出し元に伝播 |

## 備考

- SPARK_CONNECT_MODE=0を明示的に設定しており、Spark Connectモードは無効化される
- execでspark-submitを実行するため、プロセスが置換される（呼び出し元のシェルプロセスはなくなる）
- SparkSQLCLIDriverはHive Thrift Serverパッケージに含まれるため、Hive対応のSparkビルドが必要
- spark-shellとは異なり、ターミナル設定の保存・復元処理は含まれていない
