# バッチ設計書 25-sparkR

## 概要

本ドキュメントは、SparkR対話シェルを起動するクライアントスクリプト `bin/sparkR` の設計を記述する。本スクリプトはspark-submitを経由してSparkR REPLを起動し、R言語によるSparkインタラクティブ環境を提供する。Spark 4.0.0以降では非推奨となっている。

### 本バッチの処理概要

sparkRは、R言語でSparkをインタラクティブに操作するための対話シェルを起動するスクリプトである。スクリプトは簡潔な構成で、spark-env.shの読み込みとspark-submitによるsparkr-shell-mainの起動を行う。Spark Connectモードは明示的に無効化される。

**業務上の目的・背景**：R言語を主要ツールとする統計学者やデータアナリストが、SparkクラスタのスケーラビリティをR環境から活用するためのインタフェースを提供する。ただしSpark 4.0.0以降では非推奨であり、PySparkへの移行が推奨される。

**バッチの実行タイミング**：ユーザーがR言語ベースのSpark対話環境を必要とする際に手動で実行する。

**主要な処理内容**：
1. SPARK_CONNECT_MODE=0をexport（Spark Connectモードを無効化）
2. SPARK_HOMEの検出（find-spark-home）
3. spark-env.shの読み込み（load-spark-env.sh）
4. spark-submitでsparkr-shell-mainを起動

**前後の処理との関連**：find-spark-homeおよびload-spark-env.shが前提。内部でspark-submitを呼び出す。

**影響範囲**：spark-submitを介してSparkクラスタに接続する。R実行環境に依存する。

## バッチ種別

クライアント実行（R言語対話型シェル起動）

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 随時 |
| 実行時刻 | 任意 |
| 実行曜日 | 該当なし |
| 実行日 | 該当なし |
| トリガー | 手動 |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| SPARK_HOME | 設定済み、またはfind-spark-homeで検出可能であること |
| R実行環境 | R言語ランタイムがインストールされていること |
| Javaランタイム | spark-submit経由でJavaが実行可能であること |

### 実行可否判定

SPARK_HOMEが検出できれば実行可能。spark-submitの実行条件に従う。

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| options | String[] | No | なし | spark-submitに渡すオプション |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| find-spark-home | シェルスクリプト | SPARK_HOMEの検出 |
| load-spark-env.sh | シェルスクリプト | Spark環境変数の読み込み |
| spark-submit | シェルスクリプト | アプリケーション投入の基盤 |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| 標準出力 | テキスト | R REPLのプロンプトと実行結果 |
| 標準エラー出力 | テキスト | エラーメッセージ・ログ |

### 出力ファイル仕様

本スクリプトはファイル出力を行わない。

## 処理フロー

### 処理シーケンス

```
1. SPARK_CONNECT_MODE設定
   └─ SPARK_CONNECT_MODE=0をexport（Spark Connectモードを無効化）
2. SPARK_HOME検出
   └─ SPARK_HOMEが未設定の場合、find-spark-homeをsource
3. spark-env.sh読み込み
   └─ load-spark-env.shをsource
4. 使用方法メッセージ設定
   └─ _SPARK_CMD_USAGEをexport
5. spark-submit実行
   └─ exec spark-submit sparkr-shell-main でプロセスを置換
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B[SPARK_CONNECT_MODE=0 設定]
    B --> C{SPARK_HOME設定済み?}
    C -->|No| D[find-spark-home実行]
    C -->|Yes| E[load-spark-env.sh読み込み]
    D --> E
    E --> F[_SPARK_CMD_USAGE設定]
    F --> G[exec spark-submit sparkr-shell-main]
    G --> H[バッチ終了]
```

## データベース操作仕様

### 操作別データベース影響一覧

本スクリプト自体はデータベース操作を行わない。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| 非ゼロ | spark-submitエラー | spark-submitの実行に失敗した場合 | Java環境やクラスパスを確認 |
| 非ゼロ | R環境エラー | R実行環境が見つからない場合 | Rをインストールする |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | なし（対話型のためリトライ機構なし） |
| リトライ間隔 | 該当なし |
| リトライ対象エラー | 該当なし |

### 障害時対応

1. spark-submitエラー：Java環境やクラスパスの設定を確認する
2. R環境エラー：Rのインストール状態を確認する

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | 該当なし |
| コミットタイミング | 該当なし |
| ロールバック条件 | 該当なし |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 対話型のため該当なし |
| 目標処理時間 | 起動時間は数秒〜十数秒 |
| メモリ使用量上限 | spark-submitのデフォルト設定に依存 |

## 排他制御

排他制御なし。複数のsparkRインスタンスを同時に実行可能。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| Sparkログ | セッション中 | Sparkフレームワークのログ |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| 終了コード | 非ゼロ | 呼び出し元に伝播 |

## 備考

- Spark 4.0.0以降で非推奨（deprecated）となっている。PySparkへの移行が推奨される
- SPARK_CONNECT_MODE=0を明示的に設定しており、Spark Connectモードは無効化される
- execでspark-submitを実行するため、プロセスが置換される
- spark-sqlと同様にspark-env.shの読み込みを明示的に行っている（load-spark-env.shをsource）
