# バッチ設計書 26-beeline

## 概要

本ドキュメントは、Beeline SQLクライアントを起動するクライアントスクリプト `bin/beeline` の設計を記述する。本スクリプトはspark-classを経由してorg.apache.hive.beeline.BeeLineクラスを起動し、JDBC/ODBCベースのSQLクライアント環境を提供する。

### 本バッチの処理概要

beelineは、HiveのBeeLineクライアントをSparkの環境下で起動するスクリプトである。BeeLineはJDBC接続を通じてThrift Serverに接続し、SQLクエリを実行するためのクライアントツールである。spark-sqlとは異なり、spark-classを直接使用してJavaクラスを起動する。

**業務上の目的・背景**：Spark SQL Thrift JDBC/ODBCサーバーやHiveServerに対して、JDBC接続でSQLクエリを実行するためのクライアントツールを提供する。リモートのThrift Serverに対して接続でき、サーバー・クライアント分離型のアーキテクチャで使用される。

**バッチの実行タイミング**：ユーザーがJDBC経由でSQLクエリを実行する際に手動で実行する。

**主要な処理内容**：
1. POSIXモードの有効化
2. SPARK_HOMEの検出（find-spark-home）
3. spark-classコマンドでorg.apache.hive.beeline.BeeLineを起動

**前後の処理との関連**：find-spark-homeによるSPARK_HOME検出が前提。spark-classを直接呼び出す（spark-submitは使用しない）。Thrift Server（start-thriftserver.sh）が稼働していることを前提とする場合がある。

**影響範囲**：JDBC接続を通じてThrift ServerやHiveServerに接続する。

## バッチ種別

クライアント実行（JDBC SQLクライアント起動）

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 随時 |
| 実行時刻 | 任意 |
| 実行曜日 | 該当なし |
| 実行日 | 該当なし |
| トリガー | 手動 |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| SPARK_HOME | 設定済み、またはfind-spark-homeで検出可能であること |
| Javaランタイム | spark-class経由でJavaが実行可能であること |
| BeeLineクラス | org.apache.hive.beeline.BeeLineがクラスパスに存在すること |

### 実行可否判定

SPARK_HOMEが検出できれば実行可能。spark-classの実行条件（Java、クラスパス等）に従う。

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| BeeLineオプション | String[] | No | なし | BeeLineクライアントに渡すオプション（-u JDBC_URL, -n username等） |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| find-spark-home | シェルスクリプト | SPARK_HOMEの検出 |
| spark-class | シェルスクリプト | Javaクラスランチャー |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| 標準出力 | テキスト | SQLクエリの実行結果 |
| 標準エラー出力 | テキスト | エラーメッセージ・ログ |

### 出力ファイル仕様

本スクリプトはファイル出力を行わない。

## 処理フロー

### 処理シーケンス

```
1. POSIXモード有効化
   └─ set -o posixでPOSIXモードを設定
2. SPARK_HOME検出
   └─ SPARK_HOMEが未設定の場合、find-spark-homeをsource
3. クラス名設定
   └─ CLASS="org.apache.hive.beeline.BeeLine"を設定
4. spark-class実行
   └─ exec spark-class $CLASS でプロセスを置換
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B[POSIXモード有効化]
    B --> C{SPARK_HOME設定済み?}
    C -->|No| D[find-spark-home実行]
    C -->|Yes| E[CLASS=org.apache.hive.beeline.BeeLine]
    D --> E
    E --> F[exec spark-class BeeLine]
    F --> G[バッチ終了]
```

## データベース操作仕様

### 操作別データベース影響一覧

本スクリプト自体はデータベース操作を行わない。起動されるBeeLineクライアントを通じてユーザーがJDBC経由でSQL操作を行う。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| 非ゼロ | spark-classエラー | spark-classの実行に失敗した場合 | Java環境やクラスパスを確認 |
| 非ゼロ | クラスパスエラー | BeeLineクラスが見つからない場合 | Hive対応のSparkビルドを使用する |
| 非ゼロ | JDBC接続エラー | Thrift Serverに接続できない場合 | Thrift Serverの稼働状態と接続URLを確認 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | なし（対話型のためリトライ機構なし） |
| リトライ間隔 | 該当なし |
| リトライ対象エラー | 該当なし |

### 障害時対応

1. spark-classエラー：Java環境やクラスパスの設定を確認する
2. JDBC接続エラー：Thrift Serverの稼働状態と接続URLを確認する

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | 該当なし（スクリプト自体はトランザクション管理を行わない） |
| コミットタイミング | 該当なし |
| ロールバック条件 | 該当なし |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 対話型のため該当なし |
| 目標処理時間 | 起動時間は数秒以内 |
| メモリ使用量上限 | spark-classのデフォルト設定に依存 |

## 排他制御

排他制御なし。複数のbeelineインスタンスを同時に実行可能。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| BeeLineログ | セッション中 | JDBC接続情報とクエリ実行結果 |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| 終了コード | 非ゼロ | 呼び出し元に伝播 |

## 備考

- spark-sqlとは異なり、spark-submitではなくspark-classを直接使用してBeeLineクラスを起動する
- BeeLineはJDBC接続でサーバーに接続するクライアントであり、Thrift Serverが別途稼働している必要がある（リモート接続の場合）
- load-spark-env.sh内でSPARK_BEELINE_OPTSが設定される場合がある（バックグラウンド実行時のjline.terminal設定）
- POSIXモードが有効化されているため、一部のbash拡張機能は使用できない
- 起動クラスはorg.apache.hive.beeline.BeeLineで、Hiveプロジェクト由来のクラスである
