# バッチ設計書 27-spark-connect-shell

## 概要

本ドキュメントは、Spark Connect対応のScala REPLを起動するクライアントスクリプト `bin/spark-connect-shell` の設計を記述する。本スクリプトはspark-shellにSparkConnectPluginの設定を付加して起動するラッパーである。

### 本バッチの処理概要

spark-connect-shellは、Spark Connectプロトコルを有効にしたScala REPL（対話シェル）を起動するスクリプトである。内部的にはspark-shellを呼び出し、`--conf spark.plugins=org.apache.spark.sql.connect.SparkConnectPlugin` を自動的に付加する。これにより、Spark Connectサーバーへの接続を可能にする。

**業務上の目的・背景**：Spark Connectアーキテクチャを利用して、リモートのSparkクラスタにクライアントから接続するためのScala REPL環境を提供する。Spark Connectにより、クライアントとサーバーが分離され、クライアント側の依存関係が軽量化される。

**バッチの実行タイミング**：ユーザーがSpark Connect対応のScala対話環境を必要とする際に手動で実行する。

**主要な処理内容**：
1. SPARK_HOMEの検出（find-spark-home）
2. spark-shellにSparkConnectPlugin設定を付加して起動

**前後の処理との関連**：find-spark-homeが前提。内部でspark-shellを呼び出し、spark-shellはさらにspark-submitとspark-classを呼び出す。Spark Connectサーバー（start-connect-server.sh）が稼働していることが前提。

**影響範囲**：spark-shellの動作にSparkConnectPluginの設定が追加される。Spark Connectサーバーに接続する。

## バッチ種別

クライアント実行（Spark Connect対応対話型REPL起動）

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 随時 |
| 実行時刻 | 任意 |
| 実行曜日 | 該当なし |
| 実行日 | 該当なし |
| トリガー | 手動 |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| SPARK_HOME | 設定済み、またはfind-spark-homeで検出可能であること |
| Javaランタイム | spark-shell経由でJavaが実行可能であること |
| Spark Connectサーバー | 接続先のSpark Connectサーバーが稼働していること（リモート接続の場合） |

### 実行可否判定

SPARK_HOMEが検出できれば実行可能。spark-shellの実行条件に従う。

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| options | String[] | No | なし | spark-shellに渡す追加オプション |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| find-spark-home | シェルスクリプト | SPARK_HOMEの検出 |
| spark-shell | シェルスクリプト | Scala REPL起動スクリプト |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| 標準出力 | テキスト | Scala REPLのプロンプトと実行結果 |
| 標準エラー出力 | テキスト | エラーメッセージ・ログ |

### 出力ファイル仕様

本スクリプトはファイル出力を行わない。

## 処理フロー

### 処理シーケンス

```
1. SPARK_HOME検出
   └─ SPARK_HOMEが未設定の場合、find-spark-homeをsource
2. spark-shell実行
   └─ exec spark-shell --conf spark.plugins=org.apache.spark.sql.connect.SparkConnectPlugin でプロセスを置換
   └─ ユーザーの追加引数（$@）もspark-shellに渡される
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B{SPARK_HOME設定済み?}
    B -->|No| C[find-spark-home実行]
    B -->|Yes| D[exec spark-shell with SparkConnectPlugin]
    C --> D
    D --> E[バッチ終了]
```

## データベース操作仕様

### 操作別データベース影響一覧

本スクリプト自体はデータベース操作を行わない。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| 非ゼロ | spark-shellエラー | spark-shellの実行に失敗した場合 | spark-shellの実行条件を確認 |
| 非ゼロ | プラグインエラー | SparkConnectPluginが見つからない場合 | Spark Connectモジュールがビルドに含まれているか確認 |
| 非ゼロ | 接続エラー | Spark Connectサーバーに接続できない場合 | サーバーの稼働状態と接続設定を確認 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | なし（対話型のためリトライ機構なし） |
| リトライ間隔 | 該当なし |
| リトライ対象エラー | 該当なし |

### 障害時対応

1. spark-shellエラー：Java環境やクラスパスの設定を確認する
2. プラグインエラー：Spark Connectモジュールがビルドに含まれているか確認する
3. 接続エラー：Spark Connectサーバーの稼働状態を確認する

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | 該当なし |
| コミットタイミング | 該当なし |
| ロールバック条件 | 該当なし |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 対話型のため該当なし |
| 目標処理時間 | 起動時間は数秒〜十数秒 |
| メモリ使用量上限 | spark-shellのデフォルト設定に依存 |

## 排他制御

排他制御なし。複数のspark-connect-shellインスタンスを同時に実行可能。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| Sparkログ | セッション中 | Sparkフレームワークのログ（spark-shellのログ設定に準拠） |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| 終了コード | 非ゼロ | 呼び出し元に伝播 |

## 備考

- 本スクリプトはspark-shellの薄いラッパーであり、SparkConnectPluginを自動設定するだけである
- `--conf spark.plugins=org.apache.spark.sql.connect.SparkConnectPlugin` が自動付加される
- ユーザーの追加引数はSparkConnectPlugin設定の後に追加される
- spark-shell内でSPARK_SCALA_SHELL=1が設定され、SparkSubmitCommandBuilderによるクラス置換が行われる
- execでspark-shellを実行するため、プロセスが置換される
