# バッチ設計書 28-spark-pipelines

## 概要

本ドキュメントは、Spark Pipelinesを実行するクライアントスクリプト `bin/spark-pipelines` の設計を記述する。本スクリプトはPySpark PipelinesのCLIエントリポイントを特定し、spark-classを経由してorg.apache.spark.deploy.SparkPipelinesクラスを起動する。

### 本バッチの処理概要

spark-pipelinesは、Spark Pipelines（宣言的ETL/データパイプライン機能）を実行するためのクライアントスクリプトである。Pythonを使用してPySparkパッケージからCLIスクリプト（pipelines/cli.py）のパスを動的に特定し、そのパスをspark-classに引数として渡してSparkPipelinesクラスを起動する。

**業務上の目的・背景**：データエンジニアが宣言的にデータパイプラインを定義・実行するための統合的なインタフェースを提供する。Spark Pipelinesは、ETLワークフローの構築を簡素化し、パイプラインの定義・実行・監視を一つのコマンドで行えるようにする。

**バッチの実行タイミング**：ユーザーがSpark Pipelinesを実行する際に手動で実行する。

**主要な処理内容**：
1. Python実行環境の設定（PYSPARK_PYTHONのデフォルトはpython3）
2. SPARK_HOMEの検出（find-spark-home）
3. PYTHONPATHの設定（PySparkモジュールとpy4jライブラリ）
4. PySpark PipelinesのCLIスクリプトパスの動的特定
5. spark-classでSparkPipelinesクラスを起動

**前後の処理との関連**：find-spark-homeが前提。spark-classを直接呼び出す。PySpark Pipelinesパッケージが利用可能であることが前提。

**影響範囲**：PYTHONPATH環境変数を設定する。spark-classを介してJavaプロセスを起動する。パイプラインの定義に従ってデータ処理を実行する。

## バッチ種別

クライアント実行（データパイプライン実行）

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 随時 |
| 実行時刻 | 任意 |
| 実行曜日 | 該当なし |
| 実行日 | 該当なし |
| トリガー | 手動 |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| SPARK_HOME | 設定済み、またはfind-spark-homeで検出可能であること |
| Python3 | python3コマンドが利用可能であること（またはPYSPARK_PYTHONで指定） |
| PySparkパッケージ | pysparkパッケージがPYTHONPATHに存在すること |
| Javaランタイム | spark-class経由でJavaが実行可能であること |

### 実行可否判定

SPARK_HOME検出とPython環境が利用可能であれば実行可能。pysparkパッケージが見つからない場合、CLIスクリプトパスの特定に失敗する。

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| パイプライン引数 | String[] | No | なし | SparkPipelinesクラスに渡す引数（パイプライン定義ファイル等） |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| find-spark-home | シェルスクリプト | SPARK_HOMEの検出 |
| spark-class | シェルスクリプト | Javaクラスランチャー |
| pyspark/pipelines/cli.py | Pythonスクリプト | PySpark PipelinesのCLIエントリポイント |
| py4j-0.10.9.9-src.zip | Pythonライブラリ | Java-Python通信ライブラリ |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| 標準出力 | テキスト | パイプライン実行結果 |
| 標準エラー出力 | テキスト | エラーメッセージ・ログ |

### 出力ファイル仕様

パイプラインの定義に依存する。スクリプト自体はファイル出力を行わない。

## 処理フロー

### 処理シーケンス

```
1. Python実行環境設定
   └─ PYSPARK_PYTHONが未設定の場合、python3をデフォルトに設定
2. SPARK_HOME検出
   └─ SPARK_HOMEが未設定の場合、find-spark-homeをsource
3. PYTHONPATH設定
   └─ ${SPARK_HOME}/python/ を追加
   └─ ${SPARK_HOME}/python/lib/py4j-0.10.9.9-src.zip を追加
4. CLIスクリプトパス特定
   └─ Pythonを実行してpyspark.pipelines.cli.pyのフルパスを取得
   └─ pysparkパッケージのインストールパスから動的に解決
5. spark-class実行
   └─ exec spark-class org.apache.spark.deploy.SparkPipelines "$SDP_CLI_PY_FILE_PATH" でプロセスを置換
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B{PYSPARK_PYTHON設定済み?}
    B -->|No| C[PYSPARK_PYTHON=python3]
    B -->|Yes| D{SPARK_HOME設定済み?}
    C --> D
    D -->|No| E[find-spark-home実行]
    D -->|Yes| F[PYTHONPATH設定]
    E --> F
    F --> G[Python実行: cli.pyパス取得]
    G --> H[exec spark-class SparkPipelines]
    H --> I[バッチ終了]
```

## データベース操作仕様

### 操作別データベース影響一覧

本スクリプト自体はデータベース操作を行わない。パイプラインの定義に依存する。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| 非ゼロ | Python環境エラー | PYSPARK_PYTHONで指定したPythonが見つからない場合 | Python3をインストールまたはPYSPARK_PYTHONを正しく設定 |
| 非ゼロ | パッケージエラー | pysparkパッケージが見つからない場合 | PYTHONPATHの設定を確認 |
| 非ゼロ | spark-classエラー | spark-classの実行に失敗した場合 | Java環境やクラスパスを確認 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | なし |
| リトライ間隔 | 該当なし |
| リトライ対象エラー | 該当なし |

### 障害時対応

1. Python環境エラー：Python3のインストール状態とPYSPARK_PYTHON設定を確認する
2. パッケージエラー：PYTHONPATHにSPARK_HOME/pythonが含まれているか確認する
3. spark-classエラー：Java環境やクラスパスの設定を確認する

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | パイプラインの定義に依存 |
| コミットタイミング | パイプラインの定義に依存 |
| ロールバック条件 | パイプラインの定義に依存 |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | パイプラインの定義に依存 |
| 目標処理時間 | パイプラインの定義に依存 |
| メモリ使用量上限 | spark-classのデフォルト設定に依存 |

## 排他制御

排他制御なし。複数のspark-pipelinesインスタンスを同時に実行可能（パイプライン自体の排他制御は別途考慮が必要）。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| Sparkログ | パイプライン実行中 | Sparkフレームワークのログ |
| パイプラインログ | パイプライン実行中 | パイプラインの処理進捗・結果 |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| 終了コード | 非ゼロ | 呼び出し元に伝播 |

## 備考

- spark-submitではなくspark-classを直接使用してSparkPipelinesクラスを起動する
- CLIスクリプトパスはPythonのpysparkパッケージから動的に解決される（ヒアドキュメントでPythonコードを実行）
- py4j-0.10.9.9-src.zipがPYTHONPATHに追加される
- 起動クラスはorg.apache.spark.deploy.SparkPipelinesで、Sparkのdeployパッケージに属する
- SDP_CLI_PY_FILE_PATHはpyspark/pipelines/cli.pyへの絶対パスで、SparkPipelinesクラスの第1引数として渡される
