# バッチ設計書 29-run-example

## 概要

本ドキュメントは、Sparkサンプルアプリケーションを実行するクライアントスクリプト `bin/run-example` の設計を記述する。本スクリプトはspark-submitを経由してSparkのexampleクラスを実行する。

### 本バッチの処理概要

run-exampleは、Sparkに同梱されているサンプルアプリケーション（examples）を簡単に実行するためのユーティリティスクリプトである。spark-submitに`run-example`キーワードとクラス名を渡すことで、examplesパッケージのクラスを起動する。

**業務上の目的・背景**：Sparkの学習者や評価者が、Sparkの各種機能（RDD操作、SQL、MLlib、Streaming等）のサンプルコードを簡単に実行できる環境を提供する。インストール確認やパフォーマンスベンチマークにも使用される。

**バッチの実行タイミング**：ユーザーがサンプルアプリケーションを実行する際に手動で実行する。

**主要な処理内容**：
1. SPARK_HOMEの検出（find-spark-home）
2. 使用方法メッセージ（_SPARK_CMD_USAGE）の設定
3. spark-submitでrun-exampleキーワードとユーザー引数を渡して実行

**前後の処理との関連**：find-spark-homeが前提。内部でspark-submitを呼び出し、spark-submitはspark-classを経由してJavaプロセスを起動する。

**影響範囲**：サンプルアプリケーションの内容に依存する。

## バッチ種別

クライアント実行（サンプルアプリケーション実行）

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 随時 |
| 実行時刻 | 任意 |
| 実行曜日 | 該当なし |
| 実行日 | 該当なし |
| トリガー | 手動 |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| SPARK_HOME | 設定済み、またはfind-spark-homeで検出可能であること |
| Javaランタイム | spark-submit経由でJavaが実行可能であること |
| Sparkサンプル | examples JARがクラスパスに存在すること |

### 実行可否判定

SPARK_HOMEが検出できれば実行可能。spark-submitの実行条件に従う。指定されたexampleクラスが存在しない場合はクラスパスエラーとなる。

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| options | String[] | No | なし | spark-submitに渡すオプション |
| example-class | String | Yes | なし | 実行するサンプルクラス名（例: SparkPi, WordCount） |
| example args | String[] | No | なし | サンプルクラスに渡す引数 |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| find-spark-home | シェルスクリプト | SPARK_HOMEの検出 |
| spark-submit | シェルスクリプト | アプリケーション投入の基盤 |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| 標準出力 | テキスト | サンプルアプリケーションの実行結果 |
| 標準エラー出力 | テキスト | エラーメッセージ・ログ |

### 出力ファイル仕様

本スクリプトはファイル出力を行わない。サンプルアプリケーションの出力はクラスの実装に依存する。

## 処理フロー

### 処理シーケンス

```
1. SPARK_HOME検出
   └─ SPARK_HOMEが未設定の場合、find-spark-homeをsource
2. 使用方法メッセージ設定
   └─ _SPARK_CMD_USAGEをexport
3. spark-submit実行
   └─ exec spark-submit run-example でプロセスを置換
   └─ ユーザー引数（example-classとその引数）も渡される
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B{SPARK_HOME設定済み?}
    B -->|No| C[find-spark-home実行]
    B -->|Yes| D[_SPARK_CMD_USAGE設定]
    C --> D
    D --> E[exec spark-submit run-example]
    E --> F[バッチ終了]
```

## データベース操作仕様

### 操作別データベース影響一覧

本スクリプト自体はデータベース操作を行わない。実行されるサンプルアプリケーションに依存する。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| 非ゼロ | spark-submitエラー | spark-submitの実行に失敗した場合 | Java環境やクラスパスを確認 |
| 非ゼロ | クラスパスエラー | 指定されたexampleクラスが見つからない場合 | クラス名の正確性とexamples JARの存在を確認 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | なし |
| リトライ間隔 | 該当なし |
| リトライ対象エラー | 該当なし |

### 障害時対応

1. spark-submitエラー：Java環境やクラスパスの設定を確認する
2. クラスが見つからない場合：Sparkのビルドにexamplesが含まれているか確認する

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | 該当なし |
| コミットタイミング | 該当なし |
| ロールバック条件 | 該当なし |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | サンプルアプリケーションに依存 |
| 目標処理時間 | サンプルアプリケーションに依存 |
| メモリ使用量上限 | spark-submitのデフォルト設定に依存 |

## 排他制御

排他制御なし。複数のrun-exampleインスタンスを同時に実行可能。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| Sparkログ | サンプル実行中 | Sparkフレームワークのログ（spark-submitのログ設定に準拠） |
| サンプル出力 | サンプル実行中 | サンプルアプリケーションの出力結果 |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| 終了コード | 非ゼロ | 呼び出し元に伝播 |

## 備考

- Usage: `./bin/run-example [options] example-class [example args]`
- spark-submitに`run-example`キーワードを渡すことで、SparkSubmit内部でexamplesパッケージのクラスとして解釈される
- execでspark-submitを実行するため、プロセスが置換される
- 代表的なサンプルクラス例：SparkPi, WordCount, LogQuery等
