# バッチ設計書 3-start-master.sh

## 概要

本ドキュメントは、Apache SparkのMasterデーモンをローカルノードで起動するシェルスクリプト `start-master.sh` のバッチ設計書である。

### 本バッチの処理概要

`start-master.sh` は、Sparkクラスタのマスターノードで `org.apache.spark.deploy.master.Master` クラスをデーモンプロセスとして起動するスクリプトである。MasterはWorkerの管理、リソース割り当て、アプリケーションのスケジューリングを担当するSparkクラスタの中枢コンポーネントである。

**業務上の目的・背景**：Sparkクラスタの運用において、Masterデーモンはクラスタ全体を管理する中心的な役割を果たす。本バッチはMasterデーモンの起動を標準化し、ホスト名・ポート・WebUIポートの設定を環境変数またはデフォルト値から自動的に構成する。Sparkクラスタを稼働させるために最初に起動すべきコンポーネントである。

**バッチの実行タイミング**：手動実行。クラスタ起動時に `start-all.sh` から呼び出されるか、Master単体で起動する場合に直接実行する。

**主要な処理内容**：
1. SPARK_HOMEが未設定の場合、スクリプトの配置ディレクトリから自動検出する
2. `--help` / `-h` オプション指定時はヘルプメッセージを表示して終了する
3. `spark-config.sh` および `load-spark-env.sh` をsourceして設定を初期化する
4. SPARK_MASTER_PORT（デフォルト: 7077）、SPARK_MASTER_HOST（デフォルト: hostname -f）、SPARK_MASTER_WEBUI_PORT（デフォルト: 8080）を設定する
5. `spark-daemon.sh start` 経由で `org.apache.spark.deploy.master.Master` をデーモンとして起動する

**前後の処理との関連**：`start-all.sh`（No.1）から呼び出される。Master起動後、`start-workers.sh`（No.7）でWorkerが起動される。停止は `stop-master.sh`（No.4）で行う。

**影響範囲**：ローカルノードでMasterデーモンプロセスが起動される。デフォルトでポート7077（RPC）およびポート8080（WebUI）をバインドする。

## バッチ種別

デーモン管理（Masterデーモン起動）

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 随時 |
| 実行時刻 | 任意 |
| 実行曜日 | 該当なし |
| 実行日 | 該当なし |
| トリガー | 手動 / start-all.shからの呼び出し |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| SPARK_HOME | SPARK_HOMEが設定済み、または自動検出可能であること |
| Java | Javaランタイムがインストールされ、PATHに含まれていること |
| ポート7077 | デフォルトのMasterポート（7077）が使用可能であること |
| ポート8080 | デフォルトのWebUIポート（8080）が使用可能であること |
| Masterが未起動 | 同一インスタンス番号のMasterデーモンが起動していないこと |

### 実行可否判定

spark-daemon.sh がPIDファイル（`spark-{USER}-org.apache.spark.deploy.master.Master-1.pid`）を確認し、既にプロセスが起動中であれば起動を拒否する。

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| --help / -h | フラグ | No | - | ヘルプメッセージを表示して終了 |
| --host | 文字列 | No | hostname -f の結果 | Masterがバインドするホスト名 |
| --port | 整数 | No | 7077 | MasterのRPCポート |
| --webui-port | 整数 | No | 8080 | MasterのWebUIポート |
| その他のオプション | - | No | - | Master クラスに渡される追加オプション |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| 環境変数 SPARK_MASTER_PORT | 整数 | Masterポート番号（デフォルト: 7077） |
| 環境変数 SPARK_MASTER_HOST | 文字列 | Masterホスト名（デフォルト: hostname -f） |
| 環境変数 SPARK_MASTER_WEBUI_PORT | 整数 | WebUIポート番号（デフォルト: 8080） |
| spark-env.sh | シェルスクリプト | Spark環境設定ファイル |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| 標準出力 | テキスト | 起動メッセージ |
| PIDファイル | テキスト | Masterプロセスのプロセスid |
| ログファイル | テキスト | Master起動ログ |

### 出力ファイル仕様

| 項目 | 内容 |
|-----|------|
| ファイル名 | spark-{SPARK_IDENT_STRING}-org.apache.spark.deploy.master.Master-1-{HOSTNAME}.out |
| 出力先 | ${SPARK_LOG_DIR}（デフォルト: ${SPARK_HOME}/logs） |
| 文字コード | システムデフォルト |
| 区切り文字 | 該当なし |

## 処理フロー

### 処理シーケンス

```
1. SPARK_HOME検出・設定
   └─ 環境変数が未設定の場合、スクリプト配置ディレクトリの親ディレクトリを設定
2. ヘルプ判定
   └─ --help / -h 指定時はspark-classでヘルプ表示して終了
3. 設定読み込み
   └─ spark-config.sh と load-spark-env.sh をsource
4. デフォルト値設定
   └─ SPARK_MASTER_PORT（7077）、SPARK_MASTER_HOST（hostname -f）、SPARK_MASTER_WEBUI_PORT（8080）
5. SunOS対応
   └─ SunOSの場合は /usr/sbin/check-hostname でホスト名を取得
6. Master起動
   └─ spark-daemon.sh start org.apache.spark.deploy.master.Master 1 --host --port --webui-port
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B[SPARK_HOME設定]
    B --> C{--help/-h?}
    C -->|はい| D[ヘルプ表示]
    D --> E[終了 exit 0]
    C -->|いいえ| F[spark-config.sh読み込み]
    F --> G[load-spark-env.sh読み込み]
    G --> H[SPARK_MASTER_PORT設定 デフォルト7077]
    H --> I[SPARK_MASTER_HOST設定 デフォルトhostname -f]
    I --> J[SPARK_MASTER_WEBUI_PORT設定 デフォルト8080]
    J --> K[spark-daemon.sh start Master]
    K --> L[バッチ終了]
```

## データベース操作仕様

### 操作別データベース影響一覧

本バッチはデータベース操作を行わない。

### テーブル別操作詳細

該当なし

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| 1 | 重複起動 | 同一インスタンス番号のMasterが既に起動中 | stop-master.shで停止後に再実行 |
| - | 起動失敗 | ポート7077がバインド済み | ポートの競合を解消するか、SPARK_MASTER_PORTで別ポートを指定 |
| - | 起動失敗 | Javaが見つからない | Java環境のインストール・PATH設定を確認 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | なし |
| リトライ間隔 | 該当なし |
| リトライ対象エラー | 該当なし |

### 障害時対応

1. ログファイル（`${SPARK_LOG_DIR}/spark-*-org.apache.spark.deploy.master.Master-*.out`）を確認する
2. ポートの競合がないか `netstat` / `ss` で確認する
3. spark-daemon.sh が起動後5秒間Javaプロセスのポーリングを行い、失敗時にはログ末尾10行を表示する

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | 該当なし（プロセス起動のため） |
| コミットタイミング | 該当なし |
| ロールバック条件 | 該当なし |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 1プロセス |
| 目標処理時間 | 数秒（Javaプロセス起動完了まで） |
| メモリ使用量上限 | シェルスクリプト自体は最小限。Masterプロセスのメモリはspark-env.shで設定 |

## 排他制御

spark-daemon.sh がPIDファイル（`${SPARK_PID_DIR}/spark-{SPARK_IDENT_STRING}-org.apache.spark.deploy.master.Master-1.pid`）による排他制御を実施する。インスタンス番号は固定で1。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 起動ログ | デーモン起動時 | "starting org.apache.spark.deploy.master.Master, logging to {ログパス}" |
| エラーログ | 起動失敗時 | "failed to launch: {コマンド}" + ログ末尾10行 |
| 重複起動ログ | 既存プロセス検出時 | "org.apache.spark.deploy.master.Master running as process {PID}. Stop it first." |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| Masterプロセス存在 | PIDファイル + psコマンド | 運用者（手動確認） |
| WebUI応答 | ポート8080のHTTP応答 | 運用者（手動確認） |

## 備考

- 起動クラス名 `org.apache.spark.deploy.master.Master` はSparkSubmitでも参照されるため、変更時は整合性に注意が必要（ソースコードコメント記載あり）
- SunOS環境では `/usr/sbin/check-hostname` でホスト名を取得する特別処理がある
- インスタンス番号は常に1で固定される
