# バッチ設計書 30-load-spark-env.sh

## 概要

本ドキュメントは、spark-env.sh設定ファイルの読み込みとScalaバージョン設定を行う環境設定スクリプト `bin/load-spark-env.sh` の設計を記述する。本スクリプトは多くのbinスクリプトからsourceされる共通の環境初期化スクリプトである。

### 本バッチの処理概要

load-spark-env.shは、Sparkの実行環境を初期化するための共通設定スクリプトである。spark-env.sh設定ファイルの読み込み（1回限り）、Scalaバージョンの設定、およびBeeLineのバックグラウンド実行対応設定を行う。他のSparkスクリプト（spark-class、pyspark、sparkR等）からsourceされて使用される。

**業務上の目的・背景**：Sparkの各スクリプトが共通の環境設定を一貫して読み込むための基盤を提供する。ユーザーがspark-env.shで定義したカスタム設定（メモリ設定、Javaオプション等）を全Sparkスクリプトに反映する。重複読み込みを防止する仕組みにより、設定の二重適用を防ぐ。

**バッチの実行タイミング**：他のSparkスクリプトからsourceされる度に実行される。ただし、内部のガードにより実際の設定読み込みは1回のみ。

**主要な処理内容**：
1. SPARK_HOMEの検出（find-spark-home）
2. SPARK_ENV_LOADEDフラグによる二重読み込み防止
3. SPARK_CONF_DIRの設定（デフォルト: ${SPARK_HOME}/conf）
4. spark-env.shの読み込み（set -aで全変数をexport）
5. SPARK_SCALA_VERSION=2.13の設定
6. BeeLineバックグラウンド実行時のjline.terminal設定

**前後の処理との関連**：find-spark-homeが前提。spark-class、pyspark、sparkR等の多くのスクリプトからsourceされる。spark-env.shはユーザーがカスタマイズする設定ファイル。

**影響範囲**：全Sparkスクリプトの実行環境に影響する。SPARK_ENV_LOADED、SPARK_CONF_DIR、SPARK_SCALA_VERSION、SPARK_BEELINE_OPTS等の環境変数を設定する。

## バッチ種別

環境設定（共通環境初期化スクリプト）

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 他スクリプトからsourceされる度 |
| 実行時刻 | 呼び出し元に依存 |
| 実行曜日 | 該当なし |
| 実行日 | 該当なし |
| トリガー | 他スクリプトからのsource呼び出し |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| SPARK_HOME | 設定済み、またはfind-spark-homeで検出可能であること |
| シェル環境 | bashまたはPOSIX互換シェルで実行されること |

### 実行可否判定

常に実行可能。SPARK_ENV_LOADEDが設定済みの場合、spark-env.shの読み込みをスキップする（二重読み込み防止）。

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| SPARK_CONF_DIR | 環境変数 | No | ${SPARK_HOME}/conf | Spark設定ディレクトリのパス |
| SPARK_ENV_LOADED | 環境変数 | No | 未設定 | 読み込み済みフラグ（設定済みの場合スキップ） |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| find-spark-home | シェルスクリプト | SPARK_HOMEの検出 |
| ${SPARK_CONF_DIR}/spark-env.sh | シェルスクリプト | ユーザー定義のSpark環境設定 |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| 環境変数 | シェル環境 | SPARK_ENV_LOADED, SPARK_CONF_DIR, SPARK_SCALA_VERSION, SPARK_BEELINE_OPTS等 |

### 出力ファイル仕様

本スクリプトはファイル出力を行わない。環境変数の設定のみ行う。

## 処理フロー

### 処理シーケンス

```
1. SPARK_HOME検出
   └─ SPARK_HOMEが未設定の場合、find-spark-homeをsource
2. 二重読み込み判定
   └─ SPARK_ENV_LOADEDが設定済みの場合、spark-env.shの読み込みをスキップ
3. SPARK_ENV_LOADED設定
   └─ SPARK_ENV_LOADED=1をexport
4. SPARK_CONF_DIR設定
   └─ SPARK_CONF_DIRが未設定の場合、${SPARK_HOME}/confをデフォルトに設定
5. spark-env.sh読み込み
   └─ ${SPARK_CONF_DIR}/spark-env.shが存在する場合、set -aで全変数をexportしてsource
   └─ source完了後、set +aでexportモードを解除
6. SPARK_SCALA_VERSION設定
   └─ SPARK_SCALA_VERSION=2.13を固定設定（export）
7. BeeLineバックグラウンド設定
   └─ プロセスがフォアグラウンドでなく、かつ標準入力がパイプでない場合
   └─ SPARK_BEELINE_OPTSに-Djline.terminal=jline.UnsupportedTerminalを追加
```

### フローチャート

```mermaid
flowchart TD
    A[スクリプト開始] --> B{SPARK_HOME設定済み?}
    B -->|No| C[find-spark-home実行]
    B -->|Yes| D{SPARK_ENV_LOADED設定済み?}
    C --> D
    D -->|Yes| E[spark-env.sh読み込みスキップ]
    D -->|No| F[SPARK_ENV_LOADED=1]
    F --> G[SPARK_CONF_DIR設定]
    G --> H{spark-env.sh存在?}
    H -->|Yes| I[set -a で source spark-env.sh]
    H -->|No| J[スキップ]
    I --> J
    E --> K[SPARK_SCALA_VERSION=2.13]
    J --> K
    K --> L{バックグラウンドプロセス?}
    L -->|Yes| M[SPARK_BEELINE_OPTS追加]
    L -->|No| N[スクリプト終了]
    M --> N
```

## データベース操作仕様

### 操作別データベース影響一覧

本スクリプトはデータベース操作を行わない。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| なし | 設定ファイルエラー | spark-env.shに構文エラーがある場合 | spark-env.shの内容を確認・修正する |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 該当なし（sourceスクリプトのためリトライ機構なし） |
| リトライ間隔 | 該当なし |
| リトライ対象エラー | 該当なし |

### 障害時対応

1. spark-env.sh構文エラー：spark-env.shファイルの内容を確認し、シェルスクリプトとして有効な構文に修正する
2. SPARK_CONF_DIR不正：SPARK_CONF_DIRのパスが正しいか確認する

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | 該当なし |
| コミットタイミング | 該当なし |
| ロールバック条件 | 該当なし |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 1回のsourceで1回の環境設定 |
| 目標処理時間 | 即時（ミリ秒単位） |
| メモリ使用量上限 | 最小限（シェル変数のみ） |

## 排他制御

排他制御なし。SPARK_ENV_LOADEDフラグにより、同一プロセス内での二重読み込みを防止する。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| なし | - | 本スクリプトはログ出力を行わない |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| なし | - | 本スクリプトは監視対象外 |

## 備考

- SPARK_SCALA_VERSION=2.13が固定値として設定される。以前のバージョンではassemblyディレクトリの存在に基づいて動的に判定するロジックがあったが、現在はコメントアウトされている
- `set -a` / `set +a` を使用してspark-env.sh内のすべての変数宣言を自動的にexportする。これにより、spark-env.shでexportを明記しなくても環境変数として伝播する
- BeeLineバックグラウンド実行の判定は `ps -o stat= -p $$` でプロセス状態を確認し、`+`（フォアグラウンド）がない場合かつ標準入力がパイプでない場合にjline.terminal設定を追加する
- spark-env.shが存在しない場合はエラーにならず、単にスキップされる
- SPARK_CONF_DIRはユーザーが変更可能で、デフォルトは${SPARK_HOME}/conf
