# バッチ設計書 36-test-dependencies.sh

## 概要

本ドキュメントは、Sparkの依存関係テストを実行するスクリプト `dev/test-dependencies.sh` のバッチ設計書である。本スクリプトはSparkプロジェクトの公開依存関係（クラスパス上のJAR）が既知のマニフェストファイルと一致することを検証する。依存関係の意図しない変更を検出し、リリース品質を保証するためのゲートチェックとして機能する。

### 本バッチの処理概要

本スクリプトは、Sparkプロジェクトの依存関係マニフェストの整合性を検証するバリデーションツールである。

**業務上の目的・背景**：Apache Sparkは多数のサードパーティライブラリに依存しており、依存関係の意図しない変更（バージョン変更、新規追加、削除）はバイナリ互換性の問題やライセンスコンプライアンスの問題を引き起こす可能性がある。本スクリプトは、現在のビルドから生成される依存関係クラスパスを、リポジトリに格納されたマニフェストファイル（dev/deps/spark-deps-*）と比較することで、依存関係の変更を検出する。これはリリースプロセスにおける品質ゲートとして機能し、PRレビュー時に依存関係変更の意図的な承認を促す。

**バッチの実行タイミング**：CI/CDパイプライン（GitHub Actions）のPRチェック時にrun-tests.pyから呼び出される。また、依存関係を変更した際に手動で実行してマニフェストを更新するためにも使用される。

**主要な処理内容**：
1. ロケール設定の固定化（sort出力の一貫性確保）
2. Maven exec-pluginバージョンの取得
3. 現在のプロジェクトバージョンの取得
4. Scala 2.13以外のバージョンでのスキップ判定
5. guava・jetty-ioの依存関係事前取得（SPARK-37302対応）
6. テンポラリバージョンへの切り替え（内部依存解決のため）
7. 各Hadoop/Hiveプロファイルに対するMaven install・validate・dependency:build-classpath実行
8. クラスパスからの依存関係マニフェスト生成（artifact_id/version/classifier/jar_name形式）
9. 既存マニフェストとの差分比較（git diff --no-index）
10. --replace-manifestオプションによるマニフェスト更新
11. テンポラリバージョンの復元（EXITトラップ）

**前後の処理との関連**：run-tests.pyのrun_build_tests関数から呼び出される。ビルドの依存関係解決能力（Maven）に依存する。Mavenのhelp:evaluateプラグイン、dependency:build-classpathプラグイン、versions:setプラグインを使用する。

**影響範囲**：Mavenローカルリポジトリ（~/.m2/）にテンポラリバージョンのPOMが一時的にインストールされる（EXITトラップで自動削除）。dev/pr-deps/ディレクトリに一時的な依存関係マニフェストが生成される。--replace-manifestオプション使用時はdev/deps/ディレクトリのマニフェストファイルが更新される。

## バッチ種別

テスト（依存関係整合性テスト）

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 随時（PRチェック時 / 手動実行） |
| 実行時刻 | N/A |
| 実行曜日 | N/A |
| 実行日 | N/A |
| トリガー | run-tests.pyからの呼び出し / 手動実行 |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| Maven | `build/mvn`経由でMavenが利用可能であること |
| Python3 | テンポラリバージョン番号の生成にpython3を使用 |
| git | マニフェスト比較にgit diffを使用 |
| Scala 2.13 | Scala 2.13以外のバージョンではスキップされる |

### 実行可否判定

Scalaバイナリバージョンが2.13でない場合は"Skip dependency testing"メッセージを出力してexit 0で正常終了する。

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| --replace-manifest | フラグ | No | なし | マニフェストファイルを現在の依存関係で更新する |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| pom.xml（全モジュール） | XML | Maven POM（依存関係定義） |
| dev/deps/spark-deps-* | テキスト | 既存の依存関係マニフェストファイル |
| build/mvn | スクリプト | Mavenラッパー |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| dev/pr-deps/spark-deps-* | テキスト | 現在ビルドの依存関係マニフェスト（一時ファイル、正常終了時に削除） |
| dev/deps/spark-deps-* | テキスト | 更新された依存関係マニフェスト（--replace-manifest時のみ） |
| 標準出力 | テキスト | 差分情報・テスト結果 |

### 出力ファイル仕様

| 項目 | 内容 |
|-----|------|
| ファイル名 | spark-deps-{HADOOP_HIVE_PROFILE} |
| 出力先 | dev/pr-deps/ （一時）、dev/deps/ （--replace-manifest時） |
| 文字コード | ASCII |
| 区切り文字 | /（スラッシュ） |
| フォーマット | artifact_id/version/classifier/jar_name（1行1依存関係、ソート済み） |

## 処理フロー

### 処理シーケンス

```
1. ロケール設定
   └─ LC_ALL=C を設定（sort出力の一貫性確保）
2. 環境情報取得
   └─ exec-maven-plugin.versionの取得
   └─ project.versionの取得
   └─ scala.binary.versionの取得
3. Scalaバージョンチェック
   └─ 2.13以外の場合はスキップ（exit 0）
4. 依存関係事前取得（SPARK-37302対応）
   └─ guava、jetty-ioのJARをMavenローカルリポジトリにダウンロード
5. テンポラリバージョンへの切り替え
   └─ ランダム番号（100000-999999）でテンポラリバージョン名を生成
   └─ versions:setでプロジェクトバージョンを一時変更
   └─ EXITトラップで復元処理を登録
6. 各Hadoop/Hiveプロファイルに対するマニフェスト生成
   └─ プロファイル: hadoop-3-hive-2.3
   └─ Maven jar:jar + jar:test-jar + install:install + clean 実行
   └─ Maven validate 実行
   └─ Maven dependency:build-classpath で依存関係クラスパスを取得
   └─ awkで artifact_id/version/classifier/jar_name 形式に変換
   └─ sortしてspark自身のJARを除外
   └─ dev/pr-deps/spark-deps-{profile} に出力
7. マニフェスト比較
   └─ [--replace-manifest時] dev/pr-depsをdev/depsに移動して終了
   └─ [通常時] git diff --no-indexでdev/depsとdev/pr-depsを比較
   └─ 差分がある場合: エラーメッセージと差分を表示、exit 1
   └─ 差分がない場合: dev/pr-depsを削除、exit 0
8. クリーンアップ（EXITトラップ）
   └─ ~/.m2/配下のテンポラリバージョンPOMを削除
   └─ プロジェクトバージョンを元のバージョンに復元
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B[ロケール・環境情報取得]
    B --> C{Scala 2.13?}
    C -->|いいえ| D[スキップ・exit 0]
    C -->|はい| E[依存関係事前取得]
    E --> F[テンポラリバージョンに切替]
    F --> G[各プロファイルでMaven install/validate]
    G --> H[dependency:build-classpathでマニフェスト生成]
    H --> I{--replace-manifest?}
    I -->|はい| J[dev/pr-depsをdev/depsに移動]
    J --> K[exit 0]
    I -->|いいえ| L[git diff --no-indexで比較]
    L --> M{差分あり?}
    M -->|はい| N[差分表示・exit 1]
    M -->|いいえ| O[dev/pr-deps削除・exit 0]
    N --> P[EXITトラップ: バージョン復元・一時POM削除]
    O --> P
    K --> P
    D --> P
```

## データベース操作仕様

### 操作別データベース影響一覧

データベース操作なし。本スクリプトはMaven操作とファイルシステム操作のみを行う。ただし、Mavenローカルリポジトリ（~/.m2/）への一時的な書き込みが発生する。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| 1 | バージョン取得失敗 | Maven exec:execでプロジェクトバージョンが取得できない | Maven環境・POMファイルを確認する |
| 1 | 依存関係マニフェスト不一致 | 現在の依存関係がdev/deps/のマニフェストと異なる | `./dev/test-dependencies.sh --replace-manifest`でマニフェストを更新する |
| 非0 | Mavenビルド失敗 | Maven install/validate/dependency:build-classpathが失敗 | Maven環境・ネットワークを確認する |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 0（リトライなし） |
| リトライ間隔 | N/A |
| リトライ対象エラー | N/A |

### 障害時対応

- Mavenローカルリポジトリにテンポラリバージョンのアーティファクトが残る場合は、EXITトラップのreset_version関数により自動クリーンアップされる
- EXITトラップが正常に動作しない場合は、手動で`build/mvn versions:set -DnewVersion={元のバージョン} -DgenerateBackupPoms=false`を実行してバージョンを復元し、`~/.m2/`配下のテンポラリバージョンディレクトリを手動で削除する
- 依存関係不一致でエラーになった場合、意図的な変更であれば`--replace-manifest`オプションで再実行してマニフェストを更新し、更新したマニフェストをコミットする

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | テンポラリバージョン切替〜復元（EXITトラップ） |
| コミットタイミング | N/A |
| ロールバック条件 | スクリプト終了時（EXITトラップ）にバージョン復元・一時ファイル削除 |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 1プロファイル分（hadoop-3-hive-2.3） |
| 目標処理時間 | Maven依存関係解決に依存（数分〜十数分） |
| メモリ使用量上限 | Maven実行に依存 |

## 排他制御

同一SPARK_HOME上での同時実行は非対応。プロジェクトバージョンの一時変更が行われるため、並行実行するとバージョン競合が発生する。Mavenローカルリポジトリ（~/.m2/）への書き込みも競合する可能性がある。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 開始ログ | 各プロファイル処理開始時 | "Performing Maven install for {profile}" |
| 進捗ログ | validate実行時 | "Performing Maven validate for {profile}" |
| マニフェスト生成ログ | マニフェスト生成時 | "Generating dependency manifest for {profile}" |
| エラーログ | 依存関係不一致時 | 差分内容とマニフェスト更新コマンドのガイダンス |
| マニフェスト更新ログ | --replace-manifest時 | "Replacing manifests and creating new files at dev/deps" |
| set -exによるトレース | 全処理 | 実行コマンドのトレース出力 |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| 終了コード | 0以外 | CI/CDシステム / GitHub Actions |
| 依存関係差分 | 差分あり | PR レビュー通知 |

## 備考

- テンポラリバージョン名はPython3のrandom.randrangeで生成される6桁のランダム番号（spark-XXXXXX形式）で、Mavenの内部依存解決を可能にするために使用される
- LC_ALL=C の設定により、異なるマシン間でのsort出力の一貫性を確保している
- HADOOP_MODULE_PROFILESには`-Phive-thriftserver -Pkubernetes -Pyarn -Phive -Pspark-ganglia-lgpl -Pkinesis-asl -Phadoop-cloud -Pjvm-profiler`が含まれる
- HADOOP_HIVE_PROFILESは現在`hadoop-3-hive-2.3`の1つのみ
- guava・jetty-ioの事前取得はSPARK-37302対応として行われている
- クラスパスからの依存関係抽出では、awkを使用してartifact_id/version/classifier/jar_name形式に変換し、classifierはJAR名からartifact_id-version-の後に続く.jar前の部分として抽出される
- `set +e`/`set -e`の切り替えにより、バージョン取得とマニフェスト比較（差分があっても継続）の処理で非ゼロ終了コードを許容している
