# バッチ設計書 4-stop-master.sh

## 概要

本ドキュメントは、Apache SparkのMasterデーモンを停止するシェルスクリプト `stop-master.sh` のバッチ設計書である。

### 本バッチの処理概要

`stop-master.sh` は、ローカルノードで稼働中のSpark Masterデーモン（`org.apache.spark.deploy.master.Master`）を停止するスクリプトである。`spark-daemon.sh stop` コマンド経由でPIDファイルからプロセスIDを読み取り、killシグナルを送信して停止する。

**業務上の目的・背景**：Sparkクラスタのメンテナンスや障害対応において、Masterデーモンを安全に停止する必要がある。本バッチは `start-master.sh` と対になる停止用スクリプトであり、PIDファイルを用いた確実なプロセス停止を行う。

**バッチの実行タイミング**：手動実行。クラスタの計画停止時に `stop-all.sh` から呼び出されるか、Master単体を停止する場合に直接実行する。

**主要な処理内容**：
1. SPARK_HOMEが未設定の場合、スクリプトの配置ディレクトリから自動検出する
2. `spark-config.sh` をsourceしてSpark共通設定を初期化する
3. `spark-daemon.sh stop` を呼び出してMasterデーモンを停止する（インスタンス番号: 1）

**前後の処理との関連**：`stop-all.sh`（No.2）から呼び出される。停止順序として、`stop-workers.sh`（No.8）が先に実行された後に本バッチが実行される。起動は `start-master.sh`（No.3）で行う。

**影響範囲**：ローカルノードのMasterデーモンプロセスが停止する。Masterが停止するとWorkerはMasterとの接続を失い、新たなアプリケーションの受付ができなくなる。

## バッチ種別

デーモン管理（Masterデーモン停止）

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 随時 |
| 実行時刻 | 任意 |
| 実行曜日 | 該当なし |
| 実行日 | 該当なし |
| トリガー | 手動 / stop-all.shからの呼び出し |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| SPARK_HOME | SPARK_HOMEが設定済み、または自動検出可能であること |
| Masterが起動済み | Masterデーモンが起動中であること（未起動でもエラーにはならない） |

### 実行可否判定

PIDファイルの存在とプロセスの存在を確認する。PIDファイルがない場合やプロセスが存在しない場合は "no org.apache.spark.deploy.master.Master to stop" と出力するのみ。

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| なし | - | - | - | 本スクリプトはコマンドライン引数を受け取らない |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| PIDファイル | テキスト | ${SPARK_PID_DIR}/spark-{SPARK_IDENT_STRING}-org.apache.spark.deploy.master.Master-1.pid |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| 標準出力 | テキスト | 停止メッセージ |

### 出力ファイル仕様

| 項目 | 内容 |
|-----|------|
| ファイル名 | PIDファイルが削除される |
| 出力先 | ${SPARK_PID_DIR}（デフォルト: /tmp） |
| 文字コード | 該当なし |
| 区切り文字 | 該当なし |

## 処理フロー

### 処理シーケンス

```
1. SPARK_HOME検出・設定
   └─ 環境変数が未設定の場合、スクリプト配置ディレクトリの親ディレクトリを設定
2. Spark設定読み込み
   └─ spark-config.shをsource
3. Master停止
   └─ spark-daemon.sh stop org.apache.spark.deploy.master.Master 1
      ├─ PIDファイルからプロセスIDを読み取り
      ├─ psコマンドでJavaプロセスの存在を確認
      ├─ killシグナルを送信
      └─ PIDファイルを削除
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B[SPARK_HOME設定]
    B --> C[spark-config.sh読み込み]
    C --> D[spark-daemon.sh stop Master 1]
    D --> E{PIDファイル存在?}
    E -->|はい| F{プロセス存在?}
    F -->|はい| G[kill送信 + PIDファイル削除]
    F -->|いいえ| H[no Master to stop]
    E -->|いいえ| H
    G --> I[バッチ終了]
    H --> I
```

## データベース操作仕様

### 操作別データベース影響一覧

本バッチはデータベース操作を行わない。

### テーブル別操作詳細

該当なし

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | 停止対象なし | PIDファイルがない、またはプロセスが存在しない | "no {command} to stop" と出力されるのみ。正常系として扱われる |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | なし |
| リトライ間隔 | 該当なし |
| リトライ対象エラー | 該当なし |

### 障害時対応

1. killシグナルでプロセスが停止しない場合、`kill -9` で強制停止する
2. PIDファイルが残っているがプロセスが存在しない場合、PIDファイルを手動削除する

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | 該当なし（プロセス停止のため） |
| コミットタイミング | 該当なし |
| ロールバック条件 | 該当なし |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 1プロセス |
| 目標処理時間 | 即時（killシグナル送信のみ） |
| メモリ使用量上限 | シェルスクリプト自体は最小限 |

## 排他制御

停止処理はPIDファイルを読み取って対象プロセスにkillシグナルを送信し、その後PIDファイルを削除する。これにより、次回の起動が可能になる。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 停止ログ | デーモン停止時 | "stopping org.apache.spark.deploy.master.Master" |
| 不在ログ | デーモン未起動時 | "no org.apache.spark.deploy.master.Master to stop" |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| Master停止確認 | プロセス不在 | 運用者（手動確認） |

## 備考

- 本スクリプトは非常にシンプルで、spark-daemon.sh にstopオプションを渡すだけの薄いラッパーである
- インスタンス番号は常に1で固定される
- killシグナルはデフォルトのSIGTERMが使用される
