# バッチ設計書 5-start-worker.sh

## 概要

本ドキュメントは、Apache SparkのWorkerデーモンをローカルノードで起動するシェルスクリプト `start-worker.sh` のバッチ設計書である。

### 本バッチの処理概要

`start-worker.sh` は、Sparkクラスタの個別ノードで `org.apache.spark.deploy.worker.Worker` クラスをデーモンプロセスとして起動するスクリプトである。MasterのURLを引数として受け取り、指定されたMasterに接続するWorkerを起動する。`SPARK_WORKER_INSTANCES` 環境変数により、1ノードで複数のWorkerインスタンスを起動することも可能である。

**業務上の目的・背景**：Sparkクラスタにおいて、Workerはタスクの実行を担うコンピューティングリソースである。本バッチはWorkerデーモンの起動を標準化し、ポート番号やWebUIポートの自動割り当てを行う。クラスタのスケールアウトや個別ノードの追加時に使用される。

**バッチの実行タイミング**：手動実行。通常は `start-workers.sh`（No.7）経由でSSHリモート実行されるか、個別ノードで直接実行する。

**主要な処理内容**：
1. SPARK_HOMEが未設定の場合、スクリプトの配置ディレクトリから自動検出する
2. 引数が不足している場合、または `--help` / `-h` 指定時はヘルプ表示して終了する
3. `spark-config.sh` および `load-spark-env.sh` をsourceして設定を初期化する
4. 第1引数をMaster URL（例: spark://host:7077）として取得する
5. SPARK_WORKER_WEBUI_PORT（デフォルト: 8081）を設定する
6. SPARK_WORKER_INSTANCES に応じて1つまたは複数のWorkerインスタンスを起動する
7. 各インスタンスはインスタンス番号に応じてポート番号とWebUIポートをインクリメントする

**前後の処理との関連**：`start-workers.sh`（No.7）から `workers.sh` 経由でリモート呼び出しされる。Master（`start-master.sh` No.3）が事前に起動されている必要がある。停止は `stop-worker.sh`（No.6）で行う。

**影響範囲**：ローカルノードでWorkerデーモンプロセスが1つまたは複数起動される。デフォルトでWebUIポート8081（以降インクリメント）をバインドする。

## バッチ種別

デーモン管理（Workerデーモン起動）

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 随時 |
| 実行時刻 | 任意 |
| 実行曜日 | 該当なし |
| 実行日 | 該当なし |
| トリガー | 手動 / start-workers.shからのSSHリモート呼び出し |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| SPARK_HOME | SPARK_HOMEが設定済み、または自動検出可能であること |
| Java | Javaランタイムがインストールされ、PATHに含まれていること |
| Master起動済み | 指定されたMaster URLでMasterデーモンが稼働していること |
| ポート利用可能 | WebUIポート（デフォルト8081〜）が使用可能であること |

### 実行可否判定

spark-daemon.sh がPIDファイルを確認し、同一インスタンス番号のWorkerが既に起動中であれば起動を拒否する。

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| master | 文字列 | Yes | - | Master URL（例: spark://host:7077）。第1引数として必須 |
| --help / -h | フラグ | No | - | ヘルプメッセージを表示して終了 |
| --webui-port | 整数 | No | 8081 | WorkerのWebUIポート |
| --port | 整数 | No | 自動割り当て | WorkerのRPCポート |
| その他のオプション | - | No | - | Worker クラスに渡される追加オプション |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| 環境変数 SPARK_WORKER_INSTANCES | 整数 | 起動するWorkerインスタンス数（デフォルト: 1）。Spark 3.0以降非推奨 |
| 環境変数 SPARK_WORKER_PORT | 整数 | Workerのベースポート番号（未設定時は自動割り当て） |
| 環境変数 SPARK_WORKER_WEBUI_PORT | 整数 | WebUIのベースポート番号（デフォルト: 8081） |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| 標準出力 | テキスト | 起動メッセージ |
| PIDファイル | テキスト | 各Workerインスタンスのプロセスidファイル |
| ログファイル | テキスト | 各Workerインスタンスの出力ログ |

### 出力ファイル仕様

| 項目 | 内容 |
|-----|------|
| ファイル名 | spark-{SPARK_IDENT_STRING}-org.apache.spark.deploy.worker.Worker-{N}-{HOSTNAME}.out |
| 出力先 | ${SPARK_LOG_DIR}（デフォルト: ${SPARK_HOME}/logs） |
| 文字コード | システムデフォルト |
| 区切り文字 | 該当なし |

## 処理フロー

### 処理シーケンス

```
1. SPARK_HOME検出・設定
   └─ 環境変数が未設定の場合、スクリプト配置ディレクトリの親ディレクトリを設定
2. 引数チェック
   └─ 引数なし、--help / -h の場合はヘルプ表示して終了（引数なしの場合はexit 1）
3. 設定読み込み
   └─ spark-config.sh と load-spark-env.sh をsource
4. Master URL取得
   └─ 第1引数をMASTER変数に格納
5. WebUIポート設定
   └─ SPARK_WORKER_WEBUI_PORT（デフォルト8081）
6. インスタンス起動ループ
   └─ SPARK_WORKER_INSTANCES が未設定の場合は1インスタンス起動
   └─ 設定されている場合はN個のインスタンスを起動
7. 各インスタンスの起動（start_instance関数）
   ├─ ポート番号計算: SPARK_WORKER_PORT + (インスタンス番号 - 1)
   ├─ WebUIポート計算: SPARK_WORKER_WEBUI_PORT + (インスタンス番号 - 1)
   └─ spark-daemon.sh start Worker {インスタンス番号}
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B[SPARK_HOME設定]
    B --> C{引数チェック}
    C -->|引数なし or --help| D[ヘルプ表示・終了]
    C -->|正常| E[spark-config.sh読み込み]
    E --> F[load-spark-env.sh読み込み]
    F --> G[Master URL取得]
    G --> H[WebUIポートデフォルト設定]
    H --> I{SPARK_WORKER_INSTANCES設定?}
    I -->|未設定| J[start_instance 1]
    I -->|設定あり| K[ループ: i=0 to INSTANCES-1]
    K --> L[start_instance i+1]
    L --> K
    J --> M[バッチ終了]
    K -->|完了| M
```

## データベース操作仕様

### 操作別データベース影響一覧

本バッチはデータベース操作を行わない。

### テーブル別操作詳細

該当なし

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| 1 | 引数不足 | Master URLが指定されていない | 正しいMaster URLを指定して再実行 |
| 1 | 重複起動 | 同一インスタンス番号のWorkerが既に起動中 | stop-worker.shで停止後に再実行 |
| - | 起動失敗 | MasterへのRPC接続失敗 | Masterが起動していることを確認 |
| - | 起動失敗 | ポートバインド失敗 | ポートの競合を解消 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | なし |
| リトライ間隔 | 該当なし |
| リトライ対象エラー | 該当なし |

### 障害時対応

1. ログファイル（`${SPARK_LOG_DIR}/spark-*-org.apache.spark.deploy.worker.Worker-*.out`）を確認する
2. Master URLが正しいか確認する
3. ネットワーク接続を確認する

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | 該当なし（プロセス起動のため） |
| コミットタイミング | 該当なし |
| ロールバック条件 | 該当なし。複数インスタンス起動時、一部失敗しても他のインスタンスの起動は試行される |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 1〜SPARK_WORKER_INSTANCESプロセス |
| 目標処理時間 | 数秒（インスタンス数に依存） |
| メモリ使用量上限 | シェルスクリプト自体は最小限。Workerプロセスのメモリはspark-env.shで設定 |

## 排他制御

spark-daemon.sh がPIDファイルによる排他制御を実施する。各インスタンスは固有のインスタンス番号（1〜N）を持ち、それぞれ独立したPIDファイルで管理される。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 起動ログ | 各インスタンス起動時 | "starting org.apache.spark.deploy.worker.Worker, logging to {ログパス}" |
| エラーログ | 起動失敗時 | "failed to launch: {コマンド}" + ログ末尾10行 |
| 重複起動ログ | 既存プロセス検出時 | "org.apache.spark.deploy.worker.Worker running as process {PID}. Stop it first." |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| Workerプロセス存在 | PIDファイル + psコマンド | 運用者（手動確認） |
| WebUI応答 | ポート8081〜のHTTP応答 | 運用者（手動確認） |

## 備考

- `SPARK_WORKER_INSTANCES` はSpark 3.0以降で非推奨（deprecated）である。ソースコードのコメントに記載あり
- 起動クラス名 `org.apache.spark.deploy.worker.Worker` はSparkSubmitでも参照されるため、変更時は整合性に注意が必要
- SPARK_WORKER_PORT が未設定の場合、ポートは自動割り当てとなり予測可能なパターンは保証されない
- 複数インスタンス起動時、ポート番号はベースポートからインクリメントされる
