# バッチ設計書 6-stop-worker.sh

## 概要

本ドキュメントは、ローカルノードの全Workerインスタンスを停止するシェルスクリプト `stop-worker.sh` のバッチ設計書である。

### 本バッチの処理概要

`stop-worker.sh` は、ローカルノードで稼働中のすべてのSpark Workerデーモン（`org.apache.spark.deploy.worker.Worker`）を停止するスクリプトである。`SPARK_WORKER_INSTANCES` 環境変数に応じて、1つまたは複数のWorkerインスタンスを順番に停止する。

**業務上の目的・背景**：Sparkクラスタの運用において、個別ノードのWorkerを安全に停止する必要がある。本バッチは `start-worker.sh` と対になる停止用スクリプトであり、PIDファイルを用いた確実なプロセス停止を行う。複数インスタンスが稼働している場合も、すべてのインスタンスを順次停止する。

**バッチの実行タイミング**：手動実行。通常は `stop-workers.sh`（No.8）経由でSSHリモート実行されるか、個別ノードで直接実行する。

**主要な処理内容**：
1. SPARK_HOMEが未設定の場合、スクリプトの配置ディレクトリから自動検出する
2. `spark-config.sh` および `load-spark-env.sh` をsourceして設定を初期化する
3. `SPARK_WORKER_INSTANCES` が未設定の場合はインスタンス1のWorkerを停止する
4. `SPARK_WORKER_INSTANCES` が設定されている場合はインスタンス1〜Nまで順次停止する
5. 各インスタンスの停止は `spark-daemon.sh stop` 経由で行う

**前後の処理との関連**：`stop-workers.sh`（No.8）から `workers.sh` 経由でリモート呼び出しされる。`stop-all.sh`（No.2）の一部として実行される。起動は `start-worker.sh`（No.5）で行う。

**影響範囲**：ローカルノードの全Workerデーモンプロセスが停止する。実行中のタスクがある場合は中断される可能性がある。

## バッチ種別

デーモン管理（Workerデーモン停止）

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 随時 |
| 実行時刻 | 任意 |
| 実行曜日 | 該当なし |
| 実行日 | 該当なし |
| トリガー | 手動 / stop-workers.shからのSSHリモート呼び出し |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| SPARK_HOME | SPARK_HOMEが設定済み、または自動検出可能であること |
| Workerが起動済み | Workerデーモンが起動中であること（未起動でもエラーにはならない） |

### 実行可否判定

特段の判定ロジックはなし。各インスタンスの停止時に、spark-daemon.shがPIDファイルの存在とプロセスの存在を確認する。

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| なし | - | - | - | 本スクリプトはコマンドライン引数を受け取らない |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| 環境変数 SPARK_WORKER_INSTANCES | 整数 | 停止するWorkerインスタンス数（デフォルト: 1） |
| PIDファイル | テキスト | 各Workerインスタンスのプロセスidファイル |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| 標準出力 | テキスト | 停止メッセージ |

### 出力ファイル仕様

| 項目 | 内容 |
|-----|------|
| ファイル名 | PIDファイルが削除される |
| 出力先 | ${SPARK_PID_DIR}（デフォルト: /tmp） |
| 文字コード | 該当なし |
| 区切り文字 | 該当なし |

## 処理フロー

### 処理シーケンス

```
1. SPARK_HOME検出・設定
   └─ 環境変数が未設定の場合、スクリプト配置ディレクトリの親ディレクトリを設定
2. 設定読み込み
   └─ spark-config.sh と load-spark-env.sh をsource
3. インスタンス停止
   └─ SPARK_WORKER_INSTANCES 未設定: spark-daemon.sh stop Worker 1
   └─ SPARK_WORKER_INSTANCES 設定: ループで spark-daemon.sh stop Worker {1〜N}
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B[SPARK_HOME設定]
    B --> C[spark-config.sh読み込み]
    C --> D[load-spark-env.sh読み込み]
    D --> E{SPARK_WORKER_INSTANCES設定?}
    E -->|未設定| F[spark-daemon.sh stop Worker 1]
    E -->|設定あり| G[ループ: i=0 to INSTANCES-1]
    G --> H[spark-daemon.sh stop Worker i+1]
    H --> G
    F --> I[バッチ終了]
    G -->|完了| I
```

## データベース操作仕様

### 操作別データベース影響一覧

本バッチはデータベース操作を行わない。

### テーブル別操作詳細

該当なし

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | 停止対象なし | PIDファイルがない、またはプロセスが存在しない | "no {command} to stop" と出力されるのみ |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | なし |
| リトライ間隔 | 該当なし |
| リトライ対象エラー | 該当なし |

### 障害時対応

1. killシグナルでプロセスが停止しない場合、`kill -9` で強制停止する
2. PIDファイルが残っているがプロセスが存在しない場合、PIDファイルを手動削除する

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | 該当なし（プロセス停止のため） |
| コミットタイミング | 該当なし |
| ロールバック条件 | 該当なし |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 1〜SPARK_WORKER_INSTANCESプロセス |
| 目標処理時間 | 即時（killシグナル送信のみ） |
| メモリ使用量上限 | シェルスクリプト自体は最小限 |

## 排他制御

各インスタンスのPIDファイルを参照して停止する。停止処理完了後にPIDファイルを削除することで、次回の起動が可能になる。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 停止ログ | 各インスタンス停止時 | "stopping org.apache.spark.deploy.worker.Worker" |
| 不在ログ | デーモン未起動時 | "no org.apache.spark.deploy.worker.Worker to stop" |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| Worker停止確認 | 全インスタンスのプロセス不在 | 運用者（手動確認） |

## 備考

- `SPARK_WORKER_INSTANCES` の値は `start-worker.sh` 起動時と一致している必要がある。不一致の場合、一部のインスタンスが停止されない可能性がある
- killシグナルはデフォルトのSIGTERMが使用される
