# バッチ設計書 7-start-workers.sh

## 概要

本ドキュメントは、`conf/workers` に記載された全ノードでWorkerデーモンを起動するシェルスクリプト `start-workers.sh` のバッチ設計書である。

### 本バッチの処理概要

`start-workers.sh` は、Sparkクラスタに属する全Workerノードに対して、SSH経由でWorkerデーモンの起動コマンドをリモート実行するスクリプトである。`workers.sh` ユーティリティを使用して `conf/workers` ファイルに記載された各ホストにSSH接続し、`start-worker.sh` を実行する。MasterのURLは環境変数から自動構築される。

**業務上の目的・背景**：Sparkクラスタの全Workerノードを個別にSSH接続して起動するのは非効率で、オペレーションミスの原因にもなる。本バッチはMasterのホスト名とポートを自動検出し、全Workerノードへの一括起動を実現する。クラスタ全体の起動プロセスを標準化する重要なスクリプトである。

**バッチの実行タイミング**：手動実行。通常は `start-all.sh`（No.1）から呼び出されるか、Worker群のみを起動する場合に直接実行する。

**主要な処理内容**：
1. SPARK_HOMEが未設定の場合、スクリプトの配置ディレクトリから自動検出する
2. `spark-config.sh` および `load-spark-env.sh` をsourceして設定を初期化する
3. SPARK_MASTER_PORT（デフォルト: 7077）およびSPARK_MASTER_HOST（デフォルト: hostname -f）を設定する
4. `workers.sh` を呼び出し、各Workerノードで `start-worker.sh spark://{MASTER_HOST}:{MASTER_PORT}` を実行する

**前後の処理との関連**：`start-all.sh`（No.1）から呼び出される。Master（`start-master.sh` No.3）が事前に起動されている必要がある。各ノードでは `start-worker.sh`（No.5）が実行される。停止は `stop-workers.sh`（No.8）で行う。

**影響範囲**：`conf/workers` に記載された全ノードでWorkerデーモンが起動される。各ノードへのSSH接続が発生する。

## バッチ種別

デーモン管理（全Worker一括起動）

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 随時 |
| 実行時刻 | 任意 |
| 実行曜日 | 該当なし |
| 実行日 | 該当なし |
| トリガー | 手動 / start-all.shからの呼び出し |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| SPARK_HOME | SPARK_HOMEが設定済み、または自動検出可能であること |
| Master起動済み | MasterデーモンがSPARK_MASTER_HOST:SPARK_MASTER_PORTで稼働していること |
| SSH接続 | Masterノードから各WorkerノードへのパスワードなしSSH接続が可能であること |
| conf/workers | `conf/workers` ファイルにWorkerノードのホスト名が記載されていること |

### 実行可否判定

特段の判定ロジックはなし。各ノードでの `start-worker.sh` 実行時に、spark-daemon.sh がPIDファイルによる排他制御を行う。

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| なし | - | - | - | 本スクリプトはコマンドライン引数を受け取らない |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| conf/workers | テキストファイル | Workerノードのホスト名一覧。1行1ホスト。#でコメント行 |
| 環境変数 SPARK_MASTER_PORT | 整数 | Masterポート番号（デフォルト: 7077） |
| 環境変数 SPARK_MASTER_HOST | 文字列 | Masterホスト名（デフォルト: hostname -f） |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| 標準出力 | テキスト | 各ノードの起動メッセージ（ホスト名プレフィックス付き） |

### 出力ファイル仕様

| 項目 | 内容 |
|-----|------|
| ファイル名 | 各ノードのPIDファイルおよびログファイル（リモートノード上に作成される） |
| 出力先 | 各ノードの ${SPARK_LOG_DIR} / ${SPARK_PID_DIR} |
| 文字コード | システムデフォルト |
| 区切り文字 | 該当なし |

## 処理フロー

### 処理シーケンス

```
1. SPARK_HOME検出・設定
   └─ 環境変数が未設定の場合、スクリプト配置ディレクトリの親ディレクトリを設定
2. 設定読み込み
   └─ spark-config.sh と load-spark-env.sh をsource
3. Master情報構築
   ├─ SPARK_MASTER_PORT（デフォルト7077）
   └─ SPARK_MASTER_HOST（デフォルトhostname -f、SunOSの場合check-hostname）
4. Worker一括起動
   └─ workers.sh cd {SPARK_HOME} ; start-worker.sh spark://{HOST}:{PORT}
      ├─ conf/workersからホスト一覧読み込み
      ├─ 各ホストにSSH接続
      └─ バックグラウンドで並行実行（デフォルト）
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B[SPARK_HOME設定]
    B --> C[spark-config.sh読み込み]
    C --> D[load-spark-env.sh読み込み]
    D --> E[SPARK_MASTER_PORT設定 デフォルト7077]
    E --> F[SPARK_MASTER_HOST設定 デフォルトhostname -f]
    F --> G[workers.sh経由で全ノードにSSH実行]
    G --> H[各ノード: cd SPARK_HOME && start-worker.sh spark://HOST:PORT]
    H --> I[バッチ終了]
```

## データベース操作仕様

### 操作別データベース影響一覧

本バッチはデータベース操作を行わない。

### テーブル別操作詳細

該当なし

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | SSH接続失敗 | Workerノードへの接続不可 | SSH設定・ネットワーク接続を確認 |
| - | Worker起動失敗 | 各ノードでのstart-worker.sh実行失敗 | 対象ノードのログファイルを確認 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | なし |
| リトライ間隔 | 該当なし |
| リトライ対象エラー | 該当なし |

### 障害時対応

1. 一部ノードでWorkerが起動しない場合、対象ノードに個別SSHしてログを確認する
2. 全ノード停止後、`start-workers.sh` で再実行する

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | 該当なし |
| コミットタイミング | 該当なし |
| ロールバック条件 | 該当なし。一部ノードで失敗しても他のノードの起動は継続される |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | conf/workersのノード数 |
| 目標処理時間 | 数秒〜数十秒（ノード数とSSH応答時間に依存） |
| メモリ使用量上限 | シェルスクリプト自体は最小限 |

## 排他制御

各ノードの spark-daemon.sh がローカルのPIDファイルで排他制御を行う。本スクリプト自体には排他制御メカニズムはない。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| SSH出力 | 各ノード実行時 | "{ホスト名}: starting org.apache.spark.deploy.worker.Worker..." |
| エラー出力 | SSH失敗時 | SSHのエラーメッセージ |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| 全Worker起動確認 | 全ノードでプロセス存在 | 運用者（手動確認） |

## 備考

- SunOS環境では `/usr/sbin/check-hostname` でホスト名を取得する特別処理がある
- workers.sh はデフォルトでバックグラウンド実行（並行SSH）を行い、全接続完了を `wait` で待機する
- SPARK_SSH_OPTS のデフォルトは `-o StrictHostKeyChecking=no` である
- SPARK_WORKER_SLEEP で各ノードのSSH接続間にスリープを挿入可能
