# バッチ設計書 8-stop-workers.sh

## 概要

本ドキュメントは、`conf/workers` に記載された全ノードでWorkerデーモンを停止するシェルスクリプト `stop-workers.sh` のバッチ設計書である。

### 本バッチの処理概要

`stop-workers.sh` は、Sparkクラスタに属する全Workerノードに対して、SSH経由でWorkerデーモンの停止コマンドをリモート実行するスクリプトである。`workers.sh` ユーティリティを使用して `conf/workers` ファイルに記載された各ホストにSSH接続し、`stop-worker.sh` を実行する。

**業務上の目的・背景**：Sparkクラスタの全Workerノードを一括停止する必要がある。本バッチは `start-workers.sh` と対になる停止用スクリプトであり、全ノードへのSSH接続と停止コマンドの配信を自動化する。クラスタ全体の安全な停止プロセスを標準化する。

**バッチの実行タイミング**：手動実行。通常は `stop-all.sh`（No.2）から呼び出されるか、Worker群のみを停止する場合に直接実行する。

**主要な処理内容**：
1. SPARK_HOMEが未設定の場合、スクリプトの配置ディレクトリから自動検出する
2. `spark-config.sh` および `load-spark-env.sh` をsourceして設定を初期化する
3. `workers.sh` を呼び出し、各Workerノードで `stop-worker.sh` を実行する

**前後の処理との関連**：`stop-all.sh`（No.2）から呼び出される。`stop-all.sh` ではWorker停止（本バッチ）の後にMaster停止（`stop-master.sh` No.4）が実行される。各ノードでは `stop-worker.sh`（No.6）が実行される。起動は `start-workers.sh`（No.7）で行う。

**影響範囲**：`conf/workers` に記載された全ノードのWorkerデーモンプロセスが停止される。各ノードへのSSH接続が発生する。

## バッチ種別

デーモン管理（全Worker一括停止）

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 随時 |
| 実行時刻 | 任意 |
| 実行曜日 | 該当なし |
| 実行日 | 該当なし |
| トリガー | 手動 / stop-all.shからの呼び出し |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| SPARK_HOME | SPARK_HOMEが設定済み、または自動検出可能であること |
| SSH接続 | Masterノードから各WorkerノードへのパスワードなしSSH接続が可能であること |
| conf/workers | `conf/workers` ファイルにWorkerノードのホスト名が記載されていること |

### 実行可否判定

特段の判定ロジックはなし。各ノードでの `stop-worker.sh` 実行時に、spark-daemon.sh がPIDファイルを確認する。デーモンが未起動でもエラーにはならない。

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| なし | - | - | - | 本スクリプトはコマンドライン引数を受け取らない |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| conf/workers | テキストファイル | Workerノードのホスト名一覧 |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| 標準出力 | テキスト | 各ノードの停止メッセージ（ホスト名プレフィックス付き） |

### 出力ファイル仕様

| 項目 | 内容 |
|-----|------|
| ファイル名 | 各ノードのPIDファイルが削除される |
| 出力先 | 各ノードの ${SPARK_PID_DIR} |
| 文字コード | 該当なし |
| 区切り文字 | 該当なし |

## 処理フロー

### 処理シーケンス

```
1. SPARK_HOME検出・設定
   └─ 環境変数が未設定の場合、スクリプト配置ディレクトリの親ディレクトリを設定
2. 設定読み込み
   └─ spark-config.sh と load-spark-env.sh をsource
3. Worker一括停止
   └─ workers.sh cd {SPARK_HOME} ; stop-worker.sh
      ├─ conf/workersからホスト一覧読み込み
      ├─ 各ホストにSSH接続
      └─ バックグラウンドで並行実行（デフォルト）
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B[SPARK_HOME設定]
    B --> C[spark-config.sh読み込み]
    C --> D[load-spark-env.sh読み込み]
    D --> E[workers.sh経由で全ノードにSSH実行]
    E --> F[各ノード: cd SPARK_HOME && stop-worker.sh]
    F --> G[バッチ終了]
```

## データベース操作仕様

### 操作別データベース影響一覧

本バッチはデータベース操作を行わない。

### テーブル別操作詳細

該当なし

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | SSH接続失敗 | Workerノードへの接続不可 | SSH設定・ネットワーク接続を確認 |
| - | 停止対象なし | 各ノードでWorkerが起動していない | 正常系として扱われる |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | なし |
| リトライ間隔 | 該当なし |
| リトライ対象エラー | 該当なし |

### 障害時対応

1. 一部ノードで停止できない場合、対象ノードに個別SSHしてプロセスを確認する
2. PIDファイルが残っている場合は手動削除する

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | 該当なし |
| コミットタイミング | 該当なし |
| ロールバック条件 | 該当なし |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | conf/workersのノード数 |
| 目標処理時間 | 数秒〜数十秒（ノード数とSSH応答時間に依存） |
| メモリ使用量上限 | シェルスクリプト自体は最小限 |

## 排他制御

各ノードの spark-daemon.sh がローカルのPIDファイルで停止処理を行う。本スクリプト自体には排他制御メカニズムはない。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| SSH出力 | 各ノード実行時 | "{ホスト名}: stopping org.apache.spark.deploy.worker.Worker" |
| 不在出力 | Worker未起動時 | "{ホスト名}: no org.apache.spark.deploy.worker.Worker to stop" |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| 全Worker停止確認 | 全ノードでプロセス不在 | 運用者（手動確認） |

## 備考

- workers.sh はデフォルトでバックグラウンド実行（並行SSH）を行い、全接続完了を `wait` で待機する
- デーモンが起動していないノードに対して実行しても安全である
- stop-all.shの--waitオプションと組み合わせることで、全Workerの完全停止を確認できる
