# バッチ設計書 9-decommission-worker.sh

## 概要

本ドキュメントは、ローカルノードのWorkerをデコミッション（安全停止）するシェルスクリプト `decommission-worker.sh` のバッチ設計書である。

### 本バッチの処理概要

`decommission-worker.sh` は、ローカルノードで稼働中のすべてのSpark Workerデーモンに対してデコミッション（graceful shutdown / 安全停止）を行うスクリプトである。通常の `stop-worker.sh` がSIGTERMで即座に停止するのに対し、本バッチはSIGPWRシグナルを送信してWorkerのデコミッションプロセスを開始する。これにより、実行中のタスクを安全に移行・完了させてからWorkerを停止できる。`--block-until-exit` オプションにより、Kubernetes環境でのPod終了待機にも対応する。

**業務上の目的・背景**：Sparkクラスタの運用において、ノードの縮退やメンテナンス時に実行中のタスクを中断せずWorkerを安全に停止する必要がある。デコミッションはWorkerが新たなタスクの受付を停止し、既存タスクの完了または移行を待ってから終了するグレースフルシャットダウンメカニズムである。特にKubernetes環境でのPodの安全な終了に重要な役割を果たす。

**バッチの実行タイミング**：手動実行。クラスタのスケールダウン、ノードメンテナンス、Kubernetes環境でのPod終了時に実行する。

**主要な処理内容**：
1. SPARK_HOMEが未設定の場合、スクリプトの配置ディレクトリから自動検出する
2. `spark-config.sh` および `load-spark-env.sh` をsourceして設定を初期化する
3. `SPARK_WORKER_INSTANCES` に応じて1つまたは複数のWorkerインスタンスにデコミッションを実行する
4. 各インスタンスに対して `spark-daemon.sh decommission` を呼び出す（SIGPWRシグナル送信）
5. `--block-until-exit` オプション指定時は、Workerプロセスの終了を待機する

**前後の処理との関連**：本バッチは独立して使用される。`stop-worker.sh`（No.6）の代替として、より安全な停止が必要な場合に使用する。

**影響範囲**：ローカルノードの全Workerデーモンプロセスにデコミッションシグナルが送信される。Worker上で実行中のタスクは移行または完了後にプロセスが終了する。

## バッチ種別

デーモン管理（Workerデコミッション / 安全停止）

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 随時 |
| 実行時刻 | 任意 |
| 実行曜日 | 該当なし |
| 実行日 | 該当なし |
| トリガー | 手動 / Kubernetes Pod終了フック |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| SPARK_HOME | SPARK_HOMEが設定済み、または自動検出可能であること |
| Workerが起動済み | Workerデーモンが起動中であること（未起動の場合はメッセージ出力のみ） |

### 実行可否判定

spark-daemon.sh がPIDファイルの存在とプロセスの存在を確認する。PIDファイルがない場合やプロセスが存在しない場合は "no org.apache.spark.deploy.worker.Worker to decommission" と出力するのみ。

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| --block-until-exit | フラグ | No | - | Workerプロセスの終了を待機する。K8s環境向け |
| インスタンス番号 | 整数 | No | - | --block-until-exit 指定時、待機するインスタンス番号（第2引数） |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| 環境変数 SPARK_WORKER_INSTANCES | 整数 | デコミッションするWorkerインスタンス数（デフォルト: 1） |
| PIDファイル | テキスト | 各Workerインスタンスのプロセスidファイル |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| 標準出力 | テキスト | デコミッションメッセージ |
| 標準エラー出力 | テキスト | set -exによるコマンドトレース |

### 出力ファイル仕様

| 項目 | 内容 |
|-----|------|
| ファイル名 | PIDファイルは保持される（デコミッション中はプロセスが存続するため） |
| 出力先 | ${SPARK_PID_DIR}（デフォルト: /tmp） |
| 文字コード | 該当なし |
| 区切り文字 | 該当なし |

## 処理フロー

### 処理シーケンス

```
1. SPARK_HOME検出・設定
   └─ 環境変数が未設定の場合、スクリプト配置ディレクトリの親ディレクトリを設定
2. 設定読み込み
   └─ spark-config.sh と load-spark-env.sh をsource
3. インスタンスデコミッション
   └─ SPARK_WORKER_INSTANCES 未設定: spark-daemon.sh decommission Worker 1
   └─ SPARK_WORKER_INSTANCES 設定: ループで spark-daemon.sh decommission Worker {1〜N}
4. プロセス終了待機（--block-until-exit指定時のみ）
   └─ 指定されたインスタンスのPIDに対してwait実行
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始 set -ex] --> B[SPARK_HOME設定]
    B --> C[spark-config.sh読み込み]
    C --> D[load-spark-env.sh読み込み]
    D --> E{SPARK_WORKER_INSTANCES設定?}
    E -->|未設定| F[spark-daemon.sh decommission Worker 1]
    E -->|設定あり| G[ループ: i=0 to INSTANCES-1]
    G --> H[spark-daemon.sh decommission Worker i+1]
    H --> G
    F --> I{--block-until-exit?}
    G -->|完了| I
    I -->|はい| J[PIDファイルからプロセスID取得]
    J --> K[wait PID]
    K --> L[バッチ終了]
    I -->|いいえ| L
```

## データベース操作仕様

### 操作別データベース影響一覧

本バッチはデータベース操作を行わない。

### テーブル別操作詳細

該当なし

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | デコミッション対象なし | PIDファイルがない、またはプロセスが存在しない | "no {command} to decommission" と出力されるのみ |
| - | 待機失敗 | --block-until-exit でPIDファイルパス構築の変数未定義 | 環境変数SPARK_PID_DIR等を確認 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | なし |
| リトライ間隔 | 該当なし |
| リトライ対象エラー | 該当なし |

### 障害時対応

1. デコミッションが進まない場合、`stop-worker.sh` でSIGTERMによる通常停止を試みる
2. それでも停止しない場合、`kill -9` で強制停止する

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | 該当なし |
| コミットタイミング | 該当なし |
| ロールバック条件 | 該当なし |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 1〜SPARK_WORKER_INSTANCESプロセス |
| 目標処理時間 | デコミッションプロセス自体は数秒。タスク完了までの待機時間は実行中のタスクに依存 |
| メモリ使用量上限 | シェルスクリプト自体は最小限 |

## 排他制御

デコミッション中はPIDファイルが保持される。プロセスが完全に終了した後にのみPIDファイルが不要になる。同一インスタンスへの重複デコミッション要求は、既にデコミッション中のプロセスに再度SIGPWRを送信する。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| デコミッションログ | シグナル送信時 | "decommissioning org.apache.spark.deploy.worker.Worker" |
| 不在ログ | デーモン未起動時 | "no org.apache.spark.deploy.worker.Worker to decommission" |
| トレースログ | 全コマンド実行時 | set -exによるコマンドトレース（標準エラー出力） |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| デコミッション完了確認 | プロセス終了 | 運用者（手動確認） |
| デコミッション所要時間 | 運用ポリシーに依存 | 運用者（手動確認） |

## 備考

- 本スクリプトは `set -ex` が設定されており、全コマンドがトレース出力される。また、エラー発生時は即座にスクリプトが終了する
- デコミッションはSIGPWRシグナル（`kill -s SIGPWR`）で実装されている。これはSpark独自のシグナルハンドリングである
- `--block-until-exit` オプションは主にKubernetes環境向けで、Podの終了フックとして使用される。Podの終了時にWorkerが安全に停止するまでコンテナを維持する
- PIDファイルはデコミッション開始時点では削除されない（通常のstopとの違い）
- 複数インスタンス時の`--block-until-exit`は0番目のインスタンスのみを待機する（ソースコードコメント記載あり）
