---
generated_at: 2026-02-04 10:00:00
metrics:
  claims_total: 12
  claims_with_evidence: 12
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：1-start-all.sh バッチ設計書

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：12 / 12、根拠なし：0
- 優先レビュー（高）
  - なし（全主張に根拠あり）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。

- E-01: `sbin/start-all.sh`（ソースコード）
- E-02: `sbin/spark-config.sh`（ソースコード）
- E-03: `sbin/start-master.sh`（ソースコード）
- E-04: `sbin/start-workers.sh`（ソースコード）
- E-05: `sbin/spark-daemon.sh`（ソースコード）
- E-06: `sbin/workers.sh`（ソースコード）
- E-07: `docs/code-to-docs/バッチ一覧/バッチ一覧.csv`（バッチ一覧）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | start-all.shは全デーモンを一括起動する | E-01 L20-22, L32-35 | ○ |
| C-02 | SPARK_HOMEが未設定の場合自動検出する | E-01 L24-26 | ○ |
| C-03 | spark-config.shをsourceして設定初期化する | E-01 L29, E-02 | ○ |
| C-04 | start-master.shを呼び出してMasterを起動する | E-01 L32 | ○ |
| C-05 | start-workers.shを呼び出してWorkerを起動する | E-01 L35 | ○ |
| C-06 | Masterのデフォルトポートは7077 | E-03 L48 | ○ |
| C-07 | MasterのWebUIデフォルトポートは8080 | E-03 L62-64 | ○ |
| C-08 | WorkerのWebUIデフォルトポートは8081 | E-04 (start-workers.sh -> start-worker.sh L63-65) | ○ |
| C-09 | PIDファイルによる排他制御を実施 | E-05 L171-177 | ○ |
| C-10 | ログローテーション機能がある | E-05 L75-96 | ○ |
| C-11 | Workers起動はSSH経由で行われる | E-06 L103-110 | ○ |
| C-12 | conf/workersからホスト一覧を読み込む | E-06 L76-94 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし。全主張に対してソースコードから根拠が確認できた。

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 単純なオーケストレーションスクリプトであり、内部処理は子スクリプトに委譲されている

## 6) レビュアーチェックリスト（最小）
- [ ] start-master.shとstart-workers.shの呼び出し順序が正しいことを確認
- [ ] クラスタ構成に応じたconf/workersファイルの設定が適切か確認
- [ ] SSH接続の前提条件が運用環境で満たされているか確認
