---
generated_at: 2026-02-04 10:45:00
metrics:
  claims_total: 14
  claims_with_evidence: 13
  claims_without_evidence: 1
confidence_derived: 0.93
---

# 根拠レポート：10-start-history-server.sh バッチ設計書

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.93**
  - 根拠あり：13 / 14、根拠なし：1
- 優先レビュー（高）
  1. **History Serverのデフォルトポート18080**：シェルスクリプト内では明示的に設定されておらず、Javaクラス内部の設定に依存

## 2) 参照した情報（Evidence一覧）

- E-01: `sbin/start-history-server.sh`（ソースコード）
- E-02: `sbin/spark-config.sh`（ソースコード）
- E-03: `sbin/spark-daemon.sh`（ソースコード）
- E-04: `docs/code-to-docs/バッチ一覧/バッチ一覧.csv`（バッチ一覧）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 起動クラスはorg.apache.spark.deploy.history.HistoryServer | E-01 L33 | ○ |
| C-02 | --help/-hでヘルプ表示 | E-01 L35-44 | ○ |
| C-03 | spark-config.shをsourceする | E-01 L46 | ○ |
| C-04 | load-spark-env.shをsourceする | E-01 L47 | ○ |
| C-05 | execでspark-daemon.shを呼び出す | E-01 L49 | ○ |
| C-06 | spark-daemon.sh start経由で起動する | E-01 L49 | ○ |
| C-07 | インスタンス番号は1固定 | E-01 L49 | ○ |
| C-08 | コマンドライン引数はそのままHistoryServerに渡される | E-01 L49 ("$@") | ○ |
| C-09 | SPARK_HISTORY_OPTSでHistory Server設定が可能 | E-01 L24 | ○ |
| C-10 | PIDファイルによる排他制御 | E-03 L171-177 | ○ |
| C-11 | クラス名はSparkSubmitでも参照される | E-01 L32 | ○ |
| C-12 | start-all.shには含まれていない | sbin/start-all.sh（HistoryServer呼び出しなし） | ○ |
| C-13 | execにより余分なシェルプロセスが残らない | E-01 L49 (exec使用) | ○ |
| C-14 | デフォルトWebUIポートは18080 | **根拠なし**（シェルスクリプト内に明示なし） | △ |

## 4) 不足情報（Unknown / Missing）
- C-14: History Serverのデフォルトポート18080はシェルスクリプト内には明示されていない。この値はSparkのJavaクラス（HistoryServer）の内部デフォルト値であり、シェルスクリプトのみからは確認できない。Spark公式ドキュメントやJavaソースコードの確認が必要。
  - 候補：`org.apache.spark.deploy.history.HistoryServer` Javaソースコード / Spark公式ドキュメント / spark-defaults.conf

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - ポート番号はSparkの広く知られたデフォルト値であり、公式ドキュメントで確認可能

## 6) レビュアーチェックリスト（最小）
- [ ] History ServerのデフォルトWebUIポート（18080）が運用環境で使用可能か確認
- [ ] spark.history.fs.logDirectoryの設定が正しいか確認
- [ ] SPARK_HISTORY_OPTSの設定（メモリ等）が適切か確認
- [ ] exec使用によるプロセス置換の影響がないか確認
