---
generated_at: 2026-02-04 10:05:00
metrics:
  claims_total: 15
  claims_with_evidence: 15
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：12-start-thriftserver.sh

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：15 / 15、根拠なし：0
- 優先レビュー（高）
  - 特になし（全主張に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `sbin/start-thriftserver.sh`（ソースコード）
- E-02: `sbin/spark-daemon.sh`（ソースコード・デーモン管理の実装）
- E-03: `sbin/stop-thriftserver.sh`（ソースコード・停止スクリプトとの対応確認）
- E-04: `bin/spark-submit`（ソースコード）
- E-05: `docs/code-to-docs/バッチ一覧/バッチ一覧.csv`（バッチ定義）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | Thrift JDBC/ODBCサーバーを起動するスクリプトである | E-01（21行目コメント、61行目）、E-05 | ○ |
| C-02 | SPARK_CONNECT_MODE=0を設定する | E-01（22行目） | ○ |
| C-03 | POSIXモードを有効化する（set -o posix） | E-01（25行目） | ○ |
| C-04 | SPARK_HOME未設定時にスクリプト配置場所から自動検出する | E-01（27-29行目） | ○ |
| C-05 | 起動クラスはorg.apache.spark.sql.hive.thriftserver.HiveThriftServer2 | E-01（33行目） | ○ |
| C-06 | --help/-hオプションでusage関数を呼び出す | E-01（54-57行目） | ○ |
| C-07 | usage関数はspark-submitのヘルプとHiveThriftServer2のヘルプを表示する | E-01（35-52行目） | ○ |
| C-08 | SUBMIT_USAGE_FUNCTION環境変数を設定する | E-01（59行目） | ○ |
| C-09 | spark-daemon.shのsubmitモードで起動する | E-01（61行目） | ○ |
| C-10 | インスタンス番号は固定値1 | E-01（61行目の引数） | ○ |
| C-11 | アプリケーション名は「Thrift JDBC/ODBC Server」 | E-01（61行目の--name引数） | ○ |
| C-12 | execコマンドでspark-daemon.shを呼び出す | E-01（61行目のexec） | ○ |
| C-13 | 既存プロセス稼働中は起動を拒否する | E-02（171-177行目） | ○ |
| C-14 | PIDファイルでプロセスを管理する | E-02（130行目、142行目） | ○ |
| C-15 | クラス名はSparkSubmit内部でマッチングされる | E-01（31-32行目のコメント） | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - ソースコードから全ての主張を直接確認可能

## 6) レビュアーチェックリスト（最小）
- [ ] Hive関連の依存JARがクラスパスに含まれることを実環境で確認
- [ ] Thriftサーバーのデフォルトポート番号（10000）等のネットワーク設定が運用環境と整合しているか確認
- [ ] SPARK_CONNECT_MODE=0の設定がstart-connect-server.shとの使い分けに影響しないか確認
