---
generated_at: 2026-02-04 10:15:00
metrics:
  claims_total: 16
  claims_with_evidence: 15
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：14-start-connect-server.sh

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：15 / 16、根拠なし：1
- 優先レビュー（高）
  1. **デフォルトポート番号**：gRPCのデフォルトポートについてソースコードからの直接的な根拠なし

## 2) 参照した情報（Evidence一覧）

- E-01: `sbin/start-connect-server.sh`（ソースコード）
- E-02: `sbin/spark-daemon.sh`（ソースコード・デーモン管理の実装）
- E-03: `sbin/stop-connect-server.sh`（ソースコード・停止スクリプトとの対応確認）
- E-04: `bin/load-spark-env.sh`（ソースコード）
- E-05: `docs/code-to-docs/バッチ一覧/バッチ一覧.csv`（バッチ定義）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | Spark Connectサーバーを起動するスクリプトである | E-01（24行目コメント、46行目）、E-05 | ○ |
| C-02 | SPARK_CONNECT_MODE=0を設定する | E-01（19行目） | ○ |
| C-03 | POSIXモードを有効化する（set -o posix） | E-01（22行目） | ○ |
| C-04 | SPARK_HOME未設定時にスクリプト配置場所から自動検出する | E-01（25-27行目） | ○ |
| C-05 | 起動クラスはorg.apache.spark.sql.connect.service.SparkConnectServer | E-01（31行目） | ○ |
| C-06 | --help/-hオプションで使用方法を表示する | E-01（33-38行目） | ○ |
| C-07 | load-spark-env.shを読み込む | E-01（40行目） | ○ |
| C-08 | --waitオプションでSPARK_NO_DAEMONIZE=1を設定する | E-01（42-45行目） | ○ |
| C-09 | spark-daemon.shのsubmitモードで起動する | E-01（46行目） | ○ |
| C-10 | インスタンス番号は固定値1 | E-01（46行目の引数） | ○ |
| C-11 | アプリケーション名は「Spark Connect server」 | E-01（46行目の--name引数） | ○ |
| C-12 | execコマンドでspark-daemon.shを呼び出す | E-01（46行目のexec） | ○ |
| C-13 | 既存プロセス稼働中は起動を拒否する | E-02（171-177行目） | ○ |
| C-14 | --waitオプション使用時はPIDファイルが生成されない | E-02（138行目のSPARK_NO_DAEMONIZE判定） | ○ |
| C-15 | クラス名はSparkSubmit内部でマッチングされる | E-01（29-30行目のコメント） | ○ |
| C-16 | デフォルトではポート15002でgRPCリクエストを待ち受ける | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- デフォルトポート番号15002の記載は、シェルスクリプトのソースコードには存在しない。SparkConnectServerのJavaソースコードを確認する必要がある。
  - 候補：`org.apache.spark.sql.connect.service.SparkConnectServer` のソースコード / Spark公式ドキュメント / Spark設定ファイル

## 5) リスクフラグ（レビュー観点）
- 1: 中リスク - デフォルトポート番号の根拠がシェルスクリプトからは確認できない

## 6) レビュアーチェックリスト（最小）
- [ ] デフォルトポート番号（15002）がSpark Connectサーバーの実際のデフォルト値と一致するか確認
- [ ] --waitオプションのKubernetes環境での使用方法が運用ドキュメントに記載されているか確認
- [ ] Spark Connect関連の依存JARがクラスパスに含まれることを実環境で確認
