---
generated_at: 2026-02-04 10:20:00
metrics:
  claims_total: 13
  claims_with_evidence: 13
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：15-stop-connect-server.sh

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：13 / 13、根拠なし：0
- 優先レビュー（高）
  - 特になし（全主張に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `sbin/stop-connect-server.sh`（ソースコード）
- E-02: `sbin/spark-daemon.sh`（ソースコード・停止処理の実装）
- E-03: `sbin/start-connect-server.sh`（ソースコード・起動スクリプトとの対応確認）
- E-04: `docs/code-to-docs/バッチ一覧/バッチ一覧.csv`（バッチ定義）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | Spark Connectサーバーを停止するスクリプトである | E-01（20行目コメント、26行目stop呼び出し）、E-04 | ○ |
| C-02 | SPARK_HOME未設定時にスクリプト配置場所から自動検出する | E-01（22-24行目） | ○ |
| C-03 | spark-daemon.shにstopコマンドを委譲する | E-01（26行目） | ○ |
| C-04 | 起動クラスはorg.apache.spark.sql.connect.service.SparkConnectServer | E-01（26行目）、E-04 | ○ |
| C-05 | インスタンス番号は固定値1 | E-01（26行目の第3引数） | ○ |
| C-06 | spark-daemon.shのstopはPIDファイルを確認する | E-02（216行目） | ○ |
| C-07 | プロセス生存確認はps -pでjavaプロセスをチェック | E-02（218行目） | ○ |
| C-08 | killシグナル送信後にPIDファイルを削除する | E-02（220行目） | ○ |
| C-09 | 停止対象がない場合は「no ... to stop」メッセージを出力 | E-02（222-226行目） | ○ |
| C-10 | コマンドライン引数を受け取らない | E-01（スクリプト全体に引数処理なし） | ○ |
| C-11 | start-connect-server.shと対になるスクリプトである | E-03、E-04 | ○ |
| C-12 | --waitオプション起動時はPIDファイルがないため本スクリプトでは停止不可 | E-03（42-45行目でSPARK_NO_DAEMONIZE設定）、E-02（138行目） | ○ |
| C-13 | データベース操作を行わない | E-01（スクリプト全体にDB操作なし） | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 非常にシンプルなスクリプトであり、ソースコードから全ての主張を確認可能

## 6) レビュアーチェックリスト（最小）
- [ ] --waitオプションで起動されたConnectサーバーの停止方法が運用ドキュメントに記載されているか確認
- [ ] PIDファイルパスの命名規則が実際の運用環境と一致しているか確認
