---
generated_at: 2026-02-04 10:25:00
metrics:
  claims_total: 25
  claims_with_evidence: 25
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：16-spark-daemon.sh

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：25 / 25、根拠なし：0
- 優先レビュー（高）
  - 特になし（全主張に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `sbin/spark-daemon.sh`（ソースコード・269行）
- E-02: `sbin/spark-config.sh`（ソースコード）
- E-03: `bin/load-spark-env.sh`（ソースコード）
- E-04: `bin/spark-class`（ソースコード）
- E-05: `bin/spark-submit`（ソースコード）
- E-06: `docs/code-to-docs/バッチ一覧/バッチ一覧.csv`（バッチ定義）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | start/stop/submit/decommission/statusの5操作をサポート | E-01（34行目usage文字列、204-264行目case文） | ○ |
| C-02 | SPARK_CONNECT_MODE=0を設定する | E-01（33行目） | ○ |
| C-03 | spark-config.shを読み込む | E-01（46行目） | ○ |
| C-04 | --configオプションでSPARK_CONF_DIRを上書き可能 | E-01（53-66行目） | ○ |
| C-05 | load-spark-env.shを読み込む | E-01（98行目） | ○ |
| C-06 | SPARK_IDENT_STRINGのデフォルトは$USER | E-01（100-106行目） | ○ |
| C-07 | SPARK_LOG_DIRのデフォルトは${SPARK_HOME}/logs | E-01（112-114行目） | ○ |
| C-08 | SPARK_PID_DIRのデフォルトは/tmp | E-01（124-126行目） | ○ |
| C-09 | ログファイル名はspark-${IDENT}-${command}-${instance}-${HOSTNAME}.out | E-01（129行目） | ○ |
| C-10 | PIDファイル名はspark-${IDENT}-${command}-${instance}.pid | E-01（130行目） | ○ |
| C-11 | SPARK_NICENESSのデフォルトは0 | E-01（133-135行目） | ○ |
| C-12 | SPARK_NO_DAEMONIZE未設定時はnohupでバックグラウンド起動 | E-01（138-139行目） | ○ |
| C-13 | SPARK_NO_DAEMONIZE設定時はフォアグラウンド起動 | E-01（160-162行目） | ○ |
| C-14 | プロセス起動後0.5秒間隔で最大10回ポーリング | E-01（145-151行目） | ○ |
| C-15 | ポーリング後2秒スリープしてプロセス生存確認 | E-01（153-159行目） | ○ |
| C-16 | startモードはspark-class経由で起動 | E-01（188-189行目） | ○ |
| C-17 | submitモードはspark-submit --class経由で起動 | E-01（192-193行目） | ○ |
| C-18 | stopはkillシグナル送信後PIDファイルを削除 | E-01（220行目） | ○ |
| C-19 | decommissionはSIGPWRシグナルを送信 | E-01（235行目） | ○ |
| C-20 | decommissionではPIDファイルを削除しない | E-01（229-241行目、PIDファイル削除なし） | ○ |
| C-21 | statusの終了コード: 稼働中=0、PIDあり停止=1、PIDなし=2 | E-01（249行目、254行目、257行目） | ○ |
| C-22 | ログローテーションはSPARK_LOG_MAX_FILES件数を管理 | E-01（75-96行目） | ○ |
| C-23 | SPARK_LOG_MAX_FILESのデフォルトは5 | E-01（80行目） | ○ |
| C-24 | SPARK_MASTER設定時にrsyncでコード同期 | E-01（179-181行目） | ○ |
| C-25 | 既存プロセス稼働中は起動を拒否する | E-01（171-177行目） | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全主張がソースコードから直接確認可能

## 6) レビュアーチェックリスト（最小）
- [ ] SPARK_PID_DIRのデフォルト(/tmp)がマルチユーザー環境で問題ないか確認
- [ ] ログローテーションのファイル数(デフォルト5)が運用要件を満たすか確認
- [ ] decommission時のSIGPWRシグナルが対象プロセスで正しくハンドリングされるか確認
- [ ] rsync機能（SPARK_MASTER設定時）がセキュリティポリシーに適合するか確認
