---
generated_at: 2026-02-04 10:30:00
metrics:
  claims_total: 11
  claims_with_evidence: 11
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：17-spark-daemons.sh

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：11 / 11、根拠なし：0
- 優先レビュー（高）
  - 特になし（全主張に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `sbin/spark-daemons.sh`（ソースコード）
- E-02: `sbin/workers.sh`（ソースコード）
- E-03: `sbin/spark-config.sh`（ソースコード）
- E-04: `sbin/spark-daemon.sh`（ソースコード）
- E-05: `docs/code-to-docs/バッチ一覧/バッチ一覧.csv`（バッチ定義）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 全Workerノードに対してデーモン操作を実行するスクリプトである | E-01（20行目コメント）、E-05 | ○ |
| C-02 | 引数が1個以下の場合usageを表示して終了 | E-01（25-28行目） | ○ |
| C-03 | SPARK_HOME未設定時にスクリプト配置場所から自動検出 | E-01（30-32行目） | ○ |
| C-04 | spark-config.shを読み込む | E-01（34行目） | ○ |
| C-05 | workers.shを経由してコマンドを分配する | E-01（36行目） | ○ |
| C-06 | 各ノードでcdしてからspark-daemon.shを実行する | E-01（36行目のコマンド構造） | ○ |
| C-07 | execコマンドでworkers.shを呼び出す | E-01（36行目のexec） | ○ |
| C-08 | workers.shはconf/workersファイルからホスト一覧を取得 | E-02（78-79行目） | ○ |
| C-09 | workers.shはSSH経由でリモートコマンドを実行 | E-02（105-109行目） | ○ |
| C-10 | usage文字列にstart|stopとcommand、instance-numberが含まれる | E-01（22行目） | ○ |
| C-11 | 本スクリプトはworkers.shとspark-daemon.shの薄いラッパーである | E-01（スクリプト全体が37行と非常に短い） | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 非常にシンプルなラッパースクリプトであり、ソースコードから全ての主張を確認可能

## 6) レビュアーチェックリスト（最小）
- [ ] workersファイルが正しく配置・記述されているか確認
- [ ] 全WorkerノードへのパスワードなしSSH接続が設定されているか確認
