---
generated_at: 2026-02-04 10:35:00
metrics:
  claims_total: 18
  claims_with_evidence: 18
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：18-workers.sh

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：18 / 18、根拠なし：0
- 優先レビュー（高）
  - 特になし（全主張に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `sbin/workers.sh`（ソースコード・121行）
- E-02: `sbin/spark-config.sh`（ソースコード）
- E-03: `bin/load-spark-env.sh`（ソースコード）
- E-04: `docs/code-to-docs/バッチ一覧/バッチ一覧.csv`（バッチ定義）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | conf/workersに記載された全ホストでコマンドをSSH実行する | E-01（20行目コメント）、E-04 | ○ |
| C-02 | 引数が0個の場合usageを表示して終了 | E-01（34-37行目） | ○ |
| C-03 | SPARK_HOME未設定時にスクリプト配置場所から自動検出 | E-01（39-41行目） | ○ |
| C-04 | spark-config.shを読み込む | E-01（43行目） | ○ |
| C-05 | SPARK_WORKERS環境変数でホストファイルを指定可能 | E-01（48-49行目、86-88行目） | ○ |
| C-06 | SPARK_SLAVESは非推奨で警告を出力 | E-01（51-53行目、89-91行目） | ○ |
| C-07 | --configオプションでSPARK_CONF_DIRを上書き可能 | E-01（59-72行目） | ○ |
| C-08 | load-spark-env.shを読み込む | E-01（74行目） | ○ |
| C-09 | conf/workersが存在しない場合conf/slavesにフォールバック | E-01（80-81行目） | ○ |
| C-10 | いずれのファイルも存在しない場合localhostがデフォルト | E-01（83行目） | ○ |
| C-11 | SSHデフォルトオプションはStrictHostKeyChecking=no | E-01（99-101行目） | ○ |
| C-12 | ホストリストのコメント(#)と空行はsedで除外 | E-01（103行目） | ○ |
| C-13 | SPARK_SSH_FOREGROUND設定時はフォアグラウンド逐次実行 | E-01（104-106行目） | ○ |
| C-14 | デフォルトではバックグラウンド並列実行（&付き） | E-01（107-109行目） | ○ |
| C-15 | 各ノード出力に「ホスト名: 」プレフィックスを付与 | E-01（106行目、109行目のsed） | ○ |
| C-16 | SPARK_WORKER_SLEEPでノード間にスリープ挿入可能 | E-01（111-113行目） | ○ |
| C-17 | SPARK_SLAVE_SLEEPは非推奨 | E-01（114-116行目） | ○ |
| C-18 | 全バックグラウンドプロセスの完了をwaitで待機 | E-01（120行目） | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし

## 5) リスクフラグ（レビュー観点）
- 1: 中リスク - SSHのStrictHostKeyChecking=noがセキュリティ上の懸念となる可能性がある

## 6) レビュアーチェックリスト（最小）
- [ ] SSHのStrictHostKeyChecking=noがセキュリティポリシーに適合するか確認
- [ ] conf/workersファイルが正しく配置・記述されているか確認
- [ ] 全Workerノードへのパスワードなしのssh接続が設定されているか確認
- [ ] 非推奨のSPARK_SLAVES/conf/slavesが使用されていないか確認
