---
generated_at: 2026-02-04 10:05:00
metrics:
  claims_total: 13
  claims_with_evidence: 13
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：2-stop-all.sh バッチ設計書

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：13 / 13、根拠なし：0
- 優先レビュー（高）
  - なし（全主張に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `sbin/stop-all.sh`（ソースコード）
- E-02: `sbin/spark-config.sh`（ソースコード）
- E-03: `sbin/stop-workers.sh`（ソースコード）
- E-04: `sbin/stop-master.sh`（ソースコード）
- E-05: `sbin/spark-daemon.sh`（ソースコード）
- E-06: `sbin/workers.sh`（ソースコード）
- E-07: `docs/code-to-docs/バッチ一覧/バッチ一覧.csv`（バッチ一覧）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | stop-all.shは全デーモンを一括停止する | E-01 L20-21, L31-32 | ○ |
| C-02 | Workerを先に停止しMasterを後に停止する | E-01 L30-32 | ○ |
| C-03 | --waitオプションでWorker停止を待機する | E-01 L34-49 | ○ |
| C-04 | 10秒間隔でポーリングする | E-01 L46 | ○ |
| C-05 | ps -efとgrepでWorkerプロセスの存在を確認する | E-01 L39 | ○ |
| C-06 | deploy.worker.Workerプロセスをgrepで検出する | E-01 L39 | ○ |
| C-07 | SPARK_HOMEが未設定の場合自動検出する | E-01 L23-25 | ○ |
| C-08 | spark-config.shをsourceする | E-01 L28 | ○ |
| C-09 | stop-workers.shを呼び出す | E-01 L31 | ○ |
| C-10 | stop-master.shを呼び出す | E-01 L32 | ○ |
| C-11 | 停止はkillシグナルで行われPIDファイルを削除する | E-05 L216-226 | ○ |
| C-12 | デーモン未起動時は"no {command} to stop"と出力 | E-05 L222-223, L225 | ○ |
| C-13 | 完了メッセージ"All workers successfully shut down."を出力 | E-01 L42 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし。全主張に対してソースコードから根拠が確認できた。

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 停止処理のオーケストレーションスクリプトであり、--wait時の無限ループのみ注意が必要

## 6) レビュアーチェックリスト（最小）
- [ ] Worker -> Masterの停止順序が要件に合致しているか確認
- [ ] --wait時の無限ループにタイムアウトが不要か運用要件と照合
- [ ] grep対象の文字列"deploy.worker.Worker"が正しいか確認
