---
generated_at: 2026-02-04 10:45:00
metrics:
  claims_total: 16
  claims_with_evidence: 14
  claims_without_evidence: 2
confidence_derived: 0.88
---

# 根拠レポート：20-spark-submit

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.88**
  - 根拠あり：14 / 16、根拠なし：2
- 優先レビュー（高）
  1. **入力パラメータ一覧**：シェルスクリプトからは読み取れないパラメータ仕様（SparkSubmitクラス内部の実装）
  2. **デフォルト値（local[*]、1g等）**：SparkSubmitのJavaソースコードを確認する必要がある

## 2) 参照した情報（Evidence一覧）

- E-01: `bin/spark-submit`（ソースコード・28行）
- E-02: `bin/spark-class`（ソースコード・113行）
- E-03: `bin/find-spark-home`（ソースコード参照）
- E-04: `bin/load-spark-env.sh`（ソースコード）
- E-05: `sbin/spark-daemon.sh`（ソースコード・submitモードでの利用確認）
- E-06: `docs/code-to-docs/バッチ一覧/バッチ一覧.csv`（バッチ定義）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | Sparkアプリケーションをクラスタに投入するコマンドである | E-01、E-06 | ○ |
| C-02 | SPARK_HOME未設定時にfind-spark-home経由で検出する | E-01（20-22行目） | ○ |
| C-03 | PYTHONHASHSEED=0を設定する | E-01（25行目） | ○ |
| C-04 | exec spark-class org.apache.spark.deploy.SparkSubmitを実行する | E-01（27行目） | ○ |
| C-05 | spark-classはload-spark-env.shを読み込む | E-02（24行目） | ○ |
| C-06 | spark-classはJava実行環境を検出する | E-02（27-36行目） | ○ |
| C-07 | spark-classはクラスパスを${SPARK_HOME}/jars/*から構築する | E-02（39-51行目） | ○ |
| C-08 | ランチャーはorg.apache.spark.launcher.Mainで最大128MB | E-02（71行目の-Xmx128m） | ○ |
| C-09 | ランチャーの出力をNULL文字区切りで解析する | E-02（64-68行目のコメント、78-93行目） | ○ |
| C-10 | spark-daemon.shのsubmitモードからspark-submit --classで呼び出される | E-05（193行目） | ○ |
| C-11 | start-thriftserver.shがsubmitモード経由で利用する | E-05（192-193行目）、`sbin/start-thriftserver.sh`（61行目） | ○ |
| C-12 | start-connect-server.shがsubmitモード経由で利用する | E-05（192-193行目）、`sbin/start-connect-server.sh`（46行目） | ○ |
| C-13 | execコマンドでspark-classを呼び出す | E-01（27行目のexec） | ○ |
| C-14 | SPARK_TESTING設定時にYARN_CONF_DIR、HADOOP_CONF_DIRをunsetする | E-02（59-62行目） | ○ |
| C-15 | 入力パラメータ一覧（--class, --master, --deploy-mode等のデフォルト値） | **根拠なし** | △ |
| C-16 | ドライバー/エグゼキュータのデフォルトメモリ1g | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- 入力パラメータの詳細仕様（デフォルト値を含む）はSparkSubmitクラスのJavaソースコードに実装されているため、シェルスクリプトのみからは確認できない。
  - 候補：`org.apache.spark.deploy.SparkSubmit` のソースコード / Spark公式ドキュメント / `spark-submit --help` の出力
- デフォルトメモリ量（1g）等のデフォルト値はSparkConfigのJavaソースコードを確認する必要がある。
  - 候補：`org.apache.spark.SparkConf` のソースコード / Spark公式ドキュメント

## 5) リスクフラグ（レビュー観点）
- 1: 中リスク - 入力パラメータのデフォルト値がシェルスクリプトからは確認できないため、Spark公式ドキュメントとの整合性確認が必要

## 6) レビュアーチェックリスト（最小）
- [ ] 入力パラメータ一覧のデフォルト値がSpark公式ドキュメントと一致しているか確認
- [ ] spark-submit --helpの出力と設計書の記載が一致しているか確認
- [ ] 対応するクラスタマネージャー一覧（local, spark://, yarn, mesos://, k8s://）が最新か確認
- [ ] PYTHONHASHSEED=0の設定がPySparkアプリケーションの動作に影響しないか確認
