---
generated_at: 2026-02-04 10:00:00
metrics:
  claims_total: 20
  claims_with_evidence: 20
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：21-spark-class バッチ設計書

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：20 / 20、根拠なし：0
- 優先レビュー（高）
  - 該当なし（全主張に根拠あり）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。

- E-01: `bin/spark-class`（ソースコード全体、113行）
- E-02: `bin/load-spark-env.sh`（spark-env.sh読み込みスクリプト）
- E-03: `bin/find-spark-home`（SPARK_HOME検出スクリプト）
- E-04: `bin/spark-submit`（spark-classを呼び出す上位スクリプト）
- E-05: `bin/beeline`（spark-classを呼び出す上位スクリプト）
- E-06: `bin/spark-pipelines`（spark-classを呼び出す上位スクリプト）
- E-07: `docs/code-to-docs/バッチ一覧/バッチ一覧.csv`（バッチ一覧定義）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | SPARK_HOMEが未設定の場合find-spark-homeをsourceする | E-01 (行20-22) | ○ |
| C-02 | load-spark-env.shをsourceしてSpark環境変数を設定する | E-01 (行24) | ○ |
| C-03 | JAVA_HOMEが設定されている場合JAVA_HOME/bin/javaをRUNNERに設定 | E-01 (行27-28) | ○ |
| C-04 | JAVA_HOMEもjavaコマンドもない場合exit 1 | E-01 (行33-34) | ○ |
| C-05 | SPARK_HOME/jarsを優先してSPARK_JARS_DIRを設定 | E-01 (行39-43) | ○ |
| C-06 | JARディレクトリが存在しない場合テスト以外ではエラー終了 | E-01 (行45-48) | ○ |
| C-07 | SPARK_PREPEND_CLASSESでlauncher/targetを先頭追加 | E-01 (行54-56) | ○ |
| C-08 | SPARK_TESTINGでYARN_CONF_DIR等を解除 | E-01 (行59-61) | ○ |
| C-09 | ランチャーはorg.apache.spark.launcher.Mainを-Xmx128mで実行 | E-01 (行71) | ○ |
| C-10 | ランチャー出力をNULL区切りで解析 | E-01 (行67-69, 77-93) | ○ |
| C-11 | 終了コードが整数でない場合エラー終了 | E-01 (行102-105) | ○ |
| C-12 | 終了コードが非ゼロの場合エラー終了 | E-01 (行107-109) | ○ |
| C-13 | 最終的にexecでコマンドを実行 | E-01 (行112) | ○ |
| C-14 | posixモードを無効化してプロセス置換を使用 | E-01 (行76) | ○ |
| C-15 | spark-submitはspark-classを呼び出す | E-04 (行27) | ○ |
| C-16 | beelineはspark-classを呼び出す | E-05 (行32) | ○ |
| C-17 | spark-pipelinesはspark-classを呼び出す | E-06 (行40) | ○ |
| C-18 | SPARK_LAUNCHER_OPTSでランチャーにオプションを渡せる | E-01 (行71) | ○ |
| C-19 | バッチ一覧でのカテゴリは「クライアント実行」 | E-07 (行22) | ○ |
| C-20 | 起動クラス名はランチャー経由でクラスパスを構築しJava実行 | E-07 (行22), E-01 | ○ |

## 4) 不足情報（Unknown / Missing）
- 該当なし。全主張にソースコードの根拠あり。

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全主張がソースコードに基づいており、推測要素なし

## 6) レビュアーチェックリスト（最小）
- [ ] build_command関数のランチャー出力解析ロジックが正確に記述されているか確認
- [ ] エラーケースの網羅性が十分か確認
- [ ] 他のスクリプトからの呼び出し関係が正確か確認
