---
generated_at: 2026-02-04 10:10:00
metrics:
  claims_total: 12
  claims_with_evidence: 12
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：23-spark-sql バッチ設計書

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：12 / 12、根拠なし：0
- 優先レビュー（高）
  - 該当なし（全主張に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `bin/spark-sql`（ソースコード全体、27行）
- E-02: `bin/spark-submit`（spark-submitスクリプト）
- E-03: `bin/find-spark-home`（SPARK_HOME検出スクリプト）
- E-04: `docs/code-to-docs/バッチ一覧/バッチ一覧.csv`（バッチ一覧定義）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | SPARK_CONNECT_MODE=0をexportする | E-01 (行19) | ○ |
| C-02 | SPARK_HOMEが未設定の場合find-spark-homeをsource | E-01 (行21-23) | ○ |
| C-03 | _SPARK_CMD_USAGEを設定する | E-01 (行25) | ○ |
| C-04 | exec spark-submit --class SparkSQLCLIDriverを実行する | E-01 (行26) | ○ |
| C-05 | 起動クラスはorg.apache.spark.sql.hive.thriftserver.SparkSQLCLIDriver | E-01 (行26) | ○ |
| C-06 | execでプロセスを置換する | E-01 (行26) | ○ |
| C-07 | スクリプトはターミナル設定の保存・復元を行わない | E-01 (全体) | ○ |
| C-08 | 引数はすべてspark-submitに渡される | E-01 (行26, "$@") | ○ |
| C-09 | Spark Connectモードは無効化される | E-01 (行19) | ○ |
| C-10 | バッチ一覧でのカテゴリは「クライアント実行」 | E-04 (行24) | ○ |
| C-11 | spark-submitを経由して起動する | E-01 (行26), E-02 | ○ |
| C-12 | Hive Thrift Serverパッケージに含まれるクラスを使用 | E-01 (行26, クラス名) | ○ |

## 4) 不足情報（Unknown / Missing）
- 該当なし。全主張にソースコードの根拠あり。

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - スクリプトが非常にシンプルで、全主張がソースコードに基づいている

## 6) レビュアーチェックリスト（最小）
- [ ] SPARK_CONNECT_MODE=0の設定意図が正確に記述されているか確認
- [ ] SparkSQLCLIDriverクラスの正確なパッケージ名が一致しているか確認
