---
generated_at: 2026-02-04 10:15:00
metrics:
  claims_total: 22
  claims_with_evidence: 22
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：24-pyspark バッチ設計書

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：22 / 22、根拠なし：0
- 優先レビュー（高）
  - 該当なし（全主張に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `bin/pyspark`（ソースコード全体、103行）
- E-02: `bin/load-spark-env.sh`（spark-env.sh読み込みスクリプト）
- E-03: `bin/find-spark-home`（SPARK_HOME検出スクリプト）
- E-04: `bin/spark-submit`（spark-submitスクリプト）
- E-05: `docs/code-to-docs/バッチ一覧/バッチ一覧.csv`（バッチ一覧定義）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | SPARK_HOMEが未設定の場合find-spark-homeをsource | E-01 (行20-22) | ○ |
| C-02 | load-spark-env.shをsource | E-01 (行24) | ○ |
| C-03 | _SPARK_CMD_USAGEを設定 | E-01 (行25) | ○ |
| C-04 | IPYTHONまたはIPYTHON_OPTSが設定されている場合エラー終了 | E-01 (行34-38) | ○ |
| C-05 | PYSPARK_PYTHONのデフォルトはpython3 | E-01 (行41-42) | ○ |
| C-06 | PYSPARK_DRIVER_PYTHONのデフォルトはPYSPARK_PYTHON | E-01 (行44-46) | ○ |
| C-07 | JAVA_HOMEが設定済みの場合JAVA_HOME/bin/javaをRUNNERに設定 | E-01 (行54-55) | ○ |
| C-08 | javaコマンドが見つかる場合RUNNERに設定 | E-01 (行57-58) | ○ |
| C-09 | JAVA_HOME未設定時にJDK 17のインストールを対話的に提案 | E-01 (行60-74) | ○ |
| C-10 | JDKインストールはpip install install-jdkを使用 | E-01 (行66) | ○ |
| C-11 | JDKインストール拒否時はexit 1 | E-01 (行72-73) | ○ |
| C-12 | PYTHONPATHにSPARK_HOME/python/を追加 | E-01 (行79) | ○ |
| C-13 | PYTHONPATHにpy4j-0.10.9.9-src.zipを追加 | E-01 (行80) | ○ |
| C-14 | OLD_PYTHONSTARTUPに既存のPYTHONSTARTUPを退避 | E-01 (行83) | ○ |
| C-15 | PYTHONSTARTUPにpyspark/shell.pyを設定 | E-01 (行84) | ○ |
| C-16 | SPARK_CONNECT_MODEをpyspark.utilで判定 | E-01 (行86) | ○ |
| C-17 | SPARK_CONNECT_MODEが0でも1でもない場合は警告してunset | E-01 (行88-91) | ○ |
| C-18 | SPARK_TESTINGが設定時はPython直接実行 | E-01 (行94-99) | ○ |
| C-19 | SPARK_TESTING時はYARN_CONF_DIRとHADOOP_CONF_DIRをunset | E-01 (行95-96) | ○ |
| C-20 | SPARK_TESTING時はPYTHONHASHSEED=0を設定 | E-01 (行97) | ○ |
| C-21 | exec spark-submit pyspark-shell-main --name "PySparkShell"を実行 | E-01 (行102) | ○ |
| C-22 | バッチ一覧でのカテゴリは「クライアント実行」でPython3を使用 | E-05 (行25) | ○ |

## 4) 不足情報（Unknown / Missing）
- 該当なし。全主張にソースコードの根拠あり。

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全主張がソースコードに基づいており、推測要素なし

## 6) レビュアーチェックリスト（最小）
- [ ] JDK自動インストール機能のセキュリティ上の考慮が十分か確認
- [ ] py4jバージョン（0.10.9.9）が現在のプロジェクトと一致しているか確認
- [ ] SPARK_CONNECT_MODE判定ロジックの正確性を確認
