---
generated_at: 2026-02-04 10:20:00
metrics:
  claims_total: 12
  claims_with_evidence: 11
  claims_without_evidence: 1
confidence_derived: 0.92
---

# 根拠レポート：25-sparkR バッチ設計書

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.92**
  - 根拠あり：11 / 12、根拠なし：1
- 優先レビュー（高）
  1. **非推奨バージョン情報**：Spark 4.0.0以降での非推奨はバッチ一覧の備考欄からの情報であり、公式リリースノートでの検証が望ましい

## 2) 参照した情報（Evidence一覧）

- E-01: `bin/sparkR`（ソースコード全体、28行）
- E-02: `bin/load-spark-env.sh`（spark-env.sh読み込みスクリプト）
- E-03: `bin/find-spark-home`（SPARK_HOME検出スクリプト）
- E-04: `bin/spark-submit`（spark-submitスクリプト）
- E-05: `docs/code-to-docs/バッチ一覧/バッチ一覧.csv`（バッチ一覧定義）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | SPARK_CONNECT_MODE=0をexportする | E-01 (行19) | ○ |
| C-02 | SPARK_HOMEが未設定の場合find-spark-homeをsource | E-01 (行21-23) | ○ |
| C-03 | load-spark-env.shをsource | E-01 (行25) | ○ |
| C-04 | _SPARK_CMD_USAGEを設定する | E-01 (行26) | ○ |
| C-05 | exec spark-submit sparkr-shell-mainを実行 | E-01 (行27) | ○ |
| C-06 | execでプロセスを置換する | E-01 (行27) | ○ |
| C-07 | Spark Connectモードは無効化される | E-01 (行19) | ○ |
| C-08 | 引数はすべてspark-submitに渡される | E-01 (行27, "$@") | ○ |
| C-09 | spark-submitを経由して起動する | E-01 (行27), E-04 | ○ |
| C-10 | バッチ一覧でのカテゴリは「クライアント実行」 | E-05 (行26) | ○ |
| C-11 | Spark 4.0.0以降で非推奨 | E-05 (行26, 備考欄) | ○ |
| C-12 | PySparkへの移行が推奨される | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- C-12「PySparkへの移行が推奨される」は、一般的な知識として妥当だが、ソースコード内に明示的な記述がない
  - 候補：Sparkの公式ドキュメント / リリースノート / Migration Guide

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - ほぼ全主張がソースコードに基づいている。1件の根拠なしは一般的知識に基づく

## 6) レビュアーチェックリスト（最小）
- [ ] Spark 4.0.0での非推奨情報が最新のリリースノートと一致しているか確認
- [ ] sparkr-shell-mainの実際の動作がスクリプトの記述と整合しているか確認
