---
generated_at: 2026-02-04 10:35:00
metrics:
  claims_total: 15
  claims_with_evidence: 15
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：28-spark-pipelines バッチ設計書

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：15 / 15、根拠なし：0
- 優先レビュー（高）
  - 該当なし（全主張に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `bin/spark-pipelines`（ソースコード全体、41行）
- E-02: `bin/spark-class`（spark-classスクリプト）
- E-03: `bin/find-spark-home`（SPARK_HOME検出スクリプト）
- E-04: `docs/code-to-docs/バッチ一覧/バッチ一覧.csv`（バッチ一覧定義）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | PYSPARK_PYTHONが未設定の場合python3をデフォルトに設定 | E-01 (行21-23) | ○ |
| C-02 | SPARK_HOMEが未設定の場合find-spark-homeをsource | E-01 (行25-27) | ○ |
| C-03 | PYTHONPATHにSPARK_HOME/python/を追加 | E-01 (行30) | ○ |
| C-04 | PYTHONPATHにpy4j-0.10.9.9-src.zipを追加 | E-01 (行31) | ○ |
| C-05 | ヒアドキュメントでPythonコードを実行してCLIパスを取得 | E-01 (行33-38) | ○ |
| C-06 | pysparkパッケージからpipelines/cli.pyのパスを動的解決 | E-01 (行34-37) | ○ |
| C-07 | SDP_CLI_PY_FILE_PATHに結果を格納 | E-01 (行33) | ○ |
| C-08 | exec spark-class org.apache.spark.deploy.SparkPipelinesを実行 | E-01 (行40) | ○ |
| C-09 | SDP_CLI_PY_FILE_PATHが第1引数として渡される | E-01 (行40) | ○ |
| C-10 | ユーザー引数（$@）がCLIパスの後に渡される | E-01 (行40) | ○ |
| C-11 | execでプロセスを置換する | E-01 (行40) | ○ |
| C-12 | spark-classを直接使用する（spark-submitは使用しない） | E-01 (行40), E-02 | ○ |
| C-13 | 起動クラスはorg.apache.spark.deploy.SparkPipelines | E-01 (行40), E-04 (行29) | ○ |
| C-14 | バッチ一覧でのカテゴリは「クライアント実行」 | E-04 (行29) | ○ |
| C-15 | pathlib.Pathを使用してパスを構築 | E-01 (行36) | ○ |

## 4) 不足情報（Unknown / Missing）
- 該当なし。全主張にソースコードの根拠あり。

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全主張がソースコードに基づいており、推測要素なし

## 6) レビュアーチェックリスト（最小）
- [ ] pyspark.pipelines.cli.pyが実際に存在するか確認
- [ ] py4jバージョン（0.10.9.9）が現在のプロジェクトと一致しているか確認
- [ ] SparkPipelinesクラスがSparkのビルドに含まれているか確認
