---
generated_at: 2026-02-04 10:10:00
metrics:
  claims_total: 14
  claims_with_evidence: 14
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：3-start-master.sh バッチ設計書

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：14 / 14、根拠なし：0
- 優先レビュー（高）
  - なし（全主張に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `sbin/start-master.sh`（ソースコード）
- E-02: `sbin/spark-config.sh`（ソースコード）
- E-03: `sbin/spark-daemon.sh`（ソースコード）
- E-04: `bin/load-spark-env.sh`（ソースコード参照）
- E-05: `docs/code-to-docs/バッチ一覧/バッチ一覧.csv`（バッチ一覧）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 起動クラスはorg.apache.spark.deploy.master.Master | E-01 L28 | ○ |
| C-02 | デフォルトポートは7077 | E-01 L47-49 | ○ |
| C-03 | デフォルトWebUIポートは8080 | E-01 L62-64 | ○ |
| C-04 | ホスト名はhostname -fで取得 | E-01 L57 | ○ |
| C-05 | SunOSでは/usr/sbin/check-hostnameを使用 | E-01 L53-54 | ○ |
| C-06 | --help/-hでヘルプ表示 | E-01 L30-39 | ○ |
| C-07 | spark-config.shをsourceする | E-01 L43 | ○ |
| C-08 | load-spark-env.shをsourceする | E-01 L45 | ○ |
| C-09 | spark-daemon.sh start経由で起動する | E-01 L66-68 | ○ |
| C-10 | インスタンス番号は1固定 | E-01 L66 | ○ |
| C-11 | PIDファイルによる排他制御 | E-03 L171-177 | ○ |
| C-12 | 起動後5秒間Javaプロセスをポーリング | E-03 L144-151 | ○ |
| C-13 | 起動失敗時にログ末尾10行を表示 | E-03 L155-159 | ○ |
| C-14 | クラス名はSparkSubmitでも参照される旨のコメント | E-01 L27 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし。全主張に対してソースコードから根拠が確認できた。

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 標準的なデーモン起動スクリプト

## 6) レビュアーチェックリスト（最小）
- [ ] デフォルトポート（7077、8080）が運用環境で使用可能か確認
- [ ] ホスト名取得方法（hostname -f）が運用環境で正しく動作するか確認
- [ ] spark-env.shでのMaster関連環境変数の設定が適切か確認
