---
generated_at: 2026-02-04 10:45:00
metrics:
  claims_total: 18
  claims_with_evidence: 18
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：30-load-spark-env.sh バッチ設計書

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：18 / 18、根拠なし：0
- 優先レビュー（高）
  - 該当なし（全主張に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `bin/load-spark-env.sh`（ソースコード全体、71行）
- E-02: `bin/find-spark-home`（SPARK_HOME検出スクリプト）
- E-03: `bin/spark-class`（load-spark-env.shを呼び出すスクリプト）
- E-04: `bin/pyspark`（load-spark-env.shを呼び出すスクリプト）
- E-05: `bin/sparkR`（load-spark-env.shを呼び出すスクリプト）
- E-06: `docs/code-to-docs/バッチ一覧/バッチ一覧.csv`（バッチ一覧定義）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | SPARK_HOMEが未設定の場合find-spark-homeをsource | E-01 (行25-27) | ○ |
| C-02 | SPARK_ENV_LOADEDで二重読み込みを防止 | E-01 (行30) | ○ |
| C-03 | SPARK_ENV_LOADED=1をexport | E-01 (行31) | ○ |
| C-04 | SPARK_CONF_DIRのデフォルトは${SPARK_HOME}/conf | E-01 (行33) | ○ |
| C-05 | spark-env.shが存在する場合のみ読み込む | E-01 (行36) | ○ |
| C-06 | set -aで全変数をexportしてspark-env.shをsource | E-01 (行38-39) | ○ |
| C-07 | set +aでexportモードを解除 | E-01 (行40) | ○ |
| C-08 | SPARK_SCALA_VERSION=2.13を固定設定 | E-01 (行45) | ○ |
| C-09 | 以前の動的判定ロジックがコメントアウトされている | E-01 (行46-65) | ○ |
| C-10 | バックグラウンドプロセス判定はps -o stat= -p $$で行う | E-01 (行68) | ○ |
| C-11 | 標準入力がパイプでないことも判定条件 | E-01 (行68) | ○ |
| C-12 | SPARK_BEELINE_OPTSに-Djline.terminal=jline.UnsupportedTerminalを追加 | E-01 (行69) | ○ |
| C-13 | spark-classからsourceされる | E-03 (行24) | ○ |
| C-14 | pysparkからsourceされる | E-04 (行24) | ○ |
| C-15 | sparkRからsourceされる | E-05 (行25) | ○ |
| C-16 | spark-env.shが存在しない場合はスキップされる | E-01 (行36, 条件分岐) | ○ |
| C-17 | バッチ一覧でのカテゴリは「環境設定」 | E-06 (行31) | ○ |
| C-18 | Scala 2.13がデフォルト | E-06 (行31), E-01 (行45) | ○ |

## 4) 不足情報（Unknown / Missing）
- 該当なし。全主張にソースコードの根拠あり。

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全主張がソースコードに基づいており、推測要素なし

## 6) レビュアーチェックリスト（最小）
- [ ] SPARK_SCALA_VERSION=2.13の固定値が現在のプロジェクト方針と一致しているか確認
- [ ] BeeLineバックグラウンド判定ロジック（ps -o stat=）が各OS環境で正しく動作するか確認
- [ ] set -a / set +aによる変数exportの影響範囲が適切か確認
