---
generated_at: 2026-02-04 10:00:00
metrics:
  claims_total: 15
  claims_with_evidence: 14
  claims_without_evidence: 1
confidence_derived: 0.93
---

# 根拠レポート：31-find-spark-home

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.93**
  - 根拠あり：14 / 15、根拠なし：1
- 優先レビュー（高）
  1. **目標処理時間1秒未満**：根拠不足（推測値）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `bin/find-spark-home`（Bashスクリプト本体、42行）
- E-02: `python/pyspark/find_spark_home.py`（Python検出スクリプト、96行）
- E-03: `docs/code-to-docs/バッチ一覧/バッチ一覧.csv`（バッチ一覧定義、行31）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | SPARK_HOMEが設定済みの場合exit 0で即終了する | E-01（25-26行目） | ○ |
| C-02 | find_spark_home.pyの存在によりpipインストール環境を判定する | E-01（27-29行目） | ○ |
| C-03 | ソースビルド環境ではスクリプトの親ディレクトリをSPARK_HOMEとする | E-01（33行目） | ○ |
| C-04 | pipインストール環境ではPythonスクリプト経由でSPARK_HOMEを検出する | E-01（40行目） | ○ |
| C-05 | PYSPARK_DRIVER_PYTHON→PYSPARK_PYTHON→python3の優先順でPythonを決定する | E-01（37-39行目） | ○ |
| C-06 | Python検出スクリプトはbin/spark-submitとjars/assemblyの存在でSPARK_HOMEを検証する | E-02（35-38行目） | ○ |
| C-07 | spark-distributionディレクトリ配下も検索候補に含まれる | E-02（42-43行目） | ○ |
| C-08 | pipインストールされたpysparkモジュールのパスも候補に含まれる | E-02（58-64行目） | ○ |
| C-09 | SPARK_HOME検出失敗時にexit -1で終了する | E-02（91行目） | ○ |
| C-10 | 検出失敗時にpipインストール環境向けのガイダンスメッセージを表示する | E-02（77-89行目） | ○ |
| C-11 | 本スクリプトはspark-submit等のCLIスクリプトからsource呼び出しされる | E-01（20行目コメント） | ○ |
| C-12 | SPARK-32017対応でspark-distributionディレクトリ検索が追加された | E-02（41行目コメント） | ○ |
| C-13 | edit modeインストール時は2階層上も検索する | E-02（64行目） | ○ |
| C-14 | 候補パスは最初にマッチしたものが採用される | E-02（73行目、next()使用） | ○ |
| C-15 | 目標処理時間は1秒未満 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- 目標処理時間1秒未満はソースコードに明示されておらず、スクリプトの性質から推測した値である
  - 候補：Spark公式ドキュメント / パフォーマンステスト結果 / 開発チーム方針

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 本スクリプトは環境変数設定のみのシンプルなユーティリティであり、設計書の記述はソースコードと高い整合性を持つ

## 6) レビュアーチェックリスト（最小）
- [ ] SPARK_HOME検出の優先順位がソースコードと一致しているか確認
- [ ] pipインストール環境での検出パスリストが網羅的か確認
- [ ] Pythonインタープリタの選択ロジック（PYSPARK_DRIVER_PYTHON→PYSPARK_PYTHON→python3）が正確か確認
